/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.ComposableRecordStore;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.IntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.logging.LogProvider;

public class RelationshipGroupStore
extends ComposableRecordStore<RelationshipGroupRecord, IntStoreHeader> {
    public static final String TYPE_DESCRIPTOR = "RelationshipGroupStore";

    public RelationshipGroupStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormat<RelationshipGroupRecord> recordFormat, String storeVersion) {
        super(fileName, config, IdType.RELATIONSHIP_GROUP, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormat, storeVersion, new IntStoreHeaderFormat(config.get(GraphDatabaseSettings.dense_node_threshold)));
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RelationshipGroupRecord record) throws FAILURE {
        processor.processRelationshipGroup(this, record);
    }

    @Override
    public void updateRecord(RelationshipGroupRecord record) {
        super.updateRecord(record);
    }
}

