/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.util.Set;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.builtinprocs.BuiltInProcedures;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureJarLoader;
import org.neo4j.kernel.impl.proc.ProcedureRegistry;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class Procedures
extends LifecycleAdapter {
    private final ProcedureRegistry registry = new ProcedureRegistry();
    private final TypeMappers typeMappers = new TypeMappers();
    private final ComponentRegistry components = new ComponentRegistry();
    private final ReflectiveProcedureCompiler compiler = new ReflectiveProcedureCompiler(this.typeMappers, this.components);
    private final ThrowingConsumer<Procedures, ProcedureException> builtin;
    private final File pluginDir;
    private final Log log;

    public Procedures() {
        this(new BuiltInProcedures("N/A"), null, (Log)NullLog.getInstance());
    }

    public Procedures(ThrowingConsumer<Procedures, ProcedureException> builtin, File pluginDir, Log log) {
        this.builtin = builtin;
        this.pluginDir = pluginDir;
        this.log = log;
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        this.registry.register(proc);
    }

    public void register(Class<?> proc) throws KernelException {
        for (CallableProcedure procedure : this.compiler.compile(proc)) {
            this.register(procedure);
        }
    }

    public void registerType(Class<?> javaClass, TypeMappers.NeoValueConverter toNeo) {
        this.typeMappers.registerType(javaClass, toNeo);
    }

    public <T> void registerComponent(Class<T> cls, ComponentRegistry.Provider<T> provider) {
        this.components.register(cls, provider);
    }

    public ProcedureSignature get(ProcedureSignature.ProcedureName name) throws ProcedureException {
        return this.registry.get(name);
    }

    public Set<ProcedureSignature> getAll() {
        return this.registry.getAll();
    }

    public RawIterator<Object[], ProcedureException> call(CallableProcedure.Context ctx, ProcedureSignature.ProcedureName name, Object[] input) throws ProcedureException {
        return this.registry.call(ctx, name, input);
    }

    public void start() throws Throwable {
        ProcedureJarLoader loader = new ProcedureJarLoader(this.compiler, this.log);
        for (CallableProcedure procedure : loader.loadProceduresFromDir(this.pluginDir)) {
            this.register(procedure);
        }
        this.builtin.accept((Object)this);
    }
}

