/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.api.AccessMode;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;

public class TopLevelTransaction
implements InternalTransaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private boolean successCalled;
    private final Supplier<Statement> stmt;
    private final KernelTransaction transaction;

    public TopLevelTransaction(KernelTransaction transaction, Supplier<Statement> stmt) {
        this.stmt = stmt;
        this.transaction = transaction;
    }

    public void failure() {
        this.transaction.failure();
    }

    public void success() {
        this.successCalled = true;
        this.transaction.success();
    }

    public final void terminate() {
        this.transaction.markForTermination();
    }

    public void close() {
        try {
            if (this.transaction.isOpen()) {
                this.transaction.close();
            }
        }
        catch (TransientFailureException e) {
            throw e;
        }
        catch (ConstraintViolationTransactionFailureException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            String userMessage;
            String string = userMessage = this.successCalled ? "Transaction was marked as successful, but unable to commit transaction so rolled back." : "Unable to rollback transaction";
            if (e instanceof KernelException && ((KernelException)e).status().code().classification() == Status.Classification.TransientError) {
                throw new TransientTransactionFailureException(userMessage, (Throwable)e);
            }
            throw new TransactionFailureException(userMessage, (Throwable)e);
        }
    }

    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.stmt, entity);
    }

    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.stmt, entity);
    }

    @Deprecated
    public KernelTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public KernelTransaction.Type transactionType() {
        return this.transaction.transactionType();
    }

    @Override
    public AccessMode mode() {
        return this.transaction.mode();
    }
}

