/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.state.PropertyContainerStateImpl;
import org.neo4j.kernel.impl.api.state.StateDefaults;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.storageengine.api.txstate.RelationshipState;

public class RelationshipStateImpl
extends PropertyContainerStateImpl
implements RelationshipState {
    private long startNode = -1L;
    private long endNode = -1L;
    private int type = -1;

    RelationshipStateImpl(long id) {
        super(id);
    }

    public void setMetaData(long startNode, long endNode, int type) {
        this.startNode = startNode;
        this.endNode = endNode;
        this.type = type;
    }

    @Override
    public <EX extends Exception> boolean accept(RelationshipVisitor<EX> visitor) throws EX {
        if (this.type != -1) {
            visitor.visit(this.getId(), this.type, this.startNode, this.endNode);
            return true;
        }
        return false;
    }

    public static abstract class Defaults
    extends StateDefaults<Long, RelationshipState, RelationshipStateImpl> {
        private static final RelationshipState DEFAULT = new RelationshipState(){

            private UnsupportedOperationException notDefined(String field) {
                return new UnsupportedOperationException(field + " not defined");
            }

            @Override
            public long getId() {
                throw this.notDefined("id");
            }

            @Override
            public <EX extends Exception> boolean accept(RelationshipVisitor<EX> visitor) throws EX {
                return false;
            }

            @Override
            public Iterator<StorageProperty> addedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<StorageProperty> changedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<Integer> removedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<StorageProperty> addedAndChangedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<StorageProperty> augmentProperties(Iterator<StorageProperty> iterator) {
                return iterator;
            }

            @Override
            public void accept(PropertyContainerState.Visitor visitor) {
            }

            @Override
            public boolean hasChanges() {
                return false;
            }

            @Override
            public StorageProperty getChangedProperty(int propertyKeyId) {
                return null;
            }

            @Override
            public StorageProperty getAddedProperty(int propertyKeyId) {
                return null;
            }

            @Override
            public boolean isPropertyRemoved(int propertyKeyId) {
                return false;
            }
        };

        @Override
        RelationshipStateImpl createValue(Long id, TxState state) {
            return new RelationshipStateImpl(id);
        }

        @Override
        RelationshipState defaultValue() {
            return DEFAULT;
        }
    }
}

