/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntStack;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.LegacyIndex;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LookupFilter;
import org.neo4j.kernel.impl.api.PropertyValueComparison;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.CountsOperations;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexReadOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class StateHandlingStatementOperations
implements KeyReadOperations,
KeyWriteOperations,
EntityOperations,
SchemaReadOperations,
SchemaWriteOperations,
CountsOperations,
LegacyIndexReadOperations,
LegacyIndexWriteOperations {
    private final StoreReadLayer storeLayer;
    private final AutoIndexing autoIndexing;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final LegacyIndexStore legacyIndexStore;

    public StateHandlingStatementOperations(StoreReadLayer storeLayer, AutoIndexing propertyTrackers, ConstraintIndexCreator constraintIndexCreator, LegacyIndexStore legacyIndexStore) {
        this.storeLayer = storeLayer;
        this.autoIndexing = propertyTrackers;
        this.constraintIndexCreator = constraintIndexCreator;
        this.legacyIndexStore = legacyIndexStore;
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        Cursor<NodeItem> node = this.nodeCursor(statement, nodeId);
        if (!node.next()) {
            node.close();
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        return node;
    }

    @Override
    public Cursor<NodeItem> nodeCursor(KernelStatement statement, long nodeId) {
        Cursor<NodeItem> cursor = statement.getStoreStatement().acquireSingleNodeCursor(nodeId);
        if (statement.hasTxStateWithChanges()) {
            return statement.txState().augmentSingleNodeCursor(cursor, nodeId);
        }
        return cursor;
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(KernelStatement statement, long relationshipId) throws EntityNotFoundException {
        Cursor<RelationshipItem> relationship = this.relationshipCursor(statement, relationshipId);
        if (!relationship.next()) {
            relationship.close();
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        return relationship;
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursor(KernelStatement statement, long relationshipId) {
        Cursor<RelationshipItem> cursor = statement.getStoreStatement().acquireSingleRelationshipCursor(relationshipId);
        if (statement.hasTxStateWithChanges()) {
            return statement.txState().augmentSingleRelationshipCursor(cursor, relationshipId);
        }
        return cursor;
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetAll(KernelStatement statement) {
        Cursor<NodeItem> cursor = statement.getStoreStatement().nodesGetAllCursor();
        if (statement.hasTxStateWithChanges()) {
            return statement.txState().augmentNodesGetAllCursor(cursor);
        }
        return cursor;
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll(KernelStatement statement) {
        Cursor<RelationshipItem> cursor = statement.getStoreStatement().relationshipsGetAllCursor();
        if (statement.hasTxStateWithChanges()) {
            return statement.txState().augmentRelationshipsGetAllCursor(cursor);
        }
        return cursor;
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetForLabel(KernelStatement statement, int labelId) {
        StorageStatement storeStatement = statement.getStoreStatement();
        return storeStatement.acquireIteratorNodeCursor(this.storeLayer.nodesGetForLabel(storeStatement, labelId));
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexSeek(KernelStatement statement, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = statement.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        return storeStatement.acquireIteratorNodeCursor(reader.seek(value));
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexScan(KernelStatement statement, IndexDescriptor index) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = statement.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        return storeStatement.acquireIteratorNodeCursor(reader.scan());
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexSeekByPrefix(KernelStatement statement, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = statement.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        return storeStatement.acquireIteratorNodeCursor(reader.rangeSeekByPrefix(prefix));
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByNumber(KernelStatement statement, IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = statement.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        return PropertyValueComparison.COMPARE_NUMBERS.isEmptyRange(lower, includeLower, upper, includeUpper) ? Cursors.empty() : storeStatement.acquireIteratorNodeCursor(reader.rangeSeekByNumberInclusive(lower, upper));
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByString(KernelStatement statement, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = statement.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        return storeStatement.acquireIteratorNodeCursor(reader.rangeSeekByString(lower, includeLower, upper, includeUpper));
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByPrefix(KernelStatement statement, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = statement.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        return storeStatement.acquireIteratorNodeCursor(reader.rangeSeekByPrefix(prefix));
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromUniqueIndexSeek(KernelStatement statement, IndexDescriptor index, Object value) throws IndexBrokenKernelException, IndexNotFoundKernelException {
        StorageStatement storeStatement = statement.getStoreStatement();
        IndexReader reader = storeStatement.getFreshIndexReader(index);
        PrimitiveLongResourceIterator seekResult = PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)reader.seek(value), (Resource)reader);
        return storeStatement.acquireIteratorNodeCursor((PrimitiveLongIterator)seekResult);
    }

    @Override
    public long nodeCreate(KernelStatement state) {
        long nodeId = this.storeLayer.reserveNode();
        state.txState().nodeDoCreate(nodeId);
        return nodeId;
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws AutoIndexingKernelException, EntityNotFoundException, InvalidTransactionTypeKernelException {
        this.autoIndexing.nodes().entityRemoved(state.dataWriteOperations(), nodeId);
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            state.txState().nodeDoDelete(((NodeItem)cursor.get()).id());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long relationshipCreate(KernelStatement state, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorById(state, relationshipId);){
            RelationshipItem relationship = (RelationshipItem)cursor.get();
            this.autoIndexing.relationships().entityRemoved(state.dataWriteOperations(), relationshipId);
            TransactionState txState = state.txState();
            if (txState.relationshipIsAddedInThisTx(relationship.id())) {
                txState.relationshipDoDeleteAddedInThisTx(relationship.id());
            } else {
                txState.relationshipDoDelete(relationship.id(), relationship.type(), relationship.startNode(), relationship.endNode());
            }
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement state) {
        PrimitiveLongIterator iterator = this.storeLayer.nodesGetAll();
        return state.hasTxStateWithChanges() ? state.txState().augmentNodesGetAll(iterator) : iterator;
    }

    @Override
    public RelationshipIterator relationshipsGetAll(KernelStatement state) {
        RelationshipIterator iterator = this.storeLayer.relationshipsGetAll();
        return state.hasTxStateWithChanges() ? state.txState().augmentRelationshipsGetAll(iterator) : iterator;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            try (Cursor<LabelItem> labels = node.label(labelId);){
                if (!labels.next()) {
                    boolean bl = false;
                    return bl;
                }
            }
            state.txState().nodeDoRemoveLabel(labelId, node.id());
            var9_10 = null;
            try (Cursor<PropertyItem> properties = node.properties();){
                while (properties.next()) {
                    PropertyItem propItem = (PropertyItem)properties.get();
                    DefinedProperty property = Property.property(propItem.propertyKeyId(), propItem.value());
                    this.indexUpdateProperty(state, node.id(), labelId, property.propertyKeyId(), property, null);
                }
            }
            catch (Throwable throwable) {
                var9_10 = throwable;
                throw throwable;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            PrimitiveLongIterator wLabelChanges = state.txState().nodesWithLabelChanged(labelId).augment(this.storeLayer.nodesGetForLabel(state.getStoreStatement(), labelId));
            return state.txState().addedAndRemovedNodes().augmentWithRemovals(wLabelChanges);
        }
        return this.storeLayer.nodesGetForLabel(state.getStoreStatement(), labelId);
    }

    @Override
    public long nodesGetCount(KernelStatement state) {
        long base = this.storeLayer.nodesGetCount();
        return state.hasTxStateWithChanges() ? base + (long)state.txState().addedAndRemovedNodes().delta() : base;
    }

    @Override
    public long relationshipsGetCount(KernelStatement state) {
        long base = this.storeLayer.relationshipsGetCount();
        return state.hasTxStateWithChanges() ? base + (long)state.txState().addedAndRemovedRelationships().delta() : base;
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKey) {
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        state.txState().indexRuleDoAdd(rule);
        return rule;
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().indexDoDrop(descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().constraintIndexDoDrop(descriptor);
    }

    @Override
    public UniquenessConstraint uniquePropertyConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws CreateConstraintFailureException {
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        try {
            IndexDescriptor index = new IndexDescriptor(labelId, propertyKeyId);
            if (state.hasTxStateWithChanges() && state.txState().constraintIndexDoUnRemove(index)) {
                if (!state.txState().constraintDoUnRemove(constraint)) {
                    state.txState().constraintDoAdd(constraint, state.txState().indexCreatedForConstraint(constraint));
                }
            } else {
                Iterator<NodePropertyConstraint> it = this.storeLayer.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId);
                while (it.hasNext()) {
                    if (!it.next().equals(constraint)) continue;
                    return constraint;
                }
                long indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(state, this, labelId, propertyKeyId);
                state.txState().constraintDoAdd(constraint, indexId);
            }
            return constraint;
        }
        catch (TransactionFailureException | ConstraintVerificationFailedKernelException | DropIndexFailureException e) {
            throw new CreateConstraintFailureException(constraint, (Throwable)e);
        }
    }

    @Override
    public NodePropertyExistenceConstraint nodePropertyExistenceConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws CreateConstraintFailureException {
        NodePropertyExistenceConstraint constraint = new NodePropertyExistenceConstraint(labelId, propertyKeyId);
        state.txState().constraintDoAdd(constraint);
        return constraint;
    }

    @Override
    public RelationshipPropertyExistenceConstraint relationshipPropertyExistenceConstraintCreate(KernelStatement state, int relTypeId, int propertyKeyId) throws AlreadyConstrainedException, CreateConstraintFailureException {
        RelationshipPropertyExistenceConstraint constraint = new RelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId);
        state.txState().constraintDoAdd(constraint);
        return constraint;
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        Iterator<NodePropertyConstraint> constraints = this.storeLayer.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId);
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForLabelAndProperty(labelId, propertyKeyId).apply(constraints);
        }
        return constraints;
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        Iterator<NodePropertyConstraint> constraints = this.storeLayer.constraintsGetForLabel(labelId);
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipTypeAndPropertyKey(KernelStatement state, int relTypeId, int propertyKeyId) {
        Iterator<RelationshipPropertyConstraint> constraints = this.storeLayer.constraintsGetForRelationshipTypeAndPropertyKey(relTypeId, propertyKeyId);
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForRelationshipTypeAndProperty(relTypeId, propertyKeyId).apply(constraints);
        }
        return constraints;
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipType(KernelStatement state, int typeId) {
        Iterator<RelationshipPropertyConstraint> constraints = this.storeLayer.constraintsGetForRelationshipType(typeId);
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    @Override
    public Iterator<PropertyConstraint> constraintsGetAll(KernelStatement state) {
        Iterator<PropertyConstraint> constraints = this.storeLayer.constraintsGetAll();
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChanges().apply(constraints);
        }
        return constraints;
    }

    @Override
    public void constraintDrop(KernelStatement state, NodePropertyConstraint constraint) {
        state.txState().constraintDoDrop(constraint);
    }

    @Override
    public void constraintDrop(KernelStatement state, RelationshipPropertyConstraint constraint) throws DropConstraintFailureException {
        state.txState().constraintDoDrop(constraint);
    }

    @Override
    public IndexDescriptor indexGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) {
        IndexDescriptor indexDescriptor = this.storeLayer.indexGetForLabelAndPropertyKey(labelId, propertyKey);
        Iterator<IndexDescriptor> rules = IteratorUtil.iterator((Object)indexDescriptor);
        if (state.hasTxStateWithChanges()) {
            rules = this.filterByPropertyKeyId(state.txState().indexDiffSetsByLabel(labelId).apply(rules), propertyKey);
        }
        return (IndexDescriptor)IteratorUtil.singleOrNull((Iterator)rules);
    }

    private Iterator<IndexDescriptor> filterByPropertyKeyId(Iterator<IndexDescriptor> descriptorIterator, int propertyKey) {
        Predicate<IndexDescriptor> predicate = item -> item.getPropertyKeyId() == propertyKey;
        return Iterables.filter(predicate, descriptorIterator);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges()) {
            if (this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.getLabelId()))) {
                return InternalIndexState.POPULATING;
            }
            ReadableDiffSets<IndexDescriptor> changes = state.txState().constraintIndexDiffSetsByLabel(descriptor.getLabelId());
            if (this.checkIndexState(descriptor, changes)) {
                return InternalIndexState.POPULATING;
            }
        }
        return this.storeLayer.indexGetState(descriptor);
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges()) {
            if (this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.getLabelId()))) {
                return PopulationProgress.NONE;
            }
            ReadableDiffSets<IndexDescriptor> changes = state.txState().constraintIndexDiffSetsByLabel(descriptor.getLabelId());
            if (this.checkIndexState(descriptor, changes)) {
                return PopulationProgress.NONE;
            }
        }
        return this.storeLayer.indexGetPopulationProgress(descriptor);
    }

    private boolean checkIndexState(IndexDescriptor indexRule, ReadableDiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(indexRule)) {
            return true;
        }
        if (diffSet.isRemoved(indexRule)) {
            throw new IndexNotFoundKernelException(String.format("Index for label id %d on property id %d has been dropped in this transaction.", indexRule.getLabelId(), indexRule.getPropertyKeyId()));
        }
        return false;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexDiffSetsByLabel(labelId).apply(this.storeLayer.indexesGetForLabel(labelId));
        }
        return this.storeLayer.indexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexChanges().apply(this.storeLayer.indexesGetAll());
        }
        return this.storeLayer.indexesGetAll();
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexDiffSetsByLabel(labelId).apply(this.storeLayer.uniquenessIndexesGetForLabel(labelId));
        }
        return this.storeLayer.uniquenessIndexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexChanges().apply(this.storeLayer.uniquenessIndexesGetAll());
        }
        return this.storeLayer.uniquenessIndexesGetAll();
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        IndexReader reader = storeStatement.getFreshIndexReader(index);
        PrimitiveLongResourceIterator committed = PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)reader.seek(value), (Resource)reader);
        PrimitiveLongIterator exactMatches = this.filterExactIndexMatches(state, index, value, (PrimitiveLongIterator)committed);
        PrimitiveLongIterator changesFiltered = this.filterIndexStateChangesForScanOrSeek(state, index, value, exactMatches);
        return PrimitiveLongCollections.single((PrimitiveLongIterator)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)changesFiltered, (Resource)committed), (long)-1L);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        PrimitiveLongIterator committed = reader.seek(value);
        PrimitiveLongIterator exactMatches = this.filterExactIndexMatches(state, index, value, committed);
        return this.filterIndexStateChangesForScanOrSeek(state, index, value, exactMatches);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByNumber(KernelStatement state, IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        PrimitiveLongIterator committed = PropertyValueComparison.COMPARE_NUMBERS.isEmptyRange(lower, includeLower, upper, includeUpper) ? PrimitiveLongCollections.emptyIterator() : storeStatement.getIndexReader(index).rangeSeekByNumberInclusive(lower, upper);
        PrimitiveLongIterator exactMatches = this.filterExactRangeMatches(state, index, committed, lower, includeLower, upper, includeUpper);
        return this.filterIndexStateChangesForRangeSeekByNumber(state, index, lower, includeLower, upper, includeUpper, exactMatches);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByString(KernelStatement state, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        PrimitiveLongIterator committed = reader.rangeSeekByString(lower, includeLower, upper, includeUpper);
        return this.filterIndexStateChangesForRangeSeekByString(state, index, lower, includeLower, upper, includeUpper, committed);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByPrefix(KernelStatement state, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        PrimitiveLongIterator committed = reader.rangeSeekByPrefix(prefix);
        return this.filterIndexStateChangesForRangeSeekByPrefix(state, index, prefix, committed);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(KernelStatement state, IndexDescriptor index) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        PrimitiveLongIterator committed = reader.scan();
        return this.filterIndexStateChangesForScanOrSeek(state, index, null, committed);
    }

    @Override
    public long nodesCountIndexed(KernelStatement statement, IndexDescriptor index, long nodeId, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        IndexReader reader = statement.getStoreStatement().getIndexReader(index);
        return reader.countIndexedNodes(nodeId, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexContainsScan(KernelStatement state, IndexDescriptor index, String term) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        PrimitiveLongIterator committed = reader.containsString(term);
        return this.filterIndexStateChangesForScanOrSeek(state, index, null, committed);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexEndsWithScan(KernelStatement state, IndexDescriptor index, String suffix) throws IndexNotFoundKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        PrimitiveLongIterator committed = reader.endsWith(suffix);
        return this.filterIndexStateChangesForScanOrSeek(state, index, null, committed);
    }

    private PrimitiveLongIterator filterExactIndexMatches(KernelStatement state, IndexDescriptor index, Object value, PrimitiveLongIterator committed) {
        return LookupFilter.exactIndexMatches(this, state, committed, index.getPropertyKeyId(), value);
    }

    private PrimitiveLongIterator filterExactRangeMatches(KernelStatement state, IndexDescriptor index, PrimitiveLongIterator committed, Number lower, boolean includeLower, Number upper, boolean includeUpper) {
        return LookupFilter.exactRangeMatches(this, state, committed, index.getPropertyKeyId(), lower, includeLower, upper, includeUpper);
    }

    private PrimitiveLongIterator filterIndexStateChangesForScanOrSeek(KernelStatement state, IndexDescriptor index, Object value, PrimitiveLongIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            ReadableDiffSets<Long> labelPropertyChanges = state.txState().indexUpdatesForScanOrSeek(index, value);
            ReadableDiffSets<Long> nodes = state.txState().addedAndRemovedNodes();
            return nodes.augmentWithRemovals(labelPropertyChanges.augment(nodeIds));
        }
        return nodeIds;
    }

    private PrimitiveLongIterator filterIndexStateChangesForRangeSeekByNumber(KernelStatement state, IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper, PrimitiveLongIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            ReadableDiffSets<Long> labelPropertyChangesForNumber = state.txState().indexUpdatesForRangeSeekByNumber(index, lower, includeLower, upper, includeUpper);
            ReadableDiffSets<Long> nodes = state.txState().addedAndRemovedNodes();
            return nodes.augmentWithRemovals(labelPropertyChangesForNumber.augment(nodeIds));
        }
        return nodeIds;
    }

    private PrimitiveLongIterator filterIndexStateChangesForRangeSeekByString(KernelStatement state, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper, PrimitiveLongIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            ReadableDiffSets<Long> labelPropertyChangesForString = state.txState().indexUpdatesForRangeSeekByString(index, lower, includeLower, upper, includeUpper);
            ReadableDiffSets<Long> nodes = state.txState().addedAndRemovedNodes();
            return nodes.augmentWithRemovals(labelPropertyChangesForString.augment(nodeIds));
        }
        return nodeIds;
    }

    private PrimitiveLongIterator filterIndexStateChangesForRangeSeekByPrefix(KernelStatement state, IndexDescriptor index, String prefix, PrimitiveLongIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            ReadableDiffSets<Long> labelPropertyChangesForPrefix = state.txState().indexUpdatesForRangeSeekByPrefix(index, prefix);
            ReadableDiffSets<Long> nodes = state.txState().addedAndRemovedNodes();
            return nodes.augmentWithRemovals(labelPropertyChangesForPrefix.augment(nodeIds));
        }
        return nodeIds;
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        DataWriteOperations ops = state.dataWriteOperations();
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            Property existingProperty;
            NodeItem node = (NodeItem)cursor.get();
            Cursor<PropertyItem> properties = node.property(property.propertyKeyId());
            Object object = null;
            try {
                if (!properties.next()) {
                    this.autoIndexing.nodes().propertyAdded(ops, nodeId, property);
                    existingProperty = Property.noProperty(property.propertyKeyId(), EntityType.NODE, node.id());
                } else {
                    existingProperty = Property.property(((PropertyItem)properties.get()).propertyKeyId(), ((PropertyItem)properties.get()).value());
                    this.autoIndexing.nodes().propertyChanged(ops, nodeId, existingProperty, property);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (properties != null) {
                    if (object != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        properties.close();
                    }
                }
            }
            state.txState().nodeDoReplaceProperty(node.id(), existingProperty, property);
            PrimitiveIntCollection labelIds = this.getLabels(node);
            this.indexesUpdateProperty(state, node.id(), labelIds, property.propertyKeyId(), (DefinedProperty)(existingProperty instanceof DefinedProperty ? existingProperty : null), property);
            object = existingProperty;
            return object;
        }
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        DataWriteOperations ops = state.dataWriteOperations();
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorById(state, relationshipId);){
            Property existingProperty;
            RelationshipItem relationship = (RelationshipItem)cursor.get();
            try (Cursor<PropertyItem> properties = relationship.property(property.propertyKeyId());){
                if (!properties.next()) {
                    this.autoIndexing.relationships().propertyAdded(ops, relationshipId, property);
                    existingProperty = Property.noProperty(property.propertyKeyId(), EntityType.RELATIONSHIP, relationship.id());
                } else {
                    existingProperty = Property.property(((PropertyItem)properties.get()).propertyKeyId(), ((PropertyItem)properties.get()).value());
                    this.autoIndexing.relationships().propertyChanged(ops, relationshipId, existingProperty, property);
                }
            }
            state.txState().relationshipDoReplaceProperty(relationship.id(), existingProperty, property);
            Property property2 = existingProperty;
            return property2;
        }
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        Object existingPropertyValue = this.graphGetProperty(state, property.propertyKeyId());
        Property existingProperty = existingPropertyValue == null ? Property.noGraphProperty(property.propertyKeyId()) : Property.property(property.propertyKeyId(), existingPropertyValue);
        state.txState().graphDoReplaceProperty(existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        DataWriteOperations ops = state.dataWriteOperations();
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            Property existingProperty;
            NodeItem node = (NodeItem)cursor.get();
            PrimitiveIntCollection labelIds = this.getLabels(node);
            try (Cursor<PropertyItem> properties = node.property(propertyKeyId);){
                if (!properties.next()) {
                    existingProperty = Property.noProperty(propertyKeyId, EntityType.NODE, node.id());
                } else {
                    existingProperty = Property.property(((PropertyItem)properties.get()).propertyKeyId(), ((PropertyItem)properties.get()).value());
                    this.autoIndexing.nodes().propertyRemoved(ops, nodeId, propertyKeyId);
                    state.txState().nodeDoRemoveProperty(node.id(), (DefinedProperty)existingProperty);
                    this.indexesUpdateProperty(state, node.id(), labelIds, propertyKeyId, (DefinedProperty)existingProperty, null);
                }
            }
            Property property = existingProperty;
            return property;
        }
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        DataWriteOperations ops = state.dataWriteOperations();
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorById(state, relationshipId);){
            Property existingProperty;
            RelationshipItem relationship = (RelationshipItem)cursor.get();
            try (Cursor<PropertyItem> properties = relationship.property(propertyKeyId);){
                if (!properties.next()) {
                    existingProperty = Property.noProperty(propertyKeyId, EntityType.RELATIONSHIP, relationship.id());
                } else {
                    existingProperty = Property.property(((PropertyItem)properties.get()).propertyKeyId(), ((PropertyItem)properties.get()).value());
                    this.autoIndexing.relationships().propertyRemoved(ops, relationshipId, propertyKeyId);
                    state.txState().relationshipDoRemoveProperty(relationship.id(), (DefinedProperty)existingProperty);
                }
            }
            Property property = existingProperty;
            return property;
        }
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        Object existingPropertyValue = this.graphGetProperty(state, propertyKeyId);
        if (existingPropertyValue != null) {
            DefinedProperty existingProperty = Property.property(propertyKeyId, existingPropertyValue);
            state.txState().graphDoRemoveProperty(existingProperty);
            return existingProperty;
        }
        return Property.noGraphProperty(propertyKeyId);
    }

    private void indexesUpdateProperty(KernelStatement state, long nodeId, PrimitiveIntCollection labels, int propertyKey, DefinedProperty before, DefinedProperty after) {
        PrimitiveIntIterator labelIterator = labels.iterator();
        while (labelIterator.hasNext()) {
            this.indexUpdateProperty(state, nodeId, labelIterator.next(), propertyKey, before, after);
        }
    }

    private void indexUpdateProperty(KernelStatement state, long nodeId, int labelId, int propertyKey, DefinedProperty before, DefinedProperty after) {
        IndexDescriptor descriptor = this.indexGetForLabelAndPropertyKey(state, labelId, propertyKey);
        if (descriptor != null) {
            state.txState().indexDoUpdateProperty(descriptor, nodeId, before, after);
        }
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.graphGetAllProperties(state));
        }
        return this.storeLayer.graphGetPropertyKeys();
    }

    @Override
    public boolean graphHasProperty(KernelStatement state, int propertyKeyId) {
        return this.graphGetProperty(state, propertyKeyId) != null;
    }

    @Override
    public Object graphGetProperty(KernelStatement state, int propertyKeyId) {
        Iterator<StorageProperty> properties = this.graphGetAllProperties(state);
        while (properties.hasNext()) {
            DefinedProperty property = (DefinedProperty)properties.next();
            if (property.propertyKeyId() != propertyKeyId) continue;
            return property.value();
        }
        return null;
    }

    private Iterator<StorageProperty> graphGetAllProperties(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().augmentGraphProperties(this.storeLayer.graphGetAllProperties());
        }
        return this.storeLayer.graphGetAllProperties();
    }

    @Override
    public long countsForNode(KernelStatement statement, int labelId) {
        long count = this.countsForNodeWithoutTxState(statement, labelId);
        if (statement.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                statement.txState().accept(new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storeLayer, statement.getStoreStatement(), statement.txState(), counts));
                if (counts.hasChanges()) {
                    count += counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationKernelException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    @Override
    public long countsForNodeWithoutTxState(KernelStatement statement, int labelId) {
        return this.storeLayer.countsForNode(labelId);
    }

    @Override
    public long countsForRelationship(KernelStatement statement, int startLabelId, int typeId, int endLabelId) {
        long count = this.countsForRelationshipWithoutTxState(statement, startLabelId, typeId, endLabelId);
        if (statement.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                statement.txState().accept(new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storeLayer, statement.getStoreStatement(), statement.txState(), counts));
                if (counts.hasChanges()) {
                    count += counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationKernelException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    @Override
    public long countsForRelationshipWithoutTxState(KernelStatement statement, int startLabelId, int typeId, int endLabelId) {
        return this.storeLayer.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    @Override
    public long indexSize(KernelStatement statement, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexSize(descriptor);
    }

    @Override
    public double indexUniqueValuesPercentage(KernelStatement statement, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexUniqueValuesPercentage(descriptor);
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(KernelStatement statement, IndexDescriptor index, Register.DoubleLongRegister target) {
        return this.storeLayer.indexUpdatesAndSize(index, target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(KernelStatement statement, IndexDescriptor index, Register.DoubleLongRegister target) {
        return this.storeLayer.indexSample(index, target);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index, Predicate<SchemaRule.Kind> filter) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetCommittedId(index, filter);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexGetFailure(descriptor);
    }

    @Override
    public int labelGetForName(Statement state, String labelName) {
        return this.storeLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(Statement state, int labelId) throws LabelNotFoundKernelException {
        return this.storeLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(Statement state, String propertyKeyName) {
        return this.storeLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(Statement state, int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.storeLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens(Statement state) {
        return this.storeLayer.propertyKeyGetAllTokens();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens(Statement state) {
        return this.storeLayer.labelsGetAllTokens();
    }

    @Override
    public Iterator<Token> relationshipTypesGetAllTokens(Statement state) {
        return this.storeLayer.relationshipTypeGetAllTokens();
    }

    @Override
    public int relationshipTypeGetForName(Statement state, String relationshipTypeName) {
        return this.storeLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(Statement state, int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.storeLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        return this.storeLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKeyName) throws IllegalTokenNameException {
        return this.storeLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) throws IllegalTokenNameException {
        return this.storeLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    @Override
    public void labelCreateForName(KernelStatement state, String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        state.txState().labelDoCreateForName(labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(KernelStatement state, String propertyKeyName, int id) throws IllegalTokenNameException {
        state.txState().propertyKeyDoCreateForName(propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(KernelStatement state, String relationshipTypeName, int id) throws IllegalTokenNameException {
        state.txState().relationshipTypeDoCreateForName(relationshipTypeName, id);
    }

    @Override
    public int labelCount(KernelStatement statement) {
        return this.storeLayer.labelCount();
    }

    @Override
    public int propertyKeyCount(KernelStatement statement) {
        return this.storeLayer.propertyKeyCount();
    }

    @Override
    public int relationshipTypeCount(KernelStatement statement) {
        return this.storeLayer.relationshipTypeCount();
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        if (statement.hasTxStateWithChanges() && statement.txState().relationshipVisit(relId, visitor)) {
            return;
        }
        this.storeLayer.relationshipVisit(relId, visitor);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexGet(KernelStatement statement, String indexName, String key, Object value) throws LegacyIndexNotFoundKernelException {
        return statement.legacyIndexTxState().nodeChanges(indexName).get(key, value);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexQuery(KernelStatement statement, String indexName, String key, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
        return statement.legacyIndexTxState().nodeChanges(indexName).query(key, queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexQuery(KernelStatement statement, String indexName, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
        return statement.legacyIndexTxState().nodeChanges(indexName).query(queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexGet(KernelStatement statement, String indexName, String key, Object value, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        LegacyIndex index = statement.legacyIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.get(key, value, startNode, endNode);
        }
        return index.get(key, value);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexQuery(KernelStatement statement, String indexName, String key, Object queryOrQueryObject, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        LegacyIndex index = statement.legacyIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.query(key, queryOrQueryObject, startNode, endNode);
        }
        return index.query(key, queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexQuery(KernelStatement statement, String indexName, Object queryOrQueryObject, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        LegacyIndex index = statement.legacyIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.query(queryOrQueryObject, startNode, endNode);
        }
        return index.query(queryOrQueryObject);
    }

    @Override
    public void nodeLegacyIndexCreateLazily(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        this.legacyIndexStore.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    @Override
    public void nodeLegacyIndexCreate(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        statement.legacyIndexTxState().createIndex(IndexEntityType.Node, indexName, customConfig);
    }

    @Override
    public void relationshipLegacyIndexCreateLazily(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        this.legacyIndexStore.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    @Override
    public void relationshipLegacyIndexCreate(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        statement.legacyIndexTxState().createIndex(IndexEntityType.Relationship, indexName, customConfig);
    }

    @Override
    public void nodeAddToLegacyIndex(KernelStatement statement, String indexName, long node, String key, Object value) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).addNode(node, key, value);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(KernelStatement statement, String indexName, long node, String key, Object value) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).remove(node, key, value);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(KernelStatement statement, String indexName, long node, String key) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).remove(node, key);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(KernelStatement statement, String indexName, long node) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).remove(node);
    }

    @Override
    public void relationshipAddToLegacyIndex(final KernelStatement statement, final String indexName, final long relationship, final String key, final Object value) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        this.relationshipVisit(statement, relationship, new RelationshipVisitor<LegacyIndexNotFoundKernelException>(){

            @Override
            public void visit(long relId, int type, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
                statement.legacyIndexTxState().relationshipChanges(indexName).addRelationship(relationship, key, value, startNode, endNode);
            }
        });
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(final KernelStatement statement, final String indexName, long relationship, final String key, final Object value) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        try {
            this.relationshipVisit(statement, relationship, new RelationshipVisitor<LegacyIndexNotFoundKernelException>(){

                @Override
                public void visit(long relId, int type, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
                    statement.legacyIndexTxState().relationshipChanges(indexName).removeRelationship(relId, key, value, startNode, endNode);
                }
            });
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(final KernelStatement statement, final String indexName, long relationship, final String key) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        try {
            this.relationshipVisit(statement, relationship, new RelationshipVisitor<LegacyIndexNotFoundKernelException>(){

                @Override
                public void visit(long relId, int type, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
                    statement.legacyIndexTxState().relationshipChanges(indexName).removeRelationship(relId, key, startNode, endNode);
                }
            });
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(final KernelStatement statement, final String indexName, long relationship) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        try {
            this.relationshipVisit(statement, relationship, new RelationshipVisitor<LegacyIndexNotFoundKernelException>(){

                @Override
                public void visit(long relId, int type, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
                    statement.legacyIndexTxState().relationshipChanges(indexName).removeRelationship(relId, startNode, endNode);
                }
            });
        }
        catch (EntityNotFoundException e) {
            statement.legacyIndexTxState().relationshipChanges(indexName).remove(relationship);
        }
    }

    @Override
    public void nodeLegacyIndexDrop(KernelStatement statement, String indexName) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).drop();
        statement.legacyIndexTxState().deleteIndex(IndexEntityType.Node, indexName);
    }

    @Override
    public void relationshipLegacyIndexDrop(KernelStatement statement, String indexName) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().relationshipChanges(indexName).drop();
        statement.legacyIndexTxState().deleteIndex(IndexEntityType.Relationship, indexName);
    }

    @Override
    public String nodeLegacyIndexSetConfiguration(KernelStatement statement, String indexName, String key, String value) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.setNodeIndexConfiguration(indexName, key, value);
    }

    @Override
    public String relationshipLegacyIndexSetConfiguration(KernelStatement statement, String indexName, String key, String value) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.setRelationshipIndexConfiguration(indexName, key, value);
    }

    @Override
    public String nodeLegacyIndexRemoveConfiguration(KernelStatement statement, String indexName, String key) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.removeNodeIndexConfiguration(indexName, key);
    }

    @Override
    public String relationshipLegacyIndexRemoveConfiguration(KernelStatement statement, String indexName, String key) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.removeRelationshipIndexConfiguration(indexName, key);
    }

    @Override
    public Map<String, String> nodeLegacyIndexGetConfiguration(KernelStatement statement, String indexName) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.getNodeIndexConfiguration(indexName);
    }

    @Override
    public Map<String, String> relationshipLegacyIndexGetConfiguration(KernelStatement statement, String indexName) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.getRelationshipIndexConfiguration(indexName);
    }

    @Override
    public String[] nodeLegacyIndexesGetAll(KernelStatement statement) {
        return this.legacyIndexStore.getAllNodeIndexNames();
    }

    @Override
    public String[] relationshipLegacyIndexesGetAll(KernelStatement statement) {
        return this.legacyIndexStore.getAllRelationshipIndexNames();
    }

    private PrimitiveIntCollection getLabels(NodeItem node) {
        PrimitiveIntStack labelIds = new PrimitiveIntStack();
        try (Cursor<LabelItem> labels = node.labels();){
            while (labels.next()) {
                labelIds.push(((LabelItem)labels.get()).getAsInt());
            }
        }
        return labelIds;
    }

    @Override
    public boolean nodeExists(KernelStatement statement, long id) {
        if (statement.hasTxStateWithChanges()) {
            TransactionState txState = statement.txState();
            if (txState.nodeIsDeletedInThisTx(id)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(id)) {
                return true;
            }
        }
        return this.storeLayer.nodeExists(id);
    }
}

