/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.builtinprocs.ListComponentsProcedure;
import org.neo4j.kernel.builtinprocs.ListConstraintsProcedure;
import org.neo4j.kernel.builtinprocs.ListIndexesProcedure;
import org.neo4j.kernel.builtinprocs.ListLabelsProcedure;
import org.neo4j.kernel.builtinprocs.ListProceduresProcedure;
import org.neo4j.kernel.builtinprocs.ListPropertyKeysProcedure;
import org.neo4j.kernel.builtinprocs.ListRelationshipTypesProcedure;
import org.neo4j.kernel.impl.proc.Procedures;

public class BuiltInProcedures
implements ThrowingConsumer<Procedures, ProcedureException> {
    private final String neo4jVersion;

    public BuiltInProcedures(String neo4jVersion) {
        this.neo4jVersion = neo4jVersion;
    }

    public void accept(Procedures procs) throws ProcedureException {
        procs.register(new ListLabelsProcedure(ProcedureSignature.procedureName("db", "labels")));
        procs.register(new ListPropertyKeysProcedure(ProcedureSignature.procedureName("db", "propertyKeys")));
        procs.register(new ListRelationshipTypesProcedure(ProcedureSignature.procedureName("db", "relationshipTypes")));
        procs.register(new ListIndexesProcedure(ProcedureSignature.procedureName("db", "indexes")));
        procs.register(new ListConstraintsProcedure(ProcedureSignature.procedureName("db", "constraints")));
        procs.register(new ListProceduresProcedure(ProcedureSignature.procedureName("sys", "procedures")));
        procs.register(new ListComponentsProcedure(ProcedureSignature.procedureName("sys", "components"), this.neo4jVersion));
    }
}

