/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;

public interface IndexAccessor
extends Closeable {
    public void drop() throws IOException;

    public IndexUpdater newUpdater(IndexUpdateMode var1);

    public void flush() throws IOException;

    public void force() throws IOException;

    @Override
    public void close() throws IOException;

    public IndexReader newReader();

    public BoundedIterable<Long> newAllEntriesReader();

    public ResourceIterator<File> snapshotFiles() throws IOException;

    public static class Delegator
    implements IndexAccessor {
        private final IndexAccessor delegate;

        public Delegator(IndexAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void drop() throws IOException {
            this.delegate.drop();
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return this.delegate.newUpdater(mode);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void force() throws IOException {
            this.delegate.force();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public IndexReader newReader() {
            return this.delegate.newReader();
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader() {
            return this.delegate.newAllEntriesReader();
        }

        @Override
        public ResourceIterator<File> snapshotFiles() throws IOException {
            return this.delegate.snapshotFiles();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class Adapter
    implements IndexAccessor {
        @Override
        public void drop() {
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void flush() {
        }

        @Override
        public void force() {
        }

        @Override
        public void close() {
        }

        @Override
        public IndexReader newReader() {
            return IndexReader.EMPTY;
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader() {
            return new BoundedIterable<Long>(){

                @Override
                public long maxCount() {
                    return 0L;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public Iterator<Long> iterator() {
                    return IteratorUtil.emptyIterator();
                }
            };
        }

        @Override
        public ResourceIterator<File> snapshotFiles() {
            return IteratorUtil.emptyIterator();
        }
    }
}

