/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.IdGroup;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.SameGroupDetector;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.SourceInformation;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputException;

public class EncodingIdMapper
implements IdMapper {
    public static final Monitor NO_MONITOR = new Monitor(){

        @Override
        public void numberOfCollisions(int count) {
        }
    };
    private static LongBitsManipulator COLLISION_BIT = new LongBitsManipulator(56, 1);
    private static int DEFAULT_CACHE_CHUNK_SIZE = 1000000;
    private static final long GAP_VALUE = 0L;
    private final NumberArrayFactory cacheFactory;
    private LongArray dataCache;
    private long highestSetIndex = -1L;
    private IntArray trackerCache;
    private final Encoder encoder;
    private final Radix radix;
    private final int processorsForSorting;
    private final ParallelSort.Comparator comparator;
    private final List<Object> collisionValues = new ArrayList<Object>();
    private final LongArray collisionNodeIdCache;
    private LongArray collisionSourceDataCache;
    private IntArray collisionTrackerCache;
    private boolean readyForUse;
    private long[][] sortBuckets;
    private IdGroup[] idGroups = new IdGroup[10];
    private IdGroup currentIdGroup;
    private final Monitor monitor;
    private final Factory<Radix> radixFactory;

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Factory<Radix> radixFactory, Monitor monitor) {
        this(cacheFactory, encoder, radixFactory, monitor, DEFAULT_CACHE_CHUNK_SIZE, Runtime.getRuntime().availableProcessors() - 1, ParallelSort.DEFAULT);
    }

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Factory<Radix> radixFactory, Monitor monitor, int chunkSize, int processorsForSorting, ParallelSort.Comparator comparator) {
        this.monitor = monitor;
        this.cacheFactory = cacheFactory;
        this.comparator = comparator;
        this.processorsForSorting = Math.max(processorsForSorting, 1);
        this.dataCache = cacheFactory.newDynamicLongArray(chunkSize, 0L);
        this.encoder = encoder;
        this.radixFactory = radixFactory;
        this.radix = (Radix)radixFactory.newInstance();
        this.collisionNodeIdCache = cacheFactory.newDynamicLongArray(chunkSize, -1L);
    }

    @Override
    public long get(Object inputId, Group group) {
        assert (this.readyForUse);
        return this.binarySearch(inputId, group.id());
    }

    @Override
    public void put(Object inputId, long id, Group group) {
        for (long gapId = this.highestSetIndex + 1L; gapId < id; ++gapId) {
            this.radix.registerRadixOf(0L);
        }
        int groupId = group.id();
        boolean newGroup = false;
        if (this.currentIdGroup == null) {
            newGroup = true;
        } else {
            if (groupId < this.currentIdGroup.id()) {
                throw new IllegalStateException("Nodes for any specific group must be added in sequence before adding nodes for any other group");
            }
            boolean bl = newGroup = groupId != this.currentIdGroup.id();
        }
        if (newGroup) {
            this.endPreviousGroup();
        }
        long eId = this.encode(inputId);
        this.dataCache.set(id, eId);
        this.highestSetIndex = id;
        this.radix.registerRadixOf(eId);
        if (newGroup) {
            if (groupId >= this.idGroups.length) {
                this.idGroups = Arrays.copyOf(this.idGroups, Math.max(groupId + 1, this.idGroups.length * 2));
            }
            this.idGroups[groupId] = this.currentIdGroup = new IdGroup(group, id);
        }
    }

    private long encode(Object inputId) {
        long eId = this.encoder.encode(inputId);
        if (eId == 0L) {
            throw new IllegalStateException("Encoder " + this.encoder + " returned an illegal encoded value " + 0L);
        }
        return eId;
    }

    private void endPreviousGroup() {
        if (this.currentIdGroup != null) {
            this.idGroups[this.currentIdGroup.id()].setHighDataIndex(this.highestSetIndex);
        }
    }

    @Override
    public boolean needsPreparation() {
        return true;
    }

    @Override
    public void prepare(InputIterable<Object> ids, Collector collector, ProgressListener progress) {
        block14: {
            this.endPreviousGroup();
            this.dataCache = this.dataCache.fixate();
            this.trackerCache = this.cacheFactory.newIntArray(this.highestSetIndex + 1L, -1);
            try {
                this.sortBuckets = new ParallelSort(this.radix, this.dataCache, this.highestSetIndex, this.trackerCache, this.processorsForSorting, progress, this.comparator).run();
                int numberOfCollisions = this.detectAndMarkCollisions(progress);
                if (numberOfCollisions <= 0) break block14;
                try (ResourceIterator idIterator = ids.iterator();){
                    this.buildCollisionInfo((InputIterator<Object>)idIterator, numberOfCollisions, collector, progress);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new RuntimeException("Got interrupted while preparing the index. Throwing this exception onwards will cause a chain reaction which will cause a panic in the whole import, so mission accomplished");
            }
        }
        this.readyForUse = true;
    }

    private int radixOf(long value) {
        return this.radix.calculator().radixOf(value);
    }

    private long binarySearch(Object inputId, int groupId) {
        long returnVal;
        long low = 0L;
        long high = this.highestSetIndex;
        long x = this.encode(inputId);
        int rIndex = this.radixOf(x);
        for (int k = 0; k < this.sortBuckets.length; ++k) {
            if ((long)rIndex > this.sortBuckets[k][0]) continue;
            low = this.sortBuckets[k][1];
            high = k == this.sortBuckets.length - 1 ? this.highestSetIndex : this.sortBuckets[k + 1][1];
            break;
        }
        if ((returnVal = this.binarySearch(x, inputId, low, high, groupId)) == -1L) {
            low = 0L;
            high = this.highestSetIndex;
            returnVal = this.binarySearch(x, inputId, low, high, groupId);
        }
        return returnVal;
    }

    private static long setCollision(long eId) {
        return COLLISION_BIT.set(eId, 1, 1L);
    }

    static long clearCollision(long eId) {
        return COLLISION_BIT.clear(eId, 1, false);
    }

    private static boolean isCollision(long eId) {
        return COLLISION_BIT.get(eId, 1) != 0L;
    }

    private int detectAndMarkCollisions(ProgressListener progress) {
        progress.started("DETECT");
        long max = this.highestSetIndex;
        long numberOfCollisions = 0L;
        SameGroupDetector sameGroupDetector = new SameGroupDetector();
        int i = 0;
        while ((long)i < max) {
            int batch = (int)Math.min(max - (long)i, 10000L);
            int j = 0;
            while (j < batch) {
                int dataIndexA = this.trackerCache.get(i);
                int dataIndexB = this.trackerCache.get(i + 1);
                if (dataIndexA == -1 || dataIndexB == -1) {
                    sameGroupDetector.reset();
                } else {
                    long eIdA = EncodingIdMapper.clearCollision(this.dataCache.get(dataIndexA));
                    long eIdB = EncodingIdMapper.clearCollision(this.dataCache.get(dataIndexB));
                    if (eIdA == 0L || eIdB == 0L) {
                        sameGroupDetector.reset();
                    } else {
                        switch (Utils.unsignedDifference(eIdA, eIdB)) {
                            case GT: {
                                throw new IllegalStateException("Unsorted data, a > b Failure:[" + i + "] " + Long.toHexString(eIdA) + " > " + Long.toHexString(eIdB) + " | " + this.radixOf(eIdA) + ":" + this.radixOf(eIdB));
                            }
                            case EQ: {
                                int collision = sameGroupDetector.collisionWithinSameGroup(dataIndexA, this.groupOf(dataIndexA).id(), dataIndexB, this.groupOf(dataIndexB).id());
                                if (dataIndexA > dataIndexB) {
                                    this.trackerCache.swap(i, i + 1, 1);
                                }
                                if (collision == -1) break;
                                if (this.markAsCollision(collision)) {
                                    ++numberOfCollisions;
                                }
                                if (!this.markAsCollision(dataIndexB)) break;
                                ++numberOfCollisions;
                                break;
                            }
                            default: {
                                sameGroupDetector.reset();
                            }
                        }
                    }
                }
                ++j;
                ++i;
            }
            progress.add(batch);
        }
        progress.done();
        if (numberOfCollisions > Integer.MAX_VALUE) {
            throw new InputException("Too many collisions: " + numberOfCollisions);
        }
        this.monitor.numberOfCollisions((int)numberOfCollisions);
        return (int)numberOfCollisions;
    }

    private boolean markAsCollision(int dataIndex) {
        long eId = this.dataCache.get(dataIndex);
        boolean isAlreadyMarked = EncodingIdMapper.isCollision(eId);
        if (isAlreadyMarked) {
            return false;
        }
        this.dataCache.set(dataIndex, EncodingIdMapper.setCollision(eId));
        return true;
    }

    private void buildCollisionInfo(InputIterator<Object> ids, int numberOfCollisions, Collector collector, ProgressListener progress) throws InterruptedException {
        progress.started("RESOLVE (" + numberOfCollisions + " collisions)");
        Radix radix = (Radix)this.radixFactory.newInstance();
        ArrayList<String> sourceDescriptions = new ArrayList<String>();
        String lastSourceDescription = null;
        this.collisionSourceDataCache = this.cacheFactory.newLongArray(numberOfCollisions, -1L);
        this.collisionTrackerCache = this.cacheFactory.newIntArray(numberOfCollisions, -1);
        long i = 0L;
        while (ids.hasNext()) {
            long j = 0L;
            while (j < 10000L && ids.hasNext()) {
                Object id = ids.next();
                long eId = this.dataCache.get(i);
                if (EncodingIdMapper.isCollision(eId)) {
                    long eIdFromInputId = this.encode(id);
                    long eIdWithoutCollisionBit = EncodingIdMapper.clearCollision(eId);
                    assert (eIdFromInputId == eIdWithoutCollisionBit) : String.format("Encoding mismatch during building of collision info. input id %s (a %s) marked as collision where this id was encoded into %d when put, but was now encoded into %d", id, id.getClass().getSimpleName(), eIdWithoutCollisionBit, eIdFromInputId);
                    int collisionIndex = this.collisionValues.size();
                    this.collisionValues.add(id);
                    this.collisionNodeIdCache.set(collisionIndex, i);
                    radix.registerRadixOf(eIdWithoutCollisionBit);
                    String currentSourceDescription = ids.sourceDescription();
                    if (lastSourceDescription == null || !currentSourceDescription.equals(lastSourceDescription)) {
                        sourceDescriptions.add(currentSourceDescription);
                        lastSourceDescription = currentSourceDescription;
                    }
                    this.collisionSourceDataCache.set(collisionIndex, SourceInformation.encodeSourceInformation(sourceDescriptions.size() - 1, ids.lineNumber()));
                }
                ++j;
                ++i;
            }
            progress.add(j);
        }
        progress.done();
        this.detectDuplicateInputIds(radix, numberOfCollisions, sourceDescriptions, collector, progress);
        this.collisionSourceDataCache = null;
        this.collisionTrackerCache = null;
    }

    private void detectDuplicateInputIds(Radix radix, int numberOfCollisions, List<String> sourceDescriptions, Collector collector, ProgressListener progress) throws InterruptedException {
        ParallelSort.Comparator duplicateComparator = new ParallelSort.Comparator(){

            @Override
            public boolean lt(long left, long pivot) {
                long leftEId = EncodingIdMapper.this.dataCache.get(left);
                long pivotEId = EncodingIdMapper.this.dataCache.get(pivot);
                if (EncodingIdMapper.this.comparator.lt(leftEId, pivotEId)) {
                    return true;
                }
                if (leftEId == pivotEId) {
                    return left < pivot;
                }
                return false;
            }

            @Override
            public boolean ge(long right, long pivot) {
                long rightEId = EncodingIdMapper.this.dataCache.get(right);
                long pivotEId = EncodingIdMapper.this.dataCache.get(pivot);
                if (EncodingIdMapper.this.comparator.ge(rightEId, pivotEId)) {
                    return rightEId == pivotEId ? right > pivot : true;
                }
                return false;
            }

            @Override
            public long dataValue(long nodeId) {
                return EncodingIdMapper.this.dataCache.get(nodeId);
            }
        };
        new ParallelSort(radix, this.collisionNodeIdCache, numberOfCollisions - 1, this.collisionTrackerCache, this.processorsForSorting, progress, duplicateComparator).run();
        long previousEid = 0L;
        int previousGroupId = -1;
        SourceInformation source = new SourceInformation();
        SameInputIdDetector detector = new SameInputIdDetector();
        progress.started("DEDUPLICATE");
        for (int i = 0; i < numberOfCollisions; ++i) {
            long j;
            for (j = 0L; j < 10000L && i < numberOfCollisions; ++j, ++i) {
                Object inputId;
                int detectorIndex;
                boolean same;
                int collisionIndex = this.collisionTrackerCache.get(i);
                long dataIndex = this.collisionNodeIdCache.get(collisionIndex);
                long eid = this.dataCache.get(dataIndex);
                long sourceInformation = this.collisionSourceDataCache.get(collisionIndex);
                source.decode(sourceInformation);
                IdGroup group = this.groupOf(dataIndex);
                int groupId = group.id();
                boolean bl = same = eid == previousEid && previousGroupId == groupId;
                if (!same) {
                    detector.clear();
                }
                if ((detectorIndex = detector.add(inputId = this.collisionValues.get(collisionIndex), sourceInformation)) != -1) {
                    String firstDataPoint = detector.sourceInformation(detectorIndex).describe(sourceDescriptions);
                    String otherDataPoint = source.describe(sourceDescriptions);
                    collector.collectDuplicateNode(inputId, dataIndex, group.name(), firstDataPoint, otherDataPoint);
                }
                previousEid = eid;
                previousGroupId = groupId;
            }
            progress.add(j);
        }
        progress.done();
    }

    private IdGroup groupOf(long dataIndex) {
        for (IdGroup idGroup : this.idGroups) {
            if (idGroup == null || !idGroup.covers(dataIndex)) continue;
            return idGroup;
        }
        throw new IllegalArgumentException("Strange, index " + dataIndex + " isn't included in a group");
    }

    private long binarySearch(long x, Object inputId, long low, long high, int groupId) {
        block4: while (low <= high) {
            long mid = low + (high - low) / 2L;
            int dataIndex = this.trackerCache.get(mid);
            if (dataIndex == -1) {
                return -1L;
            }
            long midValue = this.dataCache.get(dataIndex);
            switch (Utils.unsignedDifference(EncodingIdMapper.clearCollision(midValue), x)) {
                case EQ: {
                    if (mid > 0L && Utils.unsignedCompare(x, this.dataValue(mid - 1L), Utils.CompareType.EQ) || mid < this.highestSetIndex && Utils.unsignedCompare(x, this.dataValue(mid + 1L), Utils.CompareType.EQ)) {
                        return this.findFromEIdRange(mid, midValue, inputId, x, groupId);
                    }
                    return this.groupOf(dataIndex).id() == groupId ? (long)dataIndex : -1L;
                }
                case LT: {
                    low = mid + 1L;
                    continue block4;
                }
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long dataValue(long index) {
        return EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index)));
    }

    private long findIndex(LongArray array, long value) {
        long low = 0L;
        long high = this.highestSetIndex;
        block4: while (low <= high) {
            long mid = (low + high) / 2L;
            long midValue = array.get(mid);
            switch (Utils.unsignedDifference(midValue, value)) {
                case EQ: {
                    return mid;
                }
                case LT: {
                    low = mid + 1L;
                    continue block4;
                }
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long findFromEIdRange(long index, long val, Object inputId, long x, int groupId) {
        val = EncodingIdMapper.clearCollision(val);
        assert (val == x);
        while (index > 0L && Utils.unsignedCompare(val, this.dataValue(index - 1L), Utils.CompareType.EQ)) {
            --index;
        }
        long fromIndex = index;
        while (index < this.highestSetIndex && Utils.unsignedCompare(val, this.dataValue(index + 1L), Utils.CompareType.EQ)) {
            ++index;
        }
        long toIndex = index;
        return this.findFromEIdRange(fromIndex, toIndex, groupId, inputId);
    }

    private long findFromEIdRange(long fromIndex, long toIndex, int groupId, Object inputId) {
        long lowestFound = -1L;
        for (long index = fromIndex; index <= toIndex; ++index) {
            int dataIndex = this.trackerCache.get(index);
            IdGroup group = this.groupOf(dataIndex);
            if (groupId != group.id()) continue;
            long eId = this.dataCache.get(dataIndex);
            if (EncodingIdMapper.isCollision(eId)) {
                int collisionIndex = Utils.safeCastLongToInt(this.findIndex(this.collisionNodeIdCache, dataIndex));
                Object value = this.collisionValues.get(collisionIndex);
                if (!inputId.equals(value)) continue;
                lowestFound = lowestFound == -1L ? (long)dataIndex : Math.min(lowestFound, (long)dataIndex);
                continue;
            }
            lowestFound = dataIndex;
            break;
        }
        return lowestFound;
    }

    static boolean compareDataCache(LongArray dataCache, IntArray tracker, int a, int b, Utils.CompareType compareType) {
        int indexA = tracker.get(a);
        int indexB = tracker.get(b);
        if (indexA == -1 || indexB == -1) {
            return false;
        }
        return Utils.unsignedCompare(EncodingIdMapper.clearCollision(dataCache.get(indexA)), EncodingIdMapper.clearCollision(dataCache.get(indexB)), compareType);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.nullSafeAcceptMemoryStatsVisitor(visitor, this.dataCache);
        this.nullSafeAcceptMemoryStatsVisitor(visitor, this.trackerCache);
        this.nullSafeAcceptMemoryStatsVisitor(visitor, this.collisionTrackerCache);
        this.nullSafeAcceptMemoryStatsVisitor(visitor, this.collisionSourceDataCache);
        this.nullSafeAcceptMemoryStatsVisitor(visitor, this.collisionNodeIdCache);
    }

    private void nullSafeAcceptMemoryStatsVisitor(MemoryStatsVisitor visitor, MemoryStatsVisitor.Home mem) {
        if (mem != null) {
            mem.acceptMemoryStatsVisitor(visitor);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.encoder + "," + this.radix + "]";
    }

    private static class SameInputIdDetector {
        private Object[] inputIdArray = new Object[10];
        private long[] sourceInformationArray = new long[this.inputIdArray.length];
        private int cursor;
        private final SourceInformation source = new SourceInformation();

        private SameInputIdDetector() {
        }

        int add(Object inputId, long sourceInformation) {
            for (int i = 0; i < this.cursor; ++i) {
                if (!this.inputIdArray[i].equals(inputId)) continue;
                return i;
            }
            if (this.cursor == this.inputIdArray.length) {
                this.inputIdArray = Arrays.copyOf(this.inputIdArray, this.cursor * 2);
                this.sourceInformationArray = Arrays.copyOf(this.sourceInformationArray, this.cursor * 2);
            }
            this.inputIdArray[this.cursor] = inputId;
            this.sourceInformationArray[this.cursor] = sourceInformation;
            ++this.cursor;
            return -1;
        }

        SourceInformation sourceInformation(int index) {
            return this.source.decode(this.sourceInformationArray[index]);
        }

        void clear() {
            this.cursor = 0;
        }
    }

    public static interface Monitor {
        public void numberOfCollisions(int var1);
    }
}

