/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class LabelScanStorePopulationStep
extends ProcessorStep<Batch<InputNode, NodeRecord>> {
    private final LabelScanWriter writer;

    public LabelScanStorePopulationStep(StageControl control, Configuration config, LabelScanStore labelScanStore) {
        super(control, "LABEL SCAN", config, 1, new StatsProvider[0]);
        this.writer = labelScanStore.newWriter();
    }

    @Override
    protected void process(Batch<InputNode, NodeRecord> batch, BatchSender sender) throws Throwable {
        int length = batch.labels.length;
        for (int i = 0; i < length; ++i) {
            long[] labels = batch.labels[i];
            NodeRecord node = ((NodeRecord[])batch.records)[i];
            if (labels == null || !node.inUse()) continue;
            this.writer.write(NodeLabelUpdate.labelChanges(node.getId(), PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels));
        }
        sender.send(batch);
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.writer.close();
    }
}

