/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class HexPrinter {
    private final PrintStream out;
    private int bytesPerLine;
    private int bytesPerGroup;
    private String groupSeparator;
    private int maxLineNumberDigits;
    private String lineNumberPrefix;
    private String lineNumberSuffix;
    private long currentLineNumber;
    private int bytesOnThisLine;
    private static final int DEFAULT_BYTES_PER_GROUP = 8;
    private static final int DEFAULT_GROUPS_PER_LINE = 4;
    private static final int DEFAULT_MAX_LINE_NUMBER_DIGITS = 0;
    private static final String DEFAULT_GROUP_SEPARATOR = "    ";
    private static final String DEFAULT_LINE_NUMBER_PREFIX = "@ ";
    private static final String DEFAULT_LINE_NUMBER_SUFFIX = ": ";

    public HexPrinter withBytesPerLine(int bytesPerLine) {
        this.bytesPerLine = bytesPerLine;
        return this;
    }

    public HexPrinter withBytesPerGroup(int bytesPerGroup) {
        this.bytesPerGroup = bytesPerGroup;
        return this;
    }

    public HexPrinter withGroupSeparator(String separator) {
        this.groupSeparator = separator;
        return this;
    }

    public HexPrinter withLineNumberDigits(int maxLineNumberDigits) {
        this.maxLineNumberDigits = maxLineNumberDigits;
        return this;
    }

    public HexPrinter withLineNumberPrefix(String prefix) {
        this.lineNumberPrefix = prefix;
        return this;
    }

    public HexPrinter withLineNumberSuffix(String suffix) {
        this.lineNumberSuffix = suffix;
        return this;
    }

    public HexPrinter withLineNumberOffset(long offset) {
        this.currentLineNumber = offset;
        return this;
    }

    public HexPrinter withBytesGroupingFormat(int bytesPerLine, int bytesPerGroup, String separator) {
        this.bytesPerLine = bytesPerLine;
        this.bytesPerGroup = bytesPerGroup;
        this.groupSeparator = separator;
        return this;
    }

    public HexPrinter withLineNumberFormat(int maxLineNumberDigits, String prefix, String suffix) {
        this.maxLineNumberDigits = maxLineNumberDigits;
        this.lineNumberPrefix = prefix;
        this.lineNumberSuffix = suffix;
        return this;
    }

    public HexPrinter(PrintStream out) {
        this(out, 8, DEFAULT_GROUP_SEPARATOR);
    }

    public HexPrinter(PrintStream out, int bytesPerGroup, String groupSep) {
        this.out = out;
        this.bytesPerLine = 4 * bytesPerGroup;
        this.bytesPerGroup = bytesPerGroup;
        this.groupSeparator = groupSep;
        this.maxLineNumberDigits = 0;
        this.lineNumberPrefix = DEFAULT_LINE_NUMBER_PREFIX;
        this.lineNumberSuffix = DEFAULT_LINE_NUMBER_SUFFIX;
    }

    public HexPrinter append(byte value) {
        this.checkNewLine();
        this.addHexValue(value);
        return this;
    }

    public HexPrinter append(ReadableByteChannel source) throws IOException {
        return this.append(source, -1);
    }

    public HexPrinter append(ReadableByteChannel source, int atMost) throws IOException {
        boolean indefinite = atMost == -1;
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        block0: while (true) {
            int read;
            buffer.clear();
            if (!indefinite) {
                buffer.limit(Math.min(buffer.capacity(), atMost));
            }
            if ((read = source.read(buffer)) == -1) break;
            atMost -= read;
            buffer.flip();
            while (true) {
                if (!buffer.hasRemaining()) continue block0;
                this.append(buffer.get());
            }
            break;
        }
        return this;
    }

    public HexPrinter append(ByteBuffer bytes, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.append(bytes.get(i));
        }
        return this;
    }

    public HexPrinter append(ByteBuffer bytes) {
        return this.append(bytes, bytes.position(), bytes.remaining());
    }

    public HexPrinter append(byte[] bytes) {
        return this.append(ByteBuffer.wrap(bytes), 0, bytes.length);
    }

    private void addHexValue(byte value) {
        if (this.bytesOnThisLine != 1) {
            if (this.bytesOnThisLine % this.bytesPerGroup == 1) {
                this.out.append(this.groupSeparator);
            } else {
                this.out.append(" ");
            }
        }
        this.out.printf("%X%X", 0xF & value >> 4, 0xF & value);
    }

    private void checkNewLine() {
        if (this.bytesOnThisLine >= this.bytesPerLine) {
            this.out.println();
            this.bytesOnThisLine = 0;
            ++this.currentLineNumber;
        }
        if (this.bytesOnThisLine == 0 && this.maxLineNumberDigits > 0) {
            this.out.append(this.lineNumberPrefix);
            this.out.printf("0x%0" + this.maxLineNumberDigits + "X", this.currentLineNumber);
            this.out.append(this.lineNumberSuffix);
        }
        ++this.bytesOnThisLine;
    }

    public static String hex(ByteBuffer bytes, int offset, int length) {
        return HexPrinter.hex(bytes, offset, length, 8, DEFAULT_GROUP_SEPARATOR);
    }

    public static String hex(ByteBuffer bytes, int offset, int length, int bytesPerBlock, String groupSep) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        new HexPrinter(out, bytesPerBlock, groupSep).append(bytes, offset, length);
        out.flush();
        return outStream.toString();
    }

    public static String hex(ByteBuffer bytes) {
        return HexPrinter.hex(bytes, 8, DEFAULT_GROUP_SEPARATOR);
    }

    public static String hex(ByteBuffer bytes, int bytesPerBlock, String groupSep) {
        return HexPrinter.hex(bytes, bytes.position(), bytes.limit(), bytesPerBlock, groupSep);
    }

    public static String hex(byte[] bytes) {
        return HexPrinter.hex(bytes, 8, DEFAULT_GROUP_SEPARATOR);
    }

    public static String hex(byte[] bytes, int bytesPerBlock, String groupSep) {
        return HexPrinter.hex(ByteBuffer.wrap(bytes), bytesPerBlock, groupSep);
    }

    public static String hex(byte b) {
        return String.format("%02X", b);
    }
}

