/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;

public class StoreFlusher {
    private final NeoStores neoStores;
    private final IndexingService indexingService;
    private final LabelScanStore labelScanStore;
    private final Iterable<IndexImplementation> indexProviders;

    public StoreFlusher(StorageEngine storageEngine, Iterable<IndexImplementation> indexProviders) {
        this.neoStores = storageEngine.neoStores();
        this.indexingService = storageEngine.indexingService();
        this.labelScanStore = storageEngine.labelScanStore();
        this.indexProviders = indexProviders;
    }

    public void forceEverything() {
        this.indexingService.forceAll();
        this.labelScanStore.force();
        for (IndexImplementation index : this.indexProviders) {
            index.force();
        }
        this.neoStores.flush();
    }
}

