/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.ProcedureCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.cache.BridgingCacheAccess;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;

public class RecordStorageEngine
implements StorageEngine,
Lifecycle {
    private static final Setting<Boolean> use_read_locks_on_property_reads = Settings.setting("experimental.use_read_locks_on_property_reads", Settings.BOOLEAN, "true");
    private final StoreReadLayer storeLayer;
    private final IndexingService indexingService;
    private final NeoStores neoStores;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final KernelHealth kernelHealth;
    private final IndexConfigStore indexConfigStore;
    private final SchemaCache schemaCache;
    private final IntegrityValidator integrityValidator;
    private final IndexUpdatesValidator indexUpdatesValidator;
    private final CacheAccessBackDoor cacheAccess;
    private final LabelScanStore labelScanStore;
    private final DefaultSchemaIndexProviderMap providerMap;
    private final ProcedureCache procedureCache;
    private final LegacyIndexApplierLookup legacyIndexApplierLookup;

    public RecordStorageEngine(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, Runnable schemaStateChangeCallback, ConstraintSemantics constraintSemantics, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LockService lockService, SchemaIndexProvider indexProvider, IndexingService.Monitor indexingServiceMonitor, KernelHealth kernelHealth, LabelScanStoreProvider labelScanStoreProvider, LegacyIndexProviderLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore) {
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokens;
        this.labelTokenHolder = labelTokens;
        this.kernelHealth = kernelHealth;
        this.indexConfigStore = indexConfigStore;
        StoreFactory storeFactory = new StoreFactory(storeDir, config, idGeneratorFactory, pageCache, fs, logProvider);
        this.neoStores = storeFactory.openAllNeoStores(true);
        try {
            this.schemaCache = new SchemaCache(constraintSemantics, Collections.emptyList());
            SchemaStorage schemaStorage = new SchemaStorage(this.neoStores.getSchemaStore());
            this.providerMap = new DefaultSchemaIndexProviderMap(indexProvider);
            this.indexingService = IndexingService.create(new IndexSamplingConfig(config), scheduler, this.providerMap, new NeoStoreIndexStoreView(lockService, this.neoStores), tokenNameLookup, Iterables.toList(new SchemaStorage(this.neoStores.getSchemaStore()).allIndexRules()), logProvider, indexingServiceMonitor, schemaStateChangeCallback);
            this.integrityValidator = new IntegrityValidator(this.neoStores, this.indexingService);
            this.indexUpdatesValidator = new OnlineIndexUpdatesValidator(this.neoStores, kernelHealth, new PropertyLoader(this.neoStores), this.indexingService, IndexUpdateMode.ONLINE);
            this.cacheAccess = new BridgingCacheAccess(this.schemaCache, schemaStateChangeCallback, propertyKeyTokenHolder, relationshipTypeTokens, labelTokens);
            DiskLayer diskLayer = new DiskLayer(propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, schemaStorage, this.neoStores, this.indexingService, RecordStorageEngine.storeStatementFactory(this.neoStores, config, lockService));
            this.procedureCache = new ProcedureCache();
            this.storeLayer = new CacheLayer(diskLayer, this.schemaCache, this.procedureCache);
            this.labelScanStore = labelScanStoreProvider.getLabelScanStore();
            this.legacyIndexApplierLookup = new LegacyIndexApplierLookup.Direct(legacyIndexProviderLookup);
        }
        catch (Throwable failure) {
            this.neoStores.close();
            throw failure;
        }
    }

    private static Factory<StoreStatement> storeStatementFactory(NeoStores neoStores, Config config, LockService lockService) {
        LockService currentLockService = config.get(use_read_locks_on_property_reads) != false ? lockService : LockService.NO_LOCK_SERVICE;
        return () -> new StoreStatement(neoStores, currentLockService);
    }

    @Override
    public StoreReadLayer storeReadLayer() {
        return this.storeLayer;
    }

    @Override
    public TransactionIdStore transactionIdStore() {
        return this.neoStores.getMetaDataStore();
    }

    @Override
    public LogVersionRepository logVersionRepository() {
        return this.neoStores.getMetaDataStore();
    }

    @Override
    public ProcedureCache procedureCache() {
        return this.procedureCache;
    }

    @Override
    public NeoStores neoStores() {
        return this.neoStores;
    }

    @Override
    public MetaDataStore metaDataStore() {
        return this.neoStores.getMetaDataStore();
    }

    @Override
    public IndexingService indexingService() {
        return this.indexingService;
    }

    @Override
    public IndexUpdatesValidator indexUpdatesValidator() {
        return this.indexUpdatesValidator;
    }

    @Override
    public LabelScanStore labelScanStore() {
        return this.labelScanStore;
    }

    @Override
    public IntegrityValidator integrityValidator() {
        return this.integrityValidator;
    }

    @Override
    public SchemaIndexProviderMap schemaIndexProviderMap() {
        return this.providerMap;
    }

    @Override
    public CacheAccessBackDoor cacheAccess() {
        return this.cacheAccess;
    }

    @Override
    public LegacyIndexApplierLookup legacyIndexApplierLookup() {
        return this.legacyIndexApplierLookup;
    }

    @Override
    public IndexConfigStore indexConfigStore() {
        return this.indexConfigStore;
    }

    @Override
    public KernelHealth kernelHealth() {
        return this.kernelHealth;
    }

    @Override
    public void init() throws Throwable {
        this.indexingService.init();
        this.labelScanStore.init();
    }

    @Override
    public void start() throws Throwable {
        this.neoStores.makeStoreOk();
        this.propertyKeyTokenHolder.setInitialTokens(this.neoStores.getPropertyKeyTokenStore().getTokens(Integer.MAX_VALUE));
        this.relationshipTypeTokenHolder.setInitialTokens(this.neoStores.getRelationshipTypeTokenStore().getTokens(Integer.MAX_VALUE));
        this.labelTokenHolder.setInitialTokens(this.neoStores.getLabelTokenStore().getTokens(Integer.MAX_VALUE));
        this.neoStores.rebuildCountStoreIfNeeded();
        this.loadSchemaCache();
        this.indexingService.start();
        this.labelScanStore.start();
    }

    @Override
    public void loadSchemaCache() {
        List<SchemaRule> schemaRules = Iterables.toList(this.neoStores.getSchemaStore().loadAllSchemaRules());
        this.schemaCache.load(schemaRules);
    }

    @Override
    public void stop() throws Throwable {
        this.labelScanStore.stop();
        this.indexingService.stop();
    }

    @Override
    public void shutdown() throws Throwable {
        this.labelScanStore.shutdown();
        this.indexingService.shutdown();
    }
}

