/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.DefaultPropertyTokenCreator;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.DelegatingLabelTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingPropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingRelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class CommunityEditionModule
extends EditionModule {
    public CommunityEditionModule(PlatformModule platformModule) {
        Dependencies dependencies = platformModule.dependencies;
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        PageCache pageCache = platformModule.pageCache;
        File storeDir = platformModule.storeDir;
        DataSourceManager dataSourceManager = platformModule.dataSourceManager;
        LifeSupport life = platformModule.life;
        life.add(platformModule.dataSourceManager);
        GraphDatabaseFacade graphDatabaseFacade = platformModule.graphDatabaseFacade;
        this.lockManager = dependencies.satisfyDependency(CommunityEditionModule.createLockManager(config, logging));
        this.idGeneratorFactory = dependencies.satisfyDependency(this.createIdGeneratorFactory(fileSystem));
        this.propertyKeyTokenHolder = (PropertyKeyTokenHolder)((Object)life.add((Lifecycle)dependencies.satisfyDependency(new DelegatingPropertyKeyTokenHolder(this.createPropertyKeyCreator(config, dataSourceManager, this.idGeneratorFactory)))));
        this.labelTokenHolder = (LabelTokenHolder)((Object)life.add((Lifecycle)dependencies.satisfyDependency(new DelegatingLabelTokenHolder(this.createLabelIdCreator(config, dataSourceManager, this.idGeneratorFactory)))));
        this.relationshipTypeTokenHolder = (RelationshipTypeTokenHolder)((Object)life.add((Lifecycle)dependencies.satisfyDependency(new DelegatingRelationshipTypeTokenHolder(this.createRelationshipTypeCreator(config, dataSourceManager, this.idGeneratorFactory)))));
        dependencies.satisfyDependency(this.createKernelData(fileSystem, pageCache, storeDir, config, graphDatabaseFacade, life));
        this.commitProcessFactory = new CommunityCommitProcessFactory();
        this.headerInformationFactory = this.createHeaderInformationFactory();
        this.schemaWriteGuard = this.createSchemaWriteGuard();
        this.transactionStartTimeout = config.get(GraphDatabaseSettings.transaction_start_timeout);
        this.upgradeConfiguration = new ConfigMapUpgradeConfiguration(config);
        this.constraintSemantics = this.createSchemaRuleVerifier();
        this.registerRecovery(config.get(GraphDatabaseFacadeFactory.Configuration.editionName), life, dependencies);
        this.publishEditionInfo(dependencies.resolveDependency(UsageData.class));
    }

    protected ConstraintSemantics createSchemaRuleVerifier() {
        return new StandardConstraintSemantics();
    }

    private void publishEditionInfo(UsageData sysInfo) {
        sysInfo.set(UsageDataKeys.edition, this.determineEdition());
        sysInfo.set(UsageDataKeys.operationalMode, UsageDataKeys.OperationalMode.single);
    }

    private UsageDataKeys.Edition determineEdition() {
        try {
            this.getClass().getClassLoader().loadClass("org.neo4j.kernel.ha.HighlyAvailableGraphDatabase");
            return UsageDataKeys.Edition.enterprise;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                this.getClass().getClassLoader().loadClass("org.neo4j.management.Neo4jManager");
                return UsageDataKeys.Edition.advanced;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return UsageDataKeys.Edition.community;
            }
        }
    }

    protected SchemaWriteGuard createSchemaWriteGuard() {
        return new SchemaWriteGuard(){

            @Override
            public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
            }
        };
    }

    protected TokenCreator createRelationshipTypeCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultRelationshipTypeCreator(dataSourceManager, idGeneratorFactory);
    }

    protected TokenCreator createPropertyKeyCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultPropertyTokenCreator(dataSourceManager, idGeneratorFactory);
    }

    protected TokenCreator createLabelIdCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultLabelIdCreator(dataSourceManager, idGeneratorFactory);
    }

    protected KernelData createKernelData(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, Config config, GraphDatabaseAPI graphAPI, LifeSupport life) {
        return life.add(new DefaultKernelData(fileSystem, pageCache, storeDir, config, graphAPI));
    }

    protected IdGeneratorFactory createIdGeneratorFactory(FileSystemAbstraction fs) {
        return new DefaultIdGeneratorFactory(fs);
    }

    public static Locks createLockManager(Config config, LogService logging) {
        String key = config.get(GraphDatabaseFacadeFactory.Configuration.lock_manager);
        for (Locks.Factory candidate : Service.load(Locks.Factory.class)) {
            String candidateId = candidate.getKeys().iterator().next();
            if (candidateId.equals(key)) {
                return candidate.newInstance(ResourceTypes.values());
            }
            if (!key.equals("")) continue;
            logging.getInternalLog(CommunityFacadeFactory.class).info("No locking implementation specified, defaulting to '" + candidateId + "'");
            return candidate.newInstance(ResourceTypes.values());
        }
        if (key.equals("community")) {
            return new CommunityLockManger();
        }
        if (key.equals("")) {
            logging.getInternalLog(CommunityFacadeFactory.class).info("No locking implementation specified, defaulting to 'community'");
            return new CommunityLockManger();
        }
        throw new IllegalArgumentException("No lock manager found with the name '" + key + "'.");
    }

    protected TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return TransactionHeaderInformationFactory.DEFAULT;
    }

    protected void registerRecovery(final String editionName, LifeSupport life, final DependencyResolver dependencyResolver) {
        life.addLifecycleListener(new LifecycleListener(){

            @Override
            public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (instance instanceof DatabaseAvailability && to.equals((Object)LifecycleStatus.STARTED)) {
                    CommunityEditionModule.this.doAfterRecoveryAndStartup(editionName, dependencyResolver);
                }
            }
        });
    }

    @Override
    protected void doAfterRecoveryAndStartup(String editionName, DependencyResolver dependencyResolver) {
        super.doAfterRecoveryAndStartup(editionName, dependencyResolver);
        new RemoveOrphanConstraintIndexesOnStartup(dependencyResolver.resolveDependency(NeoStoreDataSource.class).getKernel(), dependencyResolver.resolveDependency(LogService.class).getInternalLogProvider()).perform();
    }

    protected final class DefaultKernelData
    extends KernelData
    implements Lifecycle {
        private final GraphDatabaseAPI graphDb;

        public DefaultKernelData(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, Config config, GraphDatabaseAPI graphDb) {
            super(fileSystem, pageCache, storeDir, config);
            this.graphDb = graphDb;
        }

        @Override
        public Version version() {
            return Version.getKernel();
        }

        @Override
        public GraphDatabaseAPI graphDatabase() {
            return this.graphDb;
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }
    }
}

