/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

public class IndexPopulationProgress {
    public static final IndexPopulationProgress NONE = new IndexPopulationProgress(0L, 0L);
    public static final IndexPopulationProgress DONE = new IndexPopulationProgress(1L, 1L);
    private final long completedCount;
    private final long totalCount;

    public IndexPopulationProgress(long completed, long total) {
        if (total < 0L || completed < 0L || completed > total) {
            throw new IllegalArgumentException("Invalid progress specified: " + completed + "/" + total);
        }
        this.completedCount = completed;
        this.totalCount = total;
    }

    public float getCompletedPercentage() {
        if (this.totalCount > 0L) {
            return (float)(this.completedCount * 100L) / (float)this.totalCount;
        }
        return 0.0f;
    }

    public long getCompletedCount() {
        return this.completedCount;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public String toString() {
        return String.format("%1.1f%%", Float.valueOf(this.getCompletedPercentage()));
    }
}

