/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.kernel.impl.api.CommandApplierFacade;
import org.neo4j.kernel.impl.api.CountsStoreApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.transaction.CommandStream;
import org.neo4j.kernel.impl.transaction.command.CacheInvalidationTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.CommandHandler;
import org.neo4j.kernel.impl.transaction.command.HighIdTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.function.Optional;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class TransactionRepresentationStoreApplier {
    private final LockService lockService;
    private final Supplier<LabelScanWriter> labelScanWriters;
    private final IndexConfigStore indexConfigStore;
    private final LegacyIndexApplierLookup legacyIndexProviderLookup;
    private final IdOrderingQueue legacyIndexTransactionOrdering;
    private final WorkSync<Supplier<LabelScanWriter>, IndexTransactionApplier.LabelUpdateWork> labelScanStoreSync;
    private final StorageEngine storageEngine;

    public TransactionRepresentationStoreApplier(Supplier<LabelScanWriter> labelScanWriters, LockService lockService, IndexConfigStore indexConfigStore, IdOrderingQueue legacyIndexTransactionOrdering, StorageEngine storageEngine) {
        this.storageEngine = storageEngine;
        this.labelScanWriters = labelScanWriters;
        this.lockService = lockService;
        this.legacyIndexProviderLookup = storageEngine.legacyIndexApplierLookup();
        this.indexConfigStore = indexConfigStore;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
        this.labelScanStoreSync = new WorkSync(labelScanWriters);
    }

    public void apply(CommandStream representation, ValidatedIndexUpdates indexUpdates, LockGroup locks, long transactionId, TransactionApplicationMode mode) throws IOException {
        CommandHandler storeApplier = new NeoStoreTransactionApplier(this.storageEngine.neoStores(), this.storageEngine.cacheAccess(), this.lockService, locks, transactionId);
        if (mode.needsIdTracking()) {
            storeApplier = new HighIdTransactionApplier(storeApplier, this.storageEngine.neoStores());
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            storeApplier = new CacheInvalidationTransactionApplier(storeApplier, this.storageEngine.neoStores(), this.storageEngine.cacheAccess());
        }
        IndexTransactionApplier indexApplier = new IndexTransactionApplier(this.storageEngine.indexingService(), indexUpdates, this.labelScanStoreSync);
        LegacyIndexApplier legacyIndexApplier = new LegacyIndexApplier(this.indexConfigStore, this.legacyIndexProviderLookup, this.legacyIndexTransactionOrdering, transactionId, mode);
        CommandHandler countsStoreApplier = this.getCountsStoreApplier(transactionId, mode);
        try (CommandApplierFacade applier = new CommandApplierFacade(storeApplier, indexApplier, legacyIndexApplier, countsStoreApplier);){
            representation.accept(applier);
        }
        catch (Throwable cause) {
            this.storageEngine.kernelHealth().panic(cause);
            throw cause;
        }
    }

    private CommandHandler getCountsStoreApplier(long transactionId, TransactionApplicationMode mode) {
        Optional<CommandHandler> handlerOption = this.storageEngine.neoStores().getCounts().apply(transactionId).map(CountsStoreApplier.FACTORY);
        if (mode == TransactionApplicationMode.RECOVERY) {
            handlerOption = handlerOption.or(CommandHandler.EMPTY);
        }
        return handlerOption.get();
    }

    public TransactionRepresentationStoreApplier withLegacyIndexTransactionOrdering(IdOrderingQueue legacyIndexTransactionOrdering) {
        return new TransactionRepresentationStoreApplier(this.labelScanWriters, this.lockService, this.indexConfigStore, legacyIndexTransactionOrdering, this.storageEngine);
    }
}

