/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.LegacyIndexTransactionStateImpl;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextFactory;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;

public class KernelTransactions
extends LifecycleAdapter
implements Factory<KernelTransaction> {
    private final NeoStoreTransactionContextFactory neoStoreTransactionContextFactory;
    private final Locks locks;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StatementOperationParts statementOperations;
    private final UpdateableSchemaState updateableSchemaState;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final TransactionCommitProcess transactionCommitProcess;
    private final IndexConfigStore indexConfigStore;
    private final LegacyIndexProviderLookup legacyIndexProviderLookup;
    private final TransactionHooks hooks;
    private final ConstraintSemantics constraintSemantics;
    private final TransactionMonitor transactionMonitor;
    private final LifeSupport dataSourceLife;
    private final Tracers tracers;
    private final StorageEngine storageEngine;
    private final Set<KernelTransactionImplementation> allTransactions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Factory<KernelTransactionImplementation> factory = new Factory<KernelTransactionImplementation>(){

        public KernelTransactionImplementation newInstance() {
            Locks.Client locksClient = KernelTransactions.this.locks.newClient();
            NeoStoreTransactionContext context = KernelTransactions.this.neoStoreTransactionContextFactory.newInstance(locksClient);
            TransactionRecordState recordState = new TransactionRecordState(KernelTransactions.this.storageEngine.neoStores(), KernelTransactions.this.storageEngine.integrityValidator(), context);
            LegacyIndexTransactionStateImpl legacyIndexTransactionState = new LegacyIndexTransactionStateImpl(KernelTransactions.this.indexConfigStore, KernelTransactions.this.legacyIndexProviderLookup);
            KernelTransactionImplementation tx = new KernelTransactionImplementation(KernelTransactions.this.statementOperations, KernelTransactions.this.schemaWriteGuard, KernelTransactions.this.updateableSchemaState, recordState, locksClient, KernelTransactions.this.hooks, KernelTransactions.this.constraintIndexCreator, KernelTransactions.this.transactionHeaderInformationFactory, KernelTransactions.this.transactionCommitProcess, KernelTransactions.this.transactionMonitor, legacyIndexTransactionState, (Pool<KernelTransactionImplementation>)KernelTransactions.this.localTxPool, KernelTransactions.this.constraintSemantics, Clock.SYSTEM_CLOCK, ((KernelTransactions)KernelTransactions.this).tracers.transactionTracer, KernelTransactions.this.storageEngine);
            KernelTransactions.this.allTransactions.add(tx);
            return tx;
        }
    };
    private final LinkedQueuePool<KernelTransactionImplementation> globalTxPool = new LinkedQueuePool<KernelTransactionImplementation>(8, this.factory){

        protected void dispose(KernelTransactionImplementation tx) {
            KernelTransactions.this.allTransactions.remove(tx);
            tx.dispose();
            super.dispose((Object)tx);
        }
    };
    private final MarshlandPool<KernelTransactionImplementation> localTxPool = new MarshlandPool(this.globalTxPool);

    public KernelTransactions(NeoStoreTransactionContextFactory neoStoreTransactionContextFactory, Locks locks, ConstraintIndexCreator constraintIndexCreator, StatementOperationParts statementOperations, UpdateableSchemaState updateableSchemaState, SchemaWriteGuard schemaWriteGuard, TransactionHeaderInformationFactory txHeaderFactory, TransactionCommitProcess transactionCommitProcess, IndexConfigStore indexConfigStore, LegacyIndexProviderLookup legacyIndexProviderLookup, TransactionHooks hooks, ConstraintSemantics constraintSemantics, TransactionMonitor transactionMonitor, LifeSupport dataSourceLife, Tracers tracers, StorageEngine storageEngine) {
        this.neoStoreTransactionContextFactory = neoStoreTransactionContextFactory;
        this.locks = locks;
        this.constraintIndexCreator = constraintIndexCreator;
        this.statementOperations = statementOperations;
        this.updateableSchemaState = updateableSchemaState;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionHeaderInformationFactory = txHeaderFactory;
        this.transactionCommitProcess = transactionCommitProcess;
        this.indexConfigStore = indexConfigStore;
        this.legacyIndexProviderLookup = legacyIndexProviderLookup;
        this.hooks = hooks;
        this.constraintSemantics = constraintSemantics;
        this.transactionMonitor = transactionMonitor;
        this.dataSourceLife = dataSourceLife;
        this.tracers = tracers;
        this.storageEngine = storageEngine;
    }

    public KernelTransaction newInstance() {
        this.assertDatabaseIsRunning();
        return ((KernelTransactionImplementation)this.localTxPool.acquire()).initialize(this.storageEngine.metaDataStore().getLastCommittedTransactionId());
    }

    public List<KernelTransaction> activeTransactions() {
        ArrayList<KernelTransaction> output = new ArrayList<KernelTransaction>();
        for (KernelTransactionImplementation tx : this.allTransactions) {
            if (!tx.isOpen()) continue;
            output.add(tx);
        }
        return output;
    }

    public void disposeAll() {
        for (KernelTransactionImplementation tx : this.allTransactions) {
            tx.markForTermination();
        }
        this.localTxPool.disposeAll();
        this.globalTxPool.disposeAll();
    }

    @Override
    public void shutdown() throws Throwable {
        this.disposeAll();
    }

    private void assertDatabaseIsRunning() {
        if (!this.dataSourceLife.isRunning()) {
            throw new DatabaseShutdownException();
        }
    }
}

