/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandler;

public class CommandApplierFacade
implements CommandHandler,
Visitor<Command, IOException> {
    private final CommandHandler[] handlers;

    public CommandApplierFacade(CommandHandler ... handlers) {
        this.handlers = handlers;
    }

    @Override
    public void apply() {
        throw new UnsupportedOperationException("This method should not be called, only I call apply() methods");
    }

    @Override
    public void close() {
        int i;
        try {
            i = this.handlers.length;
            while (i-- > 0) {
                this.handlers[i].apply();
            }
        }
        finally {
            i = this.handlers.length;
            while (i-- > 0) {
                this.handlers[i].close();
            }
        }
    }

    @Override
    public boolean visit(Command element) throws IOException {
        element.handle(this);
        return false;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitNodeCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitRelationshipCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitPropertyCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitRelationshipGroupCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitRelationshipTypeTokenCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitPropertyKeyTokenCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitSchemaRuleCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitNeoStoreCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitLabelTokenCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitIndexRemoveCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitIndexAddNodeCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitIndexAddRelationshipCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitIndexDeleteCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitIndexCreateCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitIndexDefineCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitNodeCountsCommand(command)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
        boolean result = false;
        for (CommandHandler handler : this.handlers) {
            if (!handler.visitRelationshipCountsCommand(command)) continue;
            result = true;
        }
        return result;
    }
}

