/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.RecoveryLabelScanWriterProvider;
import org.neo4j.kernel.impl.api.RecoveryLegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class BatchingTransactionRepresentationStoreApplier
extends TransactionRepresentationStoreApplier {
    private final RecoveryLabelScanWriterProvider labelScanWriterProvider;
    private final RecoveryLegacyIndexApplierLookup legacyIndexApplierLookup;
    private final KernelHealth health;
    private final IndexingService indexingService;

    public BatchingTransactionRepresentationStoreApplier(LockService lockService, IndexConfigStore indexConfigStore, IdOrderingQueue legacyIndexTransactionOrdering, StorageEngine storageEngine) {
        this(new RecoveryLabelScanWriterProvider(storageEngine.labelScanStore(), 1000), lockService, new RecoveryLegacyIndexApplierLookup(storageEngine.legacyIndexApplierLookup(), 1000), indexConfigStore, legacyIndexTransactionOrdering, storageEngine);
    }

    private BatchingTransactionRepresentationStoreApplier(RecoveryLabelScanWriterProvider labelScanWriterProvider, LockService lockService, RecoveryLegacyIndexApplierLookup legacyIndexApplierLookup, IndexConfigStore indexConfigStore, IdOrderingQueue legacyIndexTransactionOrdering, StorageEngine storageEngine) {
        super(labelScanWriterProvider, lockService, indexConfigStore, legacyIndexTransactionOrdering, storageEngine);
        this.labelScanWriterProvider = labelScanWriterProvider;
        this.legacyIndexApplierLookup = legacyIndexApplierLookup;
        this.health = storageEngine.kernelHealth();
        this.indexingService = storageEngine.indexingService();
    }

    public void closeBatch() throws IOException {
        try {
            this.labelScanWriterProvider.close();
            this.legacyIndexApplierLookup.close();
            this.indexingService.flushAll();
        }
        catch (Throwable ex) {
            this.health.panic(ex);
            throw ex;
        }
    }
}

