/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.RecoveryLabelScanWriterProvider;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.GuardingStatementOperations;
import org.neo4j.kernel.impl.api.Kernel;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.RecoveryLegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.RecoveryIndexingUpdatesValidator;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogFileRecoverer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholds;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CountCommittedTransactionThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TimeCheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.log.rotation.StoreFlusher;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextFactory;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.kernel.impl.transaction.state.RecoveryVisitor;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.Lifecycles;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.kernel.recovery.DefaultRecoverySPI;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class NeoStoreDataSource
implements NeoStoresSupplier,
Lifecycle,
IndexProviders {
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    private final Monitors monitors;
    private final Tracers tracers;
    private final Log msgLog;
    private final LogProvider logProvider;
    private final DependencyResolver dependencyResolver;
    private final TokenNameLookup tokenNameLookup;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokens;
    private final RelationshipTypeTokenHolder relationshipTypeTokens;
    private final Locks locks;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionEventHandlers transactionEventHandlers;
    private final IdGeneratorFactory idGeneratorFactory;
    private final JobScheduler scheduler;
    private final Config config;
    private final LockService lockService;
    private final IndexingService.Monitor indexingServiceMonitor;
    private final FileSystemAbstraction fs;
    private final StoreUpgrader storeMigrationProcess;
    private final TransactionMonitor transactionMonitor;
    private final KernelHealth kernelHealth;
    private final PhysicalLogFile.Monitor physicalLogMonitor;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final StartupStatisticsProvider startupStatistics;
    private final NodeManager nodeManager;
    private final CommitProcessFactory commitProcessFactory;
    private final PageCache pageCache;
    private final AtomicInteger recoveredCount = new AtomicInteger();
    private final Guard guard;
    private final Map<String, IndexImplementation> indexProviders = new HashMap<String, IndexImplementation>();
    private final LegacyIndexProviderLookup legacyIndexProviderLookup;
    private final ConstraintSemantics constraintSemantics;
    private Dependencies dependencies;
    private LifeSupport life;
    private SchemaIndexProvider indexProvider;
    private File storeDir;
    private boolean readOnly;
    private StorageEngine storageEngine;
    private TransactionLogModule transactionLogModule;
    private KernelModule kernelModule;

    public NeoStoreDataSource(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, LogProvider logProvider, JobScheduler scheduler, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver, PropertyKeyTokenHolder propertyKeyTokens, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, Locks lockManager, SchemaWriteGuard schemaWriteGuard, TransactionEventHandlers transactionEventHandlers, IndexingService.Monitor indexingServiceMonitor, FileSystemAbstraction fs, StoreUpgrader storeMigrationProcess, TransactionMonitor transactionMonitor, KernelHealth kernelHealth, PhysicalLogFile.Monitor physicalLogMonitor, TransactionHeaderInformationFactory transactionHeaderInformationFactory, StartupStatisticsProvider startupStatistics, NodeManager nodeManager, Guard guard, CommitProcessFactory commitProcessFactory, PageCache pageCache, ConstraintSemantics constraintSemantics, Monitors monitors, Tracers tracers) {
        this.storeDir = storeDir;
        this.config = config;
        this.tokenNameLookup = tokenNameLookup;
        this.dependencyResolver = dependencyResolver;
        this.scheduler = scheduler;
        this.logProvider = logProvider;
        this.propertyKeyTokenHolder = propertyKeyTokens;
        this.labelTokens = labelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
        this.locks = lockManager;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionEventHandlers = transactionEventHandlers;
        this.indexingServiceMonitor = indexingServiceMonitor;
        this.fs = fs;
        this.storeMigrationProcess = storeMigrationProcess;
        this.transactionMonitor = transactionMonitor;
        this.kernelHealth = kernelHealth;
        this.physicalLogMonitor = physicalLogMonitor;
        this.transactionHeaderInformationFactory = transactionHeaderInformationFactory;
        this.startupStatistics = startupStatistics;
        this.nodeManager = nodeManager;
        this.guard = guard;
        this.constraintSemantics = constraintSemantics;
        this.monitors = monitors;
        this.tracers = tracers;
        this.readOnly = config.get(Configuration.read_only);
        this.msgLog = logProvider.getLog(this.getClass());
        this.idGeneratorFactory = idGeneratorFactory;
        this.lockService = new ReentrantLockService();
        this.legacyIndexProviderLookup = new LegacyIndexProviderLookup(){

            public IndexImplementation apply(String name) {
                assert (name != null) : "Null provider name supplied";
                IndexImplementation provider = (IndexImplementation)NeoStoreDataSource.this.indexProviders.get(name);
                if (provider == null) {
                    throw new IllegalArgumentException("No index provider '" + name + "' found. Maybe the intended provider (or one more of its " + "dependencies) " + "aren't on the classpath or it failed to load.");
                }
                return provider;
            }

            @Override
            public Iterable<IndexImplementation> all() {
                return NeoStoreDataSource.this.indexProviders.values();
            }
        };
        this.commitProcessFactory = commitProcessFactory;
        this.pageCache = pageCache;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() throws IOException {
        this.dependencies = new Dependencies();
        this.life = new LifeSupport();
        this.indexProvider = this.dependencyResolver.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        IndexConfigStore indexConfigStore = new IndexConfigStore(this.storeDir, this.fs);
        this.dependencies.satisfyDependency(this.lockService);
        this.dependencies.satisfyDependency(indexConfigStore);
        this.life.add(indexConfigStore);
        LoggingLogFileMonitor loggingLogMonitor = new LoggingLogFileMonitor(this.msgLog);
        this.monitors.addMonitorListener(loggingLogMonitor, new String[0]);
        this.monitors.addMonitorListener(txId -> this.recoveredCount.incrementAndGet(), new String[0]);
        this.life.add(new Lifecycle.Delegate(Lifecycles.multiple(this.indexProviders.values())));
        this.upgradeStore(this.storeDir, this.storeMigrationProcess, this.indexProvider);
        StorageEngine storageEngine = null;
        try {
            KernelSchemaStateStore updateableSchemaState = new KernelSchemaStateStore(this.logProvider);
            storageEngine = this.buildStorageEngine(this.propertyKeyTokenHolder, this.labelTokens, this.relationshipTypeTokens, this.legacyIndexProviderLookup, indexConfigStore, updateableSchemaState::clear);
            TransactionLogModule transactionLogModule = this.buildTransactionLogs(this.storeDir, this.config, this.logProvider, this.scheduler, this.fs, this.indexProviders.values(), storageEngine);
            this.buildRecovery(this.fs, storageEngine.indexingService(), storageEngine.labelScanStore(), storageEngine.neoStores(), this.monitors.newMonitor(RecoveryVisitor.Monitor.class, new String[0]), this.monitors.newMonitor(Recovery.Monitor.class, new String[0]), transactionLogModule.logFiles(), transactionLogModule.storeFlusher(), this.startupStatistics, storageEngine.legacyIndexApplierLookup(), storageEngine);
            KernelModule kernelModule = this.buildKernel(transactionLogModule.transactionAppender(), storageEngine.neoStores(), transactionLogModule.storeApplier(), storageEngine.indexingService(), storageEngine.indexUpdatesValidator(), storageEngine.storeReadLayer(), updateableSchemaState, storageEngine.labelScanStore(), storageEngine);
            this.storageEngine = storageEngine;
            this.transactionLogModule = transactionLogModule;
            this.kernelModule = kernelModule;
            this.dependencies.satisfyDependency(this);
            this.dependencies.satisfyDependency(updateableSchemaState);
            this.dependencies.satisfyDependency(storageEngine.cacheAccess());
            this.dependencies.satisfyDependency(storageEngine.indexingService());
            this.dependencies.satisfyDependency(storageEngine.indexUpdatesValidator());
            this.dependencies.satisfyDependency(storageEngine.integrityValidator());
            this.dependencies.satisfyDependency(storageEngine.labelScanStore());
            this.dependencies.satisfyDependency(storageEngine.metaDataStore());
            this.dependencies.satisfyDependency(storageEngine.neoStores());
            this.dependencies.satisfyDependency(storageEngine.procedureCache());
            this.dependencies.satisfyDependency(storageEngine.schemaIndexProviderMap());
            this.dependencies.satisfyDependency(storageEngine.legacyIndexApplierLookup());
            this.dependencies.satisfyDependency(storageEngine.storeReadLayer());
            this.dependencies.satisfyDependency(storageEngine);
            this.satisfyDependencies(transactionLogModule, kernelModule);
        }
        catch (Throwable e) {
            this.msgLog.warn("Exception occurred while setting up store modules. Attempting to close things down.", new Object[]{e, true});
            try {
                if (storageEngine != null) {
                    storageEngine.neoStores().close();
                }
            }
            catch (Exception closeException) {
                this.msgLog.error("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
        try {
            this.life.start();
        }
        catch (Throwable e) {
            this.msgLog.warn("Exception occurred while starting the datasource. Attempting to close things down.", new Object[]{e, true});
            try {
                storageEngine.neoStores().close();
            }
            catch (Exception closeException) {
                this.msgLog.error("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
        this.kernelHealth.healed();
    }

    private void upgradeStore(File storeDir, StoreUpgrader storeMigrationProcess, SchemaIndexProvider indexProvider) {
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCache), new LegacyStoreVersionCheck(this.fs));
        storeMigrationProcess.addParticipant(indexProvider.storeMigrationParticipant(this.fs, this.pageCache));
        storeMigrationProcess.migrateIfNeeded(storeDir, upgradableDatabase, indexProvider);
    }

    private StorageEngine buildStorageEngine(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, LegacyIndexProviderLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore, Runnable schemaStateChangeCallback) {
        LabelScanStoreProvider labelScanStore = this.dependencyResolver.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED);
        return this.life.add(new RecordStorageEngine(this.storeDir, this.config, this.idGeneratorFactory, this.pageCache, this.fs, this.logProvider, propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, schemaStateChangeCallback, this.constraintSemantics, this.scheduler, this.tokenNameLookup, this.lockService, this.indexProvider, this.indexingServiceMonitor, this.kernelHealth, labelScanStore, legacyIndexProviderLookup, indexConfigStore));
    }

    private TransactionLogModule buildTransactionLogs(File storeDir, Config config, LogProvider logProvider, JobScheduler scheduler, FileSystemAbstraction fileSystemAbstraction, Iterable<IndexImplementation> indexProviders, StorageEngine storageEngine) {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(1000, 100000);
        final PhysicalLogFiles logFiles = new PhysicalLogFiles(storeDir, "neostore.transaction.db", fileSystemAbstraction);
        final SynchronizedArrayIdOrderingQueue legacyIndexTransactionOrdering = new SynchronizedArrayIdOrderingQueue(20);
        final TransactionRepresentationStoreApplier storeApplier = this.dependencies.satisfyDependency(new TransactionRepresentationStoreApplier(this.alwaysCreateNewWriter(storageEngine.labelScanStore()), this.lockService, storageEngine.indexConfigStore(), legacyIndexTransactionOrdering, storageEngine));
        TransactionIdStore transactionIdStore = storageEngine.transactionIdStore();
        final PhysicalLogFile logFile = this.life.add(new PhysicalLogFile(fileSystemAbstraction, logFiles, config.get(GraphDatabaseSettings.logical_log_rotation_threshold), transactionIdStore, storageEngine.logVersionRepository(), this.physicalLogMonitor, transactionMetadataCache));
        PhysicalLogFileInformation.LogVersionToTimestamp logInformation = new PhysicalLogFileInformation.LogVersionToTimestamp(){

            @Override
            public long getTimestampForVersion(long version) throws IOException {
                LogPosition position = LogPosition.start(version);
                try (ReadableVersionableLogChannel channel = logFile.getReader(position);){
                    LogEntry entry;
                    VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
                    while ((entry = reader.readLogEntry(channel)) != null) {
                        if (!(entry instanceof LogEntryStart)) continue;
                        long l = ((LogEntryStart)entry.as()).getTimeWritten();
                        return l;
                    }
                }
                return -1L;
            }
        };
        final PhysicalLogFileInformation logFileInformation = new PhysicalLogFileInformation(logFiles, transactionMetadataCache, transactionIdStore, logInformation);
        String pruningConf = config.get(config.get(GraphDatabaseFacadeFactory.Configuration.ephemeral) != false ? GraphDatabaseFacadeFactory.Configuration.ephemeral_keep_logical_logs : GraphDatabaseSettings.keep_logical_logs);
        LogPruneStrategy logPruneStrategy = LogPruneStrategyFactory.fromConfigValue(this.fs, logFileInformation, logFiles, pruningConf);
        LogPruningImpl logPruning = new LogPruningImpl(logPruneStrategy, logProvider);
        final StoreFlusher storeFlusher = new StoreFlusher(storageEngine, indexProviders);
        final LogRotationImpl logRotation = new LogRotationImpl(this.monitors.newMonitor(LogRotation.Monitor.class, new String[0]), logFile, this.kernelHealth);
        final TransactionAppender appender = this.life.add(new BatchingTransactionAppender(logFile, logRotation, transactionMetadataCache, transactionIdStore, legacyIndexTransactionOrdering, this.kernelHealth));
        final PhysicalLogicalTransactionStore logicalTransactionStore = new PhysicalLogicalTransactionStore(logFile, transactionMetadataCache);
        int txThreshold = config.get(GraphDatabaseSettings.check_point_interval_tx);
        CountCommittedTransactionThreshold countCommittedTransactionThreshold = new CountCommittedTransactionThreshold(txThreshold);
        long timeMillisThreshold = config.get(GraphDatabaseSettings.check_point_interval_time);
        TimeCheckPointThreshold timeCheckPointThreshold = new TimeCheckPointThreshold(timeMillisThreshold, Clock.SYSTEM_CLOCK);
        CheckPointThreshold threshold = CheckPointThresholds.or(countCommittedTransactionThreshold, timeCheckPointThreshold);
        final CheckPointerImpl checkPointer = new CheckPointerImpl(transactionIdStore, threshold, storeFlusher, logPruning, appender, this.kernelHealth, logProvider, this.tracers.checkPointTracer);
        long recurringPeriod = Math.min(timeMillisThreshold, TimeUnit.SECONDS.toMillis(10L));
        CheckPointScheduler checkPointScheduler = new CheckPointScheduler(checkPointer, scheduler, recurringPeriod);
        this.life.add(checkPointer);
        this.life.add(checkPointScheduler);
        return new TransactionLogModule(){

            @Override
            public TransactionRepresentationStoreApplier storeApplier() {
                return storeApplier;
            }

            @Override
            public LogicalTransactionStore logicalTransactionStore() {
                return logicalTransactionStore;
            }

            @Override
            public LogFileInformation logFileInformation() {
                return logFileInformation;
            }

            @Override
            public PhysicalLogFiles logFiles() {
                return logFiles;
            }

            @Override
            public LogFile logFile() {
                return logFile;
            }

            @Override
            public StoreFlusher storeFlusher() {
                return storeFlusher;
            }

            @Override
            public LogRotation logRotation() {
                return logRotation;
            }

            @Override
            public CheckPointer checkPointing() {
                return checkPointer;
            }

            @Override
            public TransactionAppender transactionAppender() {
                return appender;
            }

            @Override
            public IdOrderingQueue legacyIndexTransactionOrderingQueue() {
                return legacyIndexTransactionOrdering;
            }
        };
    }

    private Supplier<LabelScanWriter> alwaysCreateNewWriter(LabelScanStore labelScanStore) {
        return labelScanStore::newWriter;
    }

    private void buildRecovery(FileSystemAbstraction fileSystemAbstraction, IndexingService indexingService, LabelScanStore labelScanStore, NeoStores neoStores, RecoveryVisitor.Monitor recoveryVisitorMonitor, Recovery.Monitor recoveryMonitor, PhysicalLogFiles logFiles, StoreFlusher storeFlusher, final StartupStatisticsProvider startupStatistics, LegacyIndexApplierLookup legacyIndexApplierLookup, StorageEngine storageEngine) {
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        RecoveryLabelScanWriterProvider labelScanWriters = new RecoveryLabelScanWriterProvider(labelScanStore, 1000);
        RecoveryLegacyIndexApplierLookup recoveryLegacyIndexApplierLookup = new RecoveryLegacyIndexApplierLookup(legacyIndexApplierLookup, 1000);
        RecoveryIndexingUpdatesValidator indexUpdatesValidator = new RecoveryIndexingUpdatesValidator(indexingService);
        TransactionRepresentationStoreApplier storeRecoverer = new TransactionRepresentationStoreApplier(labelScanWriters, this.lockService, storageEngine.indexConfigStore(), IdOrderingQueue.BYPASS, storageEngine);
        RecoveryVisitor recoveryVisitor = new RecoveryVisitor(metaDataStore, storeRecoverer, indexUpdatesValidator, recoveryVisitorMonitor);
        VersionAwareLogEntryReader<ReadableLogChannel> logEntryReader = new VersionAwareLogEntryReader<ReadableLogChannel>();
        LogFileRecoverer logFileRecoverer = new LogFileRecoverer(logEntryReader, recoveryVisitor);
        LatestCheckPointFinder checkPointFinder = new LatestCheckPointFinder(logFiles, fileSystemAbstraction, logEntryReader);
        DefaultRecoverySPI spi = new DefaultRecoverySPI(labelScanWriters, recoveryLegacyIndexApplierLookup, storeFlusher, neoStores, logFileRecoverer, logFiles, fileSystemAbstraction, metaDataStore, checkPointFinder, indexUpdatesValidator);
        Recovery recovery = new Recovery(spi, recoveryMonitor);
        this.life.add(recovery);
        this.life.add(new LifecycleAdapter(){

            @Override
            public void init() throws Throwable {
                startupStatistics.setNumberOfRecoveredTransactions(NeoStoreDataSource.this.recoveredCount.get());
                NeoStoreDataSource.this.recoveredCount.set(0);
            }
        });
    }

    private KernelModule buildKernel(TransactionAppender appender, NeoStores neoStores, TransactionRepresentationStoreApplier storeApplier, IndexingService indexingService, IndexUpdatesValidator indexUpdatesValidator, StoreReadLayer storeLayer, UpdateableSchemaState updateableSchemaState, LabelScanStore labelScanStore, StorageEngine storageEngine) {
        final TransactionCommitProcess transactionCommitProcess = this.commitProcessFactory.create(appender, storeApplier, indexUpdatesValidator, this.config);
        Supplier<KernelAPI> kernelProvider = new Supplier<KernelAPI>(){

            @Override
            public KernelAPI get() {
                return NeoStoreDataSource.this.kernelModule.kernelAPI();
            }
        };
        ConstraintIndexCreator constraintIndexCreator = new ConstraintIndexCreator(kernelProvider, indexingService);
        LegacyIndexStore legacyIndexStore = new LegacyIndexStore(this.config, storageEngine.indexConfigStore(), kernelProvider, this.legacyIndexProviderLookup);
        LegacyPropertyTrackers legacyPropertyTrackers = new LegacyPropertyTrackers(this.propertyKeyTokenHolder, this.nodeManager.getNodePropertyTrackers(), this.nodeManager.getRelationshipPropertyTrackers(), this.nodeManager);
        NeoStoreTransactionContextFactory neoStoreTxContextFactory = new NeoStoreTransactionContextFactory(neoStores);
        StatementOperationParts statementOperations = this.dependencies.satisfyDependency(this.buildStatementOperations(storeLayer, legacyPropertyTrackers, constraintIndexCreator, updateableSchemaState, this.guard, legacyIndexStore));
        TransactionHooks hooks = new TransactionHooks();
        final KernelTransactions kernelTransactions = this.life.add(new KernelTransactions(neoStoreTxContextFactory, this.locks, constraintIndexCreator, statementOperations, updateableSchemaState, this.schemaWriteGuard, this.transactionHeaderInformationFactory, transactionCommitProcess, storageEngine.indexConfigStore(), this.legacyIndexProviderLookup, hooks, this.constraintSemantics, this.transactionMonitor, this.life, this.tracers, storageEngine));
        final Kernel kernel = new Kernel(kernelTransactions, hooks, this.kernelHealth, this.transactionMonitor);
        kernel.registerTransactionHook(this.transactionEventHandlers);
        final NeoStoreFileListing fileListing = new NeoStoreFileListing(this.storeDir, labelScanStore, indexingService, this.legacyIndexProviderLookup);
        return new KernelModule(){

            @Override
            public TransactionCommitProcess transactionCommitProcess() {
                return transactionCommitProcess;
            }

            @Override
            public KernelAPI kernelAPI() {
                return kernel;
            }

            @Override
            public KernelTransactions kernelTransactions() {
                return kernelTransactions;
            }

            @Override
            public NeoStoreFileListing fileListing() {
                return fileListing;
            }
        };
    }

    private void satisfyDependencies(Object ... modules) {
        for (Object module : modules) {
            for (Method method : module.getClass().getMethods()) {
                if (method.getDeclaringClass().equals(Object.class) || method.getReturnType() == Void.TYPE) continue;
                try {
                    this.dependencies.satisfyDependency(method.invoke(module, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public NeoStores getNeoStores() {
        return this.storageEngine.neoStores();
    }

    public IndexingService getIndexService() {
        return this.storageEngine.indexingService();
    }

    public LabelScanStore getLabelScanStore() {
        return this.storageEngine.labelScanStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (!this.life.isRunning()) {
            return;
        }
        StoreFlusher storeFlusher = this.transactionLogModule.storeFlusher();
        CheckPointer checkPointer = this.transactionLogModule.checkPointing();
        this.awaitAllTransactionsClosed();
        LogFile logFile = this.transactionLogModule.logFile();
        this.life.stop();
        LogFile logFile2 = logFile;
        synchronized (logFile2) {
            this.awaitAllTransactionsClosed();
            storeFlusher.forceEverything();
            if (this.kernelHealth.isHealthy()) {
                try {
                    checkPointer.forceCheckPoint(new SimpleTriggerInfo("database shutdown"));
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException(e);
                }
            }
            this.life.shutdown();
            this.storageEngine.neoStores().close();
            this.msgLog.info("NeoStores closed");
        }
    }

    private void awaitAllTransactionsClosed() {
        while (!this.storageEngine.neoStores().getMetaDataStore().closedTransactionIdIsOnParWithOpenedTransactionId()) {
            LockSupport.parkNanos(10000000L);
        }
    }

    @Override
    public void shutdown() {
    }

    public StoreId getStoreId() {
        return this.getNeoStores().getMetaDataStore().getStoreId();
    }

    public File getStoreDir() {
        return this.storeDir;
    }

    public long getCreationTime() {
        return this.getNeoStores().getMetaDataStore().getCreationTime();
    }

    public long getRandomIdentifier() {
        return this.getNeoStores().getMetaDataStore().getRandomNumber();
    }

    public long getCurrentLogVersion() {
        return this.getNeoStores().getMetaDataStore().getCurrentLogVersion();
    }

    public long getLastCommittedTransactionId() {
        return this.getNeoStores().getMetaDataStore().getLastCommittedTransactionId();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public KernelAPI getKernel() {
        return this.kernelModule.kernelAPI();
    }

    public ResourceIterator<File> listStoreFiles(boolean includeLogs) throws IOException {
        return this.kernelModule.fileListing().listStoreFiles(includeLogs);
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        manager.registerAll(Diagnostics.class, this);
    }

    public NeoStores get() {
        return this.storageEngine.neoStores();
    }

    public StoreReadLayer getStoreLayer() {
        return this.storageEngine.storeReadLayer();
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencies;
    }

    private StatementOperationParts buildStatementOperations(StoreReadLayer storeReadLayer, LegacyPropertyTrackers legacyPropertyTrackers, ConstraintIndexCreator constraintIndexCreator, UpdateableSchemaState updateableSchemaState, Guard guard, LegacyIndexStore legacyIndexStore) {
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(storeReadLayer, legacyPropertyTrackers, constraintIndexCreator, legacyIndexStore);
        StatementOperationParts parts = new StatementOperationParts(stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(updateableSchemaState), null, stateHandlingContext, stateHandlingContext, stateHandlingContext);
        ConstraintEnforcingEntityOperations constraintEnforcingEntityOperations = new ConstraintEnforcingEntityOperations(this.constraintSemantics, parts.entityWriteOperations(), parts.entityReadOperations(), parts.schemaWriteOperations(), parts.schemaReadOperations());
        DataIntegrityValidatingStatementOperations dataIntegrityContext = new DataIntegrityValidatingStatementOperations(parts.keyWriteOperations(), parts.schemaReadOperations(), constraintEnforcingEntityOperations);
        parts = parts.override(null, dataIntegrityContext, constraintEnforcingEntityOperations, constraintEnforcingEntityOperations, null, dataIntegrityContext, null, null, null, null, null);
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityReadOperations(), parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        parts = parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, lockingContext, null, null, null);
        if (guard != null) {
            GuardingStatementOperations guardingOperations = new GuardingStatementOperations(parts.entityWriteOperations(), parts.entityReadOperations(), guard);
            parts = parts.override(null, null, guardingOperations, guardingOperations, null, null, null, null, null, null, null);
        }
        return parts;
    }

    @Override
    public void registerIndexProvider(String name, IndexImplementation index) {
        assert (!this.indexProviders.containsKey(name)) : "Index provider '" + name + "' already registered";
        this.indexProviders.put(name, index);
    }

    @Override
    public boolean unregisterIndexProvider(String name) {
        IndexImplementation removed = this.indexProviders.remove(name);
        return removed != null;
    }

    public void beforeModeSwitch() {
        this.kernelModule.kernelTransactions().disposeAll();
    }

    public void afterModeSwitch() {
        this.storageEngine.loadSchemaCache();
        this.kernelModule.kernelTransactions().disposeAll();
    }

    public static abstract class Configuration {
        public static final Setting<String> keep_logical_logs = GraphDatabaseSettings.keep_logical_logs;
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
    }

    static enum Diagnostics implements DiagnosticsExtractor<NeoStoreDataSource>
    {
        NEO_STORE_VERSIONS("Store versions:"){

            @Override
            void dump(NeoStoreDataSource source, Logger logger) {
                source.storageEngine.neoStores().logVersions(logger);
            }
        }
        ,
        NEO_STORE_ID_USAGE("Id usage:"){

            @Override
            void dump(NeoStoreDataSource source, Logger logger) {
                source.storageEngine.neoStores().logIdUsage(logger);
            }
        }
        ,
        NEO_STORE_RECORDS("Neostore records:"){

            @Override
            void dump(NeoStoreDataSource source, Logger log) {
                source.storageEngine.neoStores().getMetaDataStore().logRecords(log);
            }
        }
        ,
        TRANSACTION_RANGE("Transaction log:"){

            @Override
            void dump(NeoStoreDataSource source, Logger log) {
                PhysicalLogFiles logFiles = source.getDependencyResolver().resolveDependency(PhysicalLogFiles.class);
                try {
                    long logVersion = logFiles.getLowestLogVersion();
                    while (logFiles.versionExists(logVersion)) {
                        if (logFiles.hasAnyTransaction(logVersion)) {
                            LogHeader header = logFiles.extractHeader(logVersion);
                            long firstTransactionIdInThisLog = header.lastCommittedTxId + 1L;
                            log.log("Oldest transaction " + firstTransactionIdInThisLog + " found in log with version " + logVersion);
                            return;
                        }
                        ++logVersion;
                    }
                    log.log("No transactions found in any log");
                }
                catch (IOException e) {
                    log.log("Error trying to figure out oldest transaction in log");
                }
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(NeoStoreDataSource source, DiagnosticsPhase phase, Logger logger) {
            if (this.applicable(phase)) {
                logger.log(this.message);
                this.dump(source, logger);
            }
        }

        boolean applicable(DiagnosticsPhase phase) {
            return phase.isInitialization() || phase.isExplicitlyRequested();
        }

        abstract void dump(NeoStoreDataSource var1, Logger var2);
    }

    private static interface KernelModule {
        public TransactionCommitProcess transactionCommitProcess();

        public KernelTransactions kernelTransactions();

        public KernelAPI kernelAPI();

        public NeoStoreFileListing fileListing();
    }

    private static interface TransactionLogModule {
        public TransactionRepresentationStoreApplier storeApplier();

        public LogicalTransactionStore logicalTransactionStore();

        public PhysicalLogFiles logFiles();

        public LogFileInformation logFileInformation();

        public LogFile logFile();

        public StoreFlusher storeFlusher();

        public LogRotation logRotation();

        public CheckPointer checkPointing();

        public TransactionAppender transactionAppender();

        public IdOrderingQueue legacyIndexTransactionOrderingQueue();
    }
}

