/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.AccessControlDataProvider;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.TraceableCursorImpl;
import org.neo4j.kernel.impl.newapi.TraceablePropertyCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipCursor;
import org.neo4j.storageengine.api.txstate.EntityState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class DefaultPropertyCursor
extends TraceableCursorImpl<DefaultPropertyCursor>
implements TraceablePropertyCursor {
    final StoragePropertyCursor storeCursor;
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    private Read read;
    private EntityState propertiesState;
    private Iterator<StorageProperty> txStateChangedProperties;
    private StorageProperty txStateValue;
    private boolean addedInTx;
    private PropertySelection selection;
    private IntPredicate securityPredicate;
    private AccessControlDataProvider accessControlDataProvider;
    private BiConsumer<StoragePropertyCursor, PropertySelection> securityPropertyInitializer;

    DefaultPropertyCursor(CursorPool<DefaultPropertyCursor> pool, StoragePropertyCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super(pool);
        this.storeCursor = storeCursor;
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    void initNode(long nodeReference, Reference reference, PropertySelection selection, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        assert (nodeReference != -1L);
        this.init(selection, read);
        this.initializeNodeTransactionState(nodeReference, txStateHolder);
        this.storeCursor.initNodeProperties(reference, this.filterSelectionForTxState(selection));
        this.securityPropertyInitializer = (propertyCursor, propertySelection) -> propertyCursor.initNodeProperties(reference, propertySelection);
        this.securityPredicate = accessModeProvider.getAccessMode().allowedToReadNodeProperties(() -> this.getSelectedPropertiesProvider().getLabels(nodeReference), this::getSelectedPropertiesProvider, selection);
    }

    void initNode(DefaultNodeCursor nodeCursor, PropertySelection selection, Read read, boolean initStoreCursor, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        long nodeReference = nodeCursor.nodeReference();
        assert (nodeReference != -1L);
        this.init(selection, read);
        this.addedInTx = nodeCursor.currentNodeIsAddedInTx();
        this.initializeNodeTransactionState(nodeReference, txStateHolder);
        if (!this.addedInTx || this.applyAccessModeToTxState) {
            if (initStoreCursor) {
                this.storeCursor.initNodeProperties(nodeCursor.storeCursor, this.filterSelectionForTxState(selection));
            }
        } else {
            this.storeCursor.reset();
        }
        this.securityPropertyInitializer = (propertyCursor, propertySelection) -> propertyCursor.initNodeProperties(nodeCursor.storeCursor, propertySelection);
        this.securityPredicate = accessModeProvider.getAccessMode().allowedToReadNodeProperties(() -> this.getSelectedPropertiesProvider().getLabels(nodeReference), this::getSelectedPropertiesProvider, selection);
    }

    private PropertySelection filterSelectionForTxState(PropertySelection selection) {
        return this.propertiesState == null || this.propertiesState == EntityState.EMPTY ? selection : selection.excluding(k -> this.propertiesState.isPropertyChangedOrRemoved(k));
    }

    private void initializeNodeTransactionState(long nodeReference, TxStateHolder txStateHolder) {
        if (txStateHolder.hasTxStateWithChanges()) {
            this.propertiesState = txStateHolder.txState().getNodeState(nodeReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties().iterator();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    void initRelationship(long relationshipReference, int type, Reference reference, PropertySelection selection, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        assert (relationshipReference != -1L);
        this.init(selection, read);
        this.initializeRelationshipTransactionState(relationshipReference, txStateHolder);
        this.storeCursor.initRelationshipProperties(reference, this.filterSelectionForTxState(selection));
        this.securityPropertyInitializer = (propertyCursor, propertySelection) -> propertyCursor.initRelationshipProperties(reference, propertySelection);
        this.securityPredicate = accessModeProvider.getAccessMode().allowedToReadRelationshipProperties(() -> type, this::getSelectedPropertiesProvider, selection);
    }

    void initRelationship(int type, PropertySelection selection, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider, StorageRelationshipCursor storageRelationshipCursor, boolean addedInTransaction, long relationshipReference) {
        assert (relationshipReference != -1L);
        this.init(selection, read);
        this.initializeRelationshipTransactionState(relationshipReference, txStateHolder);
        this.addedInTx = addedInTransaction;
        if (!this.addedInTx || this.applyAccessModeToTxState) {
            this.storeCursor.initRelationshipProperties(storageRelationshipCursor, this.filterSelectionForTxState(selection));
        } else {
            this.storeCursor.reset();
        }
        this.securityPropertyInitializer = (propertyCursor, propertySelection) -> propertyCursor.initRelationshipProperties(storageRelationshipCursor, propertySelection);
        this.securityPredicate = accessModeProvider.getAccessMode().allowedToReadRelationshipProperties(() -> type, this::getSelectedPropertiesProvider, selection);
    }

    private void initializeRelationshipTransactionState(long relationshipReference, TxStateHolder txStateHolder) {
        if (txStateHolder.hasTxStateWithChanges()) {
            this.propertiesState = txStateHolder.txState().getRelationshipState(relationshipReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties().iterator();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    private void init(PropertySelection selection, Read read) {
        this.selection = selection;
        this.read = read;
    }

    private AccessControlDataProvider getSelectedPropertiesProvider() {
        if (this.accessControlDataProvider == null) {
            this.accessControlDataProvider = new AccessControlDataProvider(() -> this.securityPropertyInitializer, this.internalCursors, this.applyAccessModeToTxState, this::txStateProperties, () -> this.read);
        }
        return this.accessControlDataProvider;
    }

    private Iterable<StorageProperty> txStateProperties() {
        return this.propertiesState != null ? this.propertiesState.addedAndChangedProperties() : Iterables.empty();
    }

    public boolean next() {
        int propertyKey;
        if (this.txStateChangedProperties != null) {
            while (this.txStateChangedProperties.hasNext()) {
                this.txStateValue = this.txStateChangedProperties.next();
                propertyKey = this.txStateValue.propertyKeyId();
                if (!this.selection.test(propertyKey) || !this.txStateEntryAllowed(propertyKey)) continue;
                this.trace(propertyKey);
                return true;
            }
            this.txStateChangedProperties = null;
            this.txStateValue = null;
        }
        while (this.storeCursor.next()) {
            propertyKey = this.storeCursor.propertyKey();
            if (!this.allowed(propertyKey)) continue;
            this.trace(propertyKey);
            return true;
        }
        return false;
    }

    protected boolean txStateEntryAllowed(int propertyKey) {
        return !this.applyAccessModeToTxState || this.allowed(propertyKey);
    }

    protected boolean allowed(int propertyKey) {
        return this.securityPredicate.test(propertyKey);
    }

    private void trace(int propertyKey) {
        if (this.tracer != null) {
            this.tracer.onProperty(propertyKey);
        }
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
            this.txStateValue = null;
            this.read = null;
            this.storeCursor.reset();
            if (this.accessControlDataProvider != null) {
                this.accessControlDataProvider.close();
                this.accessControlDataProvider = null;
            }
            this.securityPropertyInitializer = null;
        }
        super.closeInternal();
    }

    public int propertyKey() {
        if (this.txStateValue != null) {
            return this.txStateValue.propertyKeyId();
        }
        return this.storeCursor.propertyKey();
    }

    public ValueGroup propertyType() {
        if (this.txStateValue != null) {
            return this.txStateValue.value().valueGroup();
        }
        return this.storeCursor.propertyType();
    }

    public Value propertyValue() {
        if (this.txStateValue != null) {
            return this.txStateValue.value();
        }
        return this.storeCursor.propertyValue();
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "PropertyCursor[closed state]";
        }
        return "PropertyCursor[id=" + this.propertyKey() + ", " + String.valueOf(this.storeCursor) + " ]";
    }

    @Override
    public void release() {
        if (this.storeCursor != null) {
            this.storeCursor.close();
        }
        if (this.accessControlDataProvider != null) {
            this.accessControlDataProvider.close();
            this.accessControlDataProvider.release();
            this.accessControlDataProvider = null;
        }
        this.securityPropertyInitializer = null;
    }
}

