/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.TokenIndex;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.util.Preconditions;

public class MultiVersionTokenIndexPopulator
implements IndexPopulator {
    private final TokenIndex tokenIndex;
    private final ArrayList<VersionedTokenUpdate> concurrentUpdates;
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;
    private volatile boolean scanCompleted;

    MultiVersionTokenIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexDescriptor descriptor, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        this.tokenIndex = new TokenIndex(databaseIndexContext, indexFiles, descriptor, openOptions, false, indexingBehaviour);
        this.concurrentUpdates = new ArrayList();
    }

    public synchronized void create() {
        this.assertNotDropped();
        this.assertNotClosed();
        this.tokenIndex.indexFiles.clear();
        this.tokenIndex.instantiateTree(RecoveryCleanupWorkCollector.immediate());
        this.tokenIndex.instantiateUpdater();
    }

    public synchronized void drop() {
        try {
            if (this.tokenIndex.index != null) {
                this.tokenIndex.index.setDeleteOnClose(true);
            }
            this.tokenIndex.closeResources();
            this.tokenIndex.indexFiles.clear();
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    public void add(Collection<? extends IndexEntryUpdate> updates, CursorContext cursorContext) throws IndexEntryConflictException {
        try (TokenIndexUpdater updater = this.tokenIndex.singleUpdater.initialize(context -> this.tokenIndex.index.writer(1, context), false, cursorContext);){
            for (IndexEntryUpdate indexEntryUpdate : updates) {
                updater.process(indexEntryUpdate);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexUpdater newPopulatingUpdater(final CursorContext cursorContext) {
        if (this.scanCompleted) {
            try {
                return this.tokenIndex.singleUpdater.initialize(context -> this.tokenIndex.index.writer(1, context), false, cursorContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new IndexUpdater(){

            public void process(IndexEntryUpdate update) {
                MultiVersionTokenIndexPopulator.this.concurrentUpdates.add(new VersionedTokenUpdate((TokenIndexEntryUpdate)update, cursorContext.getVersionContext().committingTransactionId()));
            }

            public void close() {
            }
        };
    }

    public void scanCompleted(PhaseTracker phaseTracker, IndexPopulator.PopulationWorkScheduler populationWorkScheduler, IndexEntryConflictHandler conflictHandler, CursorContext cursorContext) throws IndexEntryConflictException {
        this.scanCompleted = true;
        try (CursorContext localContext = cursorContext.createUnboundedReadRelatedContext("TOKEN_POPULATION");
             TokenIndexUpdater updater = this.tokenIndex.singleUpdater.initialize(context -> this.tokenIndex.index.writer(1, context), false, localContext);){
            for (VersionedTokenUpdate versionedUpdate : this.concurrentUpdates) {
                localContext.getVersionContext().initWrite(versionedUpdate.version());
                updater.process((IndexEntryUpdate)versionedUpdate.update());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        block16: {
            Preconditions.checkState((!populationCompletedSuccessfully || this.failureBytes == null ? 1 : 0) != 0, (String)"Can't mark index as online after it has been marked as failure");
            try {
                this.assertNotDropped();
                AsyncBlockAccessor asyncBlockAccessor = AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR;
                if (populationCompletedSuccessfully) {
                    this.tokenIndex.assertTreeOpen();
                    try (FileFlushEvent flushEvent = this.tokenIndex.pageCacheTracer.beginFileFlush();){
                        this.flushTreeAndMarkAs((byte)0, flushEvent, asyncBlockAccessor, cursorContext);
                        break block16;
                    }
                }
                if (this.failureBytes == null) break block16;
                this.ensureTreeInstantiated();
                try (FileFlushEvent flushEvent = this.tokenIndex.pageCacheTracer.beginFileFlush();){
                    this.markTreeAsFailed(flushEvent, asyncBlockAccessor, cursorContext);
                }
            }
            finally {
                this.tokenIndex.closeResources();
                this.closed = true;
            }
        }
    }

    private void flushTreeAndMarkAs(byte state, FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) {
        this.tokenIndex.index.checkpoint(pageCursor -> pageCursor.putByte(state), flushEvent, asyncBlockAccessor, cursorContext);
    }

    private void markTreeAsFailed(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) {
        Preconditions.checkState((this.failureBytes != null ? 1 : 0) != 0, (String)"markAsFailed hasn't been called, populator not actually failed?");
        this.tokenIndex.index.checkpoint((Consumer)new FailureHeaderWriter(this.failureBytes, 2), flushEvent, asyncBlockAccessor, cursorContext);
    }

    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    public void includeSample(IndexEntryUpdate update) {
    }

    public IndexSample sample(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Token indexes does not support index sampling");
    }

    private void assertNotDropped() {
        Preconditions.checkState((!this.dropped ? 1 : 0) != 0, (String)"Populator has already been dropped.");
    }

    private void assertNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Populator has already been closed.");
    }

    private void ensureTreeInstantiated() {
        if (this.tokenIndex.index == null) {
            this.tokenIndex.instantiateTree(RecoveryCleanupWorkCollector.ignore());
        }
    }

    public ResourceIterator<Path> snapshotFiles() throws IOException {
        return this.tokenIndex.snapshotFiles();
    }

    private record VersionedTokenUpdate(TokenIndexEntryUpdate update, long version) {
    }
}

