/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;

public class MergingBlockEntryReader<KEY, VALUE>
implements BlockEntryCursor<KEY, VALUE> {
    private static final byte STATE_NEED_ADVANCE = 0;
    private static final byte STATE_HAS = 1;
    private static final byte STATE_EXHAUSTED = 2;
    private final Layout<KEY, VALUE> layout;
    private List<Source> sources = new ArrayList<Source>();
    private Source lastReturned;

    MergingBlockEntryReader(Layout<KEY, VALUE> layout) {
        this.layout = layout;
    }

    void addSource(BlockEntryCursor<KEY, VALUE> source) {
        this.sources.add(new Source(this, source));
    }

    @Override
    public boolean next() throws IOException {
        Object lowest = null;
        Source lowestSource = null;
        for (Source source : this.sources) {
            Object candidate = source.tryNext();
            if (candidate == null || lowest != null && this.layout.compare(candidate, lowest) >= 0) continue;
            lowest = candidate;
            lowestSource = source;
        }
        if (lowest != null) {
            this.lastReturned = lowestSource.takeHead();
            return true;
        }
        return false;
    }

    @Override
    public KEY key() {
        return this.lastReturned.cursor.key();
    }

    @Override
    public VALUE value() {
        return this.lastReturned.cursor.value();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll(this.sources);
    }

    private class Source
    implements Closeable {
        private final BlockEntryCursor<KEY, VALUE> cursor;
        private byte state;

        Source(MergingBlockEntryReader mergingBlockEntryReader, BlockEntryCursor<KEY, VALUE> cursor) {
            this.cursor = cursor;
        }

        KEY tryNext() throws IOException {
            if (this.state == 0) {
                if (this.cursor.next()) {
                    this.state = 1;
                    return this.cursor.key();
                }
                this.state = (byte)2;
            } else if (this.state == 1) {
                return this.cursor.key();
            }
            return null;
        }

        Source takeHead() {
            this.state = 0;
            return this;
        }

        @Override
        public void close() throws IOException {
            this.cursor.close();
        }
    }
}

