/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.database.enrichment;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.neo4j.kernel.api.database.enrichment.ValuesReader;
import org.neo4j.storageengine.api.enrichment.WriteEnrichmentChannel;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.VectorValue;
import org.neo4j.values.utils.TemporalUtil;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public record ValuesWriter(WriteEnrichmentChannel channel) implements AnyValueWriter<RuntimeException>
{
    public int write(AnyValue value) {
        int position = this.channel.size();
        if (value == null) {
            this.channel.put(ValuesReader.NO_VALUE.id());
        } else {
            this.channel.put(ValuesReader.forValueClass(value.getClass()).id());
            if (value instanceof ListValue) {
                ListValue list = (ListValue)value;
                this.writeList(list);
            } else if (value instanceof MapValue) {
                MapValue map = (MapValue)value;
                this.writeMap(map);
            } else {
                value.writeTo((AnyValueWriter)this);
            }
        }
        return position;
    }

    public AnyValueWriter.EntityMode entityMode() {
        return AnyValueWriter.EntityMode.FULL;
    }

    public void writeNull() {
    }

    public void writeBoolean(boolean value) {
        this.channel.put((byte)(value ? 1 : 0));
    }

    public void writeInteger(byte value) {
        this.channel.put(value);
    }

    public void writeInteger(short value) {
        this.channel.putShort(value);
    }

    public void writeInteger(int value) {
        this.channel.putInt(value);
    }

    public void writeInteger(long value) {
        this.channel.putLong(value);
    }

    public void writeFloatingPoint(float value) {
        this.channel.putFloat(value);
    }

    public void writeFloatingPoint(double value) {
        this.channel.putDouble(value);
    }

    public void writeString(String value) {
        if (value == null) {
            this.channel.putInt(-1);
        } else {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            this.channel.putInt(bytes.length).put(bytes);
        }
    }

    public void writeString(char value) {
        this.channel.putChar(value);
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) {
        this.channel.putInt(size);
    }

    public void endArray() {
    }

    public void writeByteArray(byte[] value) {
        this.channel.putInt(value.length);
        this.channel.put(value);
    }

    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        Preconditions.checkArgument((coordinate.length == crs.getDimension() ? 1 : 0) != 0, (String)"Dimension for %s is %d, got %d", (Object[])new Object[]{crs.getName(), crs.getDimension(), coordinate.length});
        this.channel.putInt(crs.getCode());
        for (int i = 0; i < crs.getDimension(); ++i) {
            this.channel.putDouble(coordinate[i]);
        }
    }

    public void writeDuration(long months, long days, long seconds, int nanos) {
        this.channel.putLong(months);
        this.channel.putLong(days);
        this.channel.putLong(seconds);
        this.channel.putInt(nanos);
    }

    public void writeDate(LocalDate localDate) {
        this.channel.putLong(localDate.toEpochDay());
    }

    public void writeLocalTime(LocalTime localTime) {
        this.channel.putLong(localTime.toNanoOfDay());
    }

    public void writeTime(OffsetTime offsetTime) {
        this.channel.putLong(TemporalUtil.getNanosOfDayUTC((OffsetTime)offsetTime));
        this.channel.putInt(offsetTime.getOffset().getTotalSeconds());
    }

    public void writeLocalDateTime(LocalDateTime localDateTime) {
        this.channel.putLong(localDateTime.toEpochSecond(ZoneOffset.UTC));
        this.channel.putInt(localDateTime.getNano());
    }

    public void writeDateTime(ZonedDateTime zonedDateTime) {
        this.channel.putLong(zonedDateTime.toEpochSecond());
        this.channel.putInt(zonedDateTime.getNano());
        ZoneId zone = zonedDateTime.getZone();
        if (zone instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)zone;
            int offsetSeconds = zoneOffset.getTotalSeconds();
            this.channel.putInt(offsetSeconds << 1);
        } else {
            int zoneId = TimeZones.map((String)zone.getId()) << 1 | 1;
            this.channel.putInt(zoneId);
        }
    }

    public void writeInt8Vector(byte[] values) throws RuntimeException {
        VectorValue.ensureValidDimensions((int)values.length);
        this.channel.putShort((short)values.length);
        this.channel.put(values);
    }

    public void writeInt16Vector(short[] values) throws RuntimeException {
        VectorValue.ensureValidDimensions((int)values.length);
        this.channel.putShort((short)values.length);
        for (short value : values) {
            this.channel.putShort(value);
        }
    }

    public void writeInt32Vector(int[] values) throws RuntimeException {
        VectorValue.ensureValidDimensions((int)values.length);
        this.channel.putShort((short)values.length);
        for (int value : values) {
            this.channel.putInt(value);
        }
    }

    public void writeInt64Vector(long[] values) throws RuntimeException {
        VectorValue.ensureValidDimensions((int)values.length);
        this.channel.putShort((short)values.length);
        for (long value : values) {
            this.channel.putLong(value);
        }
    }

    public void writeFloat32Vector(float[] values) throws RuntimeException {
        VectorValue.ensureValidDimensions((int)values.length);
        this.channel.putShort((short)values.length);
        for (float value : values) {
            this.channel.putFloat(value);
        }
    }

    public void writeFloat64Vector(double[] values) throws RuntimeException {
        VectorValue.ensureValidDimensions((int)values.length);
        this.channel.putShort((short)values.length);
        for (double value : values) {
            this.channel.putDouble(value);
        }
    }

    public void beginMap(int size) {
        this.channel.putInt(size);
    }

    public void endMap() {
    }

    public void beginList(int size) {
        this.channel.putInt(size);
    }

    public void endList() {
    }

    public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) {
        this.writeBoolean(true);
        this.channel.putInt(nodes.length);
        for (NodeValue nodeValue : nodes) {
            nodeValue.writeTo((AnyValueWriter)this);
        }
        for (NodeValue nodeValue : relationships) {
            nodeValue.writeTo((AnyValueWriter)this);
        }
    }

    public void writeNode(String elementId, long nodeId, TextArray labels, MapValue properties, boolean isDeleted) {
        this.writeBoolean(true);
        this.writeInteger(nodeId);
        this.writeString(elementId);
        this.writeBoolean(isDeleted);
        this.writeInteger(labels.intSize());
        for (int i = 0; i < labels.intSize(); ++i) {
            this.writeString(labels.stringValue(i));
        }
        this.beginMap(properties.size());
        properties.foreach((key, value) -> {
            this.writeString((String)key);
            this.write((AnyValue)value);
        });
        this.endMap();
    }

    public void writeRelationship(String elementId, long relId, String startNodeElementId, long startNodeId, String endNodeElementId, long endNodeId, TextValue type, MapValue properties, boolean isDeleted) throws RuntimeException {
        this.writeBoolean(true);
        this.writeInteger(relId);
        this.writeString(elementId);
        this.writeString(type.stringValue());
        this.writeBoolean(isDeleted);
        this.writeInteger(startNodeId);
        this.writeString(startNodeElementId);
        this.writeInteger(endNodeId);
        this.writeString(endNodeElementId);
        this.beginMap(properties.size());
        properties.foreach((key, value) -> {
            this.writeString((String)key);
            this.write((AnyValue)value);
        });
        this.endMap();
    }

    public void writePathReference(long[] nodes, long[] relationships) {
        this.writeBoolean(false);
        this.channel.putInt(nodes.length);
        for (long node : nodes) {
            this.channel.putLong(node);
        }
        for (long relationship : relationships) {
            this.channel.putLong(relationship);
        }
    }

    public void writePathReference(VirtualNodeValue[] nodes, VirtualRelationshipValue[] relationships) {
        this.writeBoolean(false);
        this.channel.putInt(nodes.length);
        for (VirtualNodeValue virtualNodeValue : nodes) {
            this.channel.putLong(virtualNodeValue.id());
        }
        for (VirtualNodeValue virtualNodeValue : relationships) {
            this.channel.putLong(virtualNodeValue.id());
        }
    }

    public void writePathReference(List<VirtualNodeValue> nodes, List<VirtualRelationshipValue> relationships) throws RuntimeException {
        this.writeBoolean(false);
        this.channel.putInt(nodes.size());
        for (VirtualNodeValue node : nodes) {
            this.channel.putLong(node.id());
        }
        for (VirtualRelationshipValue relationship : relationships) {
            this.channel.putLong(relationship.id());
        }
    }

    public void writeNodeReference(long nodeId) {
        this.writeBoolean(false);
        this.writeInteger(nodeId);
    }

    public void writeRelationshipReference(long relId) {
        this.writeBoolean(false);
        this.writeInteger(relId);
    }

    private void writeList(ListValue list) {
        this.beginList(list.intSize());
        switch (list.iterationPreference()) {
            case RANDOM_ACCESS: {
                int i = 0;
                while ((long)i < list.actualSize()) {
                    this.write(list.value((long)i));
                    ++i;
                }
                break;
            }
            case ITERATION: {
                for (AnyValue value : list) {
                    this.write(value);
                }
                break;
            }
        }
        this.endList();
    }

    private void writeMap(MapValue map) {
        this.beginMap(map.size());
        map.foreach((key, value) -> {
            this.writeString((String)key);
            this.write((AnyValue)value);
        });
        this.endMap();
    }
}

