/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import org.neo4j.logging.internal.DatabaseLogIdentifier;
import org.neo4j.logging.log4j.Neo4jMapMessage;

class DatabaseTagLogMessage
extends Neo4jMapMessage {
    private final String message;
    private final Throwable throwable;

    DatabaseTagLogMessage(DatabaseLogIdentifier databaseLogIdentifier, String message, Throwable throwable) {
        super(databaseLogIdentifier.externalId().map(i -> 3).orElse(2).intValue());
        this.with("databaseName", databaseLogIdentifier.databaseName());
        this.with("databaseId", databaseLogIdentifier.databaseId());
        databaseLogIdentifier.externalId().ifPresent(o -> this.with("externalId", (String)o));
        this.message = databaseLogIdentifier.prefix() + message;
        this.throwable = throwable;
    }

    protected void formatAsString(StringBuilder sb) {
        sb.append(this.message);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

