/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.collection.pool.Pool;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.LocalConfig;
import org.neo4j.cypher.internal.DefaultQueryLanguageScope;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnspecifiedKernelException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedHelper;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.VarHandleUtils;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityLocks;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Upgrade;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.InnerTransactionHandler;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.database.enrichment.TxEnrichmentVisitor;
import org.neo4j.kernel.api.exceptions.ResourceCloseFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.InnerTransactionHandlerImpl;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionResourceFactory;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseException;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.RestrictedSchemaWrite;
import org.neo4j.kernel.impl.api.TransactionClockContext;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionMemoryPool;
import org.neo4j.kernel.impl.api.chunk.ChunkSink;
import org.neo4j.kernel.impl.api.chunk.ChunkedTransactionSink;
import org.neo4j.kernel.impl.api.chunk.TransactionRollbackProcess;
import org.neo4j.kernel.impl.api.commit.ChunkCommitter;
import org.neo4j.kernel.impl.api.commit.DefaultCommitter;
import org.neo4j.kernel.impl.api.commit.TransactionCommitter;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextCursorTracer;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureKernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ParallelAccessCheck;
import org.neo4j.kernel.impl.api.parallel.ThreadExecutionContext;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.transaction.serial.DatabaseSerialGuard;
import org.neo4j.kernel.impl.api.transaction.serial.SerialExecutionGuard;
import org.neo4j.kernel.impl.api.transaction.serial.TransactionSerialExecutionGuard;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProvider;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProviderFactory;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.monitoring.TransactionMonitor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelProcedures;
import org.neo4j.kernel.impl.newapi.KernelRead;
import org.neo4j.kernel.impl.newapi.KernelSchemaRead;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.KernelTokenRead;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.kernel.impl.newapi.TransactionQueryContext;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.TransactionEventListeners;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.HeapEstimatorCacheConfig;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.ExceptionHandlerService;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineCostCharacteristics;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.enrichment.ApplyEnrichmentStrategy;
import org.neo4j.storageengine.api.enrichment.CaptureMode;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommand;
import org.neo4j.storageengine.api.enrichment.EnrichmentMode;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionStateBehaviour;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.storageengine.api.txstate.memory.MultiVersionTxStateMemoryConsumer;
import org.neo4j.storageengine.api.txstate.memory.TxStateMemoryConsumer;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidatorFactory;
import org.neo4j.storageengine.api.txstate.validation.ValidationLockDumper;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder,
ExecutionStatistics,
KernelTransactionResourceFactory {
    private static final long NOT_COMMITTED_TRANSACTION_ID = -1L;
    private static final long NOT_COMMITTED_TRANSACTION_COMMIT_TIME = -1L;
    private static final String TRANSACTION_TAG = "transaction";
    private static final VarHandle CURSOR_CONTEXT_HANDLE = VarHandleUtils.getVarHandle((MethodHandles.Lookup)MethodHandles.lookup(), (String)"cursorContext");
    private final CollectionsFactory collectionsFactory;
    private final TransactionEventListeners transactionEventListeners;
    private final ConstraintIndexCreator constraintIndexCreator;
    protected final StorageEngine storageEngine;
    private final TransactionTracer transactionTracer;
    private final Pool<KernelTransactionImplementation> pool;
    private final TransactionCommitProcess commitProcess;
    private final TransactionRollbackProcess rollbackProcess;
    private final TransactionMonitor transactionMonitor;
    private final TransactionExecutionMonitor transactionExecutionMonitor;
    private final LeaseService leaseService;
    private final StorageReader storageReader;
    private final CommandCreationContext commandCreationContext;
    private final KernelVersionProvider kernelVersionProvider;
    private final ServerIdentity serverIdentity;
    private final NamedDatabaseId namedDatabaseId;
    private final TransactionClockContext clocks;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final ConstraintSemantics constraintSemantics;
    private final TransactionMemoryPool transactionMemoryPool;
    private final LogProvider logProvider;
    private final CursorContextFactory contextFactory;
    private final EntityLocks entityLocks;
    private final KernelProcedures.ForTransactionScope procedures;
    private final SchemaRead schemaRead;
    private final KernelRead kernelRead;
    private CursorContext cursorContext;
    private final DatabaseReadOnlyChecker readOnlyDatabaseChecker;
    private final TransactionIdGenerator transactionIdGenerator;
    private final ApplyEnrichmentStrategy enrichmentStrategy;
    private final TransactionStateBehaviour transactionStateBehaviour;
    private final DatabaseHealth databaseHealth;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private TxState txState;
    private volatile TransactionWriteState writeState;
    protected AccessCapability accessCapability;
    private final KernelStatement currentStatement;
    private OverridableSecurityContext overridableSecurityContext;
    private final LockManager.Client lockClient;
    private volatile long transactionSequenceNumber;
    private LeaseClient leaseClient;
    private volatile boolean closing;
    private volatile boolean closed;
    private boolean commit;
    private volatile TerminationMark terminationMark;
    private long startTimeMillis;
    private volatile long startTimeNanos;
    private volatile TransactionTimeout timeout;
    private long lastTransactionIdWhenStarted;
    private final Statistics statistics;
    private TransactionEvent transactionEvent;
    private KernelTransaction.Type type;
    private volatile long transactionId;
    private volatile long commitTime;
    private volatile ClientConnectionInfo clientInfo;
    private volatile Map<String, Object> userMetaData;
    private volatile String statusDetails;
    private final QueryContext queryContext;
    protected final Operations operations;
    private InternalTransaction internalTransaction;
    private volatile TraceProvider traceProvider;
    private volatile TransactionInitializationTrace initializationTrace;
    private final MemoryTracker memoryTracker;
    protected final LocalConfig config;
    private volatile long transactionHeapBytesLimit;
    private volatile long transactionLocalRetries;
    private final ExecutionContextFactory executionContextFactory;
    private ProcedureView procedureView;
    private boolean needsHighIdTracking;
    private final DefaultQueryLanguageScope defaultQueryLanguageScope = DefaultQueryLanguageScope.create();
    private final Lock terminationReleaseLock = new ReentrantLock();
    private KernelTransaction.Monitor monitor;
    private final ExceptionHandlerService exceptionHandlerService;
    private final StoreCursors transactionalCursors;
    private final AvailabilityGuard availabilityGuard;
    private final KernelTransactions kernelTransactions;
    private volatile InnerTransactionHandlerImpl innerTransactionHandler;
    private final TransactionValidator transactionValidator;
    private final ValidationLockDumper validationLockDumper;
    private final TransactionCommitter committer;
    private final ChunkedTransactionSink txStateWriter;
    private final DatabaseSerialGuard databaseSerialGuard;
    private final SerialExecutionGuard serialExecutionGuard;
    private final TxStateMemoryConsumer txStateMemoryConsumer;
    private boolean failedCleanup = false;

    public KernelTransactionImplementation(Config externalConfig, DatabaseTransactionEventListeners transactionEventListeners, ConstraintIndexCreator constraintIndexCreator, TransactionCommitProcess commitProcess, TransactionRollbackProcess rollbackProcess, TransactionMonitor transactionMonitor, Pool<KernelTransactionImplementation> pool, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, DatabaseTracers tracers, StorageEngine storageEngine, AccessCapabilityFactory accessCapabilityFactory, CursorContextFactory contextFactory, CollectionsFactory collectionsFactory, ConstraintSemantics constraintSemantics, SchemaState schemaState, TokenHolders tokenHolders, ElementIdMapper elementIdMapper, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, Dependencies dependencies, NamedDatabaseId namedDatabaseId, LeaseService leaseService, ScopedMemoryPool dbTransactionsPool, DatabaseReadOnlyChecker readOnlyDatabaseChecker, TransactionExecutionMonitor transactionExecutionMonitor, AbstractSecurityLog securityLog, LockManager lockManager, TransactionCommitmentFactory commitmentFactory, KernelTransactions kernelTransactions, TransactionIdGenerator transactionIdGenerator, DbmsRuntimeVersionProvider dbmsRuntimeVersionProvider, KernelVersionProvider kernelVersionProvider, ServerIdentity serverIdentity, ApplyEnrichmentStrategy enrichmentStrategy, TransactionStateBehaviour transactionStateBehaviour, DatabaseHealth databaseHealth, LogProvider logProvider, TransactionValidatorFactory transactionValidatorFactory, DatabaseSerialGuard databaseSerialGuard, boolean multiVersioned, ExceptionHandlerService exceptionHandlerService, TopologyGraphDbmsModel.HostedOnMode mode, AvailabilityGuard availabilityGuard) {
        this.logProvider = logProvider;
        this.exceptionHandlerService = exceptionHandlerService;
        this.availabilityGuard = availabilityGuard;
        this.closed = true;
        this.timeout = TransactionTimeout.NO_TIMEOUT;
        this.config = new LocalConfig(externalConfig);
        this.accessCapabilityFactory = accessCapabilityFactory;
        this.contextFactory = contextFactory;
        this.cursorContext = CursorContext.NULL_CONTEXT;
        this.readOnlyDatabaseChecker = readOnlyDatabaseChecker;
        this.transactionIdGenerator = transactionIdGenerator;
        this.databaseHealth = databaseHealth;
        this.transactionMemoryPool = new TransactionMemoryPool(dbTransactionsPool, (Config)this.config, () -> !this.closed, logProvider);
        this.memoryTracker = this.transactionMemoryPool.getTransactionTracker();
        this.constraintIndexCreator = constraintIndexCreator;
        this.commitProcess = commitProcess;
        this.rollbackProcess = rollbackProcess;
        this.transactionMonitor = transactionMonitor;
        this.transactionExecutionMonitor = transactionExecutionMonitor;
        this.storageReader = storageEngine.newReader();
        this.commandCreationContext = storageEngine.newCommandCreationContext(multiVersioned);
        this.kernelVersionProvider = kernelVersionProvider;
        this.serverIdentity = serverIdentity;
        this.enrichmentStrategy = enrichmentStrategy;
        this.transactionStateBehaviour = transactionStateBehaviour;
        this.namedDatabaseId = namedDatabaseId;
        this.storageEngine = storageEngine;
        this.pool = pool;
        this.clocks = new TransactionClockContext(clock);
        this.transactionTracer = tracers.getDatabaseTracer();
        this.leaseService = leaseService;
        this.currentStatement = new KernelStatement(this, tracers.getLockTracer(), this.clocks, cpuClockRef, namedDatabaseId, (Config)this.config);
        this.statistics = new Statistics(this, cpuClockRef, (Boolean)this.config.get(GraphDatabaseInternalSettings.enable_transaction_heap_allocation_tracking));
        this.userMetaData = Collections.emptyMap();
        this.statusDetails = "";
        this.constraintSemantics = constraintSemantics;
        this.transactionalCursors = storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);
        this.lockClient = ParallelAccessCheck.maybeWrapLockClient(lockManager.newClient());
        StorageLocks storageLocks = storageEngine.createStorageLocks((ResourceLocker)this.lockClient);
        KernelToken kernelToken = new KernelToken(this.storageReader, this.commandCreationContext, this, tokenHolders, logProvider);
        DefaultPooledCursors cursorFactory = this.createCursors(this.storageReader, this.transactionalCursors, (Config)this.config, storageEngine.indexingBehaviour(), multiVersioned, false);
        this.securityAuthorizationHandler = new SecurityAuthorizationHandler(securityLog);
        KernelTransactionImplementation txStateHolder = this;
        this.queryContext = new TransactionQueryContext(this::dataRead, cursorFactory, txStateHolder, this::cursorContext, this.memoryTracker, indexingService.getMonitor());
        AssertOpen assertOpen = this::assertOpenWithParallelAccessCheck;
        this.entityLocks = new EntityLocks(storageLocks, this.currentStatement::lockTracer, this.lockClient, assertOpen);
        this.procedures = this.createProcedures(this, dependencies, assertOpen);
        AccessModeProvider accessModeProvider = () -> this.securityContext().mode();
        this.schemaRead = this.createSchemaRead(schemaState, indexStatisticsStore, this.storageReader, this.entityLocks, txStateHolder, indexingService, assertOpen, accessModeProvider, false);
        this.kernelRead = this.createKernelRead(this.storageReader, kernelToken, cursorFactory, this.transactionalCursors, this.entityLocks, this.queryContext, txStateHolder, this.schemaRead, indexingService, this.memoryTracker, multiVersioned, assertOpen, accessModeProvider, false, logProvider);
        this.executionContextFactory = this.createExecutionContextFactory(storageEngine, (Config)this.config, lockManager, tokenHolders, schemaState, indexingService, indexStatisticsStore, tracers, leaseService, dependencies, this.securityAuthorizationHandler, elementIdMapper, multiVersioned, logProvider);
        this.operations = new Operations(this.kernelRead, this.storageReader, new IndexTxStateUpdater(this.storageReader, indexingService, txStateHolder, transactionStateBehaviour), this.commandCreationContext, dbmsRuntimeVersionProvider, kernelVersionProvider, storageLocks, this, this.schemaRead, kernelToken, cursorFactory, constraintIndexCreator, constraintSemantics, indexingService, (Config)this.config, this.memoryTracker, accessModeProvider, transactionStateBehaviour);
        this.traceProvider = TraceProviderFactory.getTraceProvider((Config)this.config);
        this.initializationTrace = TransactionInitializationTrace.NONE;
        this.transactionHeapBytesLimit = (Long)this.config.get(GraphDatabaseSettings.memory_transaction_max_size);
        this.collectionsFactory = collectionsFactory;
        this.kernelTransactions = kernelTransactions;
        this.databaseSerialGuard = databaseSerialGuard;
        this.transactionValidator = transactionValidatorFactory.createTransactionValidator(this.memoryTracker, transactionMonitor);
        this.validationLockDumper = transactionValidatorFactory.createValidationLockDumper();
        this.serialExecutionGuard = this.createSerialGuard(multiVersioned);
        this.committer = this.createCommitter(commitmentFactory, multiVersioned, mode);
        this.transactionEventListeners = new TransactionEventListeners(transactionEventListeners, this, this.storageReader);
        this.txStateWriter = this.createChunkWriter(multiVersioned);
        this.txStateMemoryConsumer = this.createMemoryConsumer(multiVersioned, this.config);
        this.registerConfigChangeListeners(this.config);
    }

    @Override
    public KernelProcedures.ForTransactionScope createProcedures(KernelTransactionImplementation ktx, Dependencies databaseDependencies, AssertOpen assertOpen) {
        return new KernelProcedures.ForTransactionScope(ktx, databaseDependencies, assertOpen);
    }

    @Override
    public DefaultPooledCursors createCursors(StorageReader storageReader, StoreCursors transactionalCursors, Config config, StorageEngineIndexingBehaviour indexingBehaviour, boolean multiVersioned, boolean parallel) {
        return new DefaultPooledCursors(storageReader, transactionalCursors, config, indexingBehaviour, multiVersioned);
    }

    @Override
    public SchemaRead createSchemaRead(SchemaState schemaState, IndexStatisticsStore indexStatisticsStore, StorageReader storageReader, EntityLocks entityLocks, TxStateHolder txStateHolder, IndexingService indexingService, AssertOpen assertOpen, AccessModeProvider accessModeProvider, boolean parallel) {
        return new KernelSchemaRead(schemaState, indexStatisticsStore, storageReader, (Locks)entityLocks, txStateHolder, indexingService, assertOpen, accessModeProvider);
    }

    @Override
    public KernelRead createKernelRead(StorageReader storageReader, TokenRead tokenRead, CursorFactory cursorFactory, StoreCursors storeCursors, EntityLocks entityLocks, QueryContext queryContext, TxStateHolder txStateHolder, SchemaRead schemaRead, IndexingService indexingService, MemoryTracker memoryTracker, boolean multiVersioned, AssertOpen assertOpen, AccessModeProvider accessModeProvider, boolean parallel, LogProvider logProvider) {
        return new KernelRead(storageReader, tokenRead, cursorFactory, storeCursors, (Locks)entityLocks, queryContext, txStateHolder, schemaRead, indexingService, memoryTracker, multiVersioned, assertOpen, accessModeProvider, parallel, logProvider);
    }

    @Override
    public KernelProcedures.ForThreadExecutionContextScope createProcedures(ExecutionContext executionContext, DependencyResolver databaseDependencies, OverridableSecurityContext overridableSecurityContext, ExecutionContextProcedureKernelTransaction kernelTransaction, SecurityAuthorizationHandler securityAuthorizationHandler, Supplier<ClockContext> clockContextSupplier, ProcedureView procedureView) {
        return new KernelProcedures.ForThreadExecutionContextScope(executionContext, databaseDependencies, overridableSecurityContext, kernelTransaction, securityAuthorizationHandler, clockContextSupplier, procedureView);
    }

    @Override
    public ExecutionContext createExecutionContext(StorageEngine storageEngine, CursorContext context, OverridableSecurityContext overridableSecurityContext, ExecutionContextCursorTracer cursorTracer, CursorContext ktxContext, TokenRead tokenRead, IndexMonitor monitor, MemoryTracker contextTracker, SecurityAuthorizationHandler securityAuthorizationHandler, StorageReader storageReader, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, Dependencies databaseDependencies, LockManager.Client lockClient, LockTracer lockTracer, ElementIdMapper elementIdMapper, KernelTransaction ktx, Supplier<ClockContext> clockContextSupplier, List<AutoCloseable> otherResources, ProcedureView procedureView, boolean multiVersioned, LogProvider logProvider, Config config) {
        return new ThreadExecutionContext(storageEngine, context, overridableSecurityContext, cursorTracer, ktxContext, tokenRead, monitor, contextTracker, securityAuthorizationHandler, storageReader, schemaState, indexingService, indexStatisticsStore, databaseDependencies, lockClient, lockTracer, elementIdMapper, ktx, clockContextSupplier, otherResources, procedureView, multiVersioned, logProvider, this, config);
    }

    private void assertOpenWithParallelAccessCheck() {
        if (ParallelAccessCheck.shouldPerformCheck()) {
            ParallelAccessCheck.checkNotCypherWorkerThread();
        }
        this.assertOpen();
    }

    public KernelTransactionImplementation initialize(long lastCommittedTx, KernelTransaction.Type type, SecurityContext frozenSecurityContext, TransactionTimeout transactionTimeout, long transactionSequenceNumber, ClientConnectionInfo clientInfo, ProcedureView procedureView) {
        assert (this.transactionMemoryPool.usedHeap() == 0L);
        assert (this.transactionMemoryPool.usedNative() == 0L);
        assert (!this.failedCleanup) : "This transaction should not be reused since it did not close properly";
        CURSOR_CONTEXT_HANDLE.setRelease(this, this.contextFactory.create(TRANSACTION_TAG));
        this.transactionalCursors.reset(this.cursorContext);
        this.accessCapability = this.accessCapabilityFactory.newAccessCapability(this.readOnlyDatabaseChecker);
        this.monitor = KernelTransaction.NO_MONITOR;
        this.type = type;
        this.leaseClient = this.leaseService.newClient();
        this.lockClient.initialize(this.leaseClient, transactionSequenceNumber, this.memoryTracker, (Config)this.config);
        this.terminationMark = null;
        this.commit = false;
        this.writeState = TransactionWriteState.NONE;
        this.startTimeMillis = this.clocks.systemClock().millis();
        this.startTimeNanos = this.clocks.systemClock().nanos();
        this.timeout = transactionTimeout;
        this.lastTransactionIdWhenStarted = lastCommittedTx;
        this.transactionEvent = this.transactionTracer.beginTransaction(this.cursorContext, transactionSequenceNumber);
        this.overridableSecurityContext = new OverridableSecurityContext(frozenSecurityContext);
        this.transactionId = -1L;
        this.commitTime = -1L;
        this.clientInfo = clientInfo;
        this.statistics.init(Thread.currentThread().threadId());
        this.commandCreationContext.initialize(this.kernelVersionProvider, this.cursorContext, this.transactionalCursors, this.kernelTransactions::startTimeOfOldestExecutingTransaction, (ResourceLocker)this.lockClient, this.currentStatement::lockTracer);
        this.currentStatement.initialize(this.lockClient, this.cursorContext, this.startTimeMillis);
        this.operations.initialize(this.cursorContext);
        this.initializationTrace = this.traceProvider.getTraceInfo();
        this.transactionMemoryPool.setLimit(this.transactionHeapBytesLimit);
        this.txStateMemoryConsumer.initialize();
        this.innerTransactionHandler = new InnerTransactionHandlerImpl(this.kernelTransactions);
        this.procedureView = procedureView;
        this.procedures.initialize(procedureView);
        this.needsHighIdTracking = false;
        this.transactionSequenceNumber = transactionSequenceNumber;
        this.closing = false;
        this.closed = false;
        return this;
    }

    private ExecutionContextFactory createExecutionContextFactory(StorageEngine storageEngine, Config config, LockManager lockManager, TokenHolders tokenHolders, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, DatabaseTracers tracers, LeaseService leaseService, Dependencies dependencies, SecurityAuthorizationHandler securityAuthorizationHandler, ElementIdMapper elementIdMapper, boolean multiVersioned, LogProvider logProvider) {
        return (securityContext, transactionId, transactionCursorContext, clockContextSupplier, kernelTransaction, procedureView, heapEstimatorCacheConfig) -> {
            ExecutionContextCursorTracer executionContextCursorTracer = new ExecutionContextCursorTracer(PageCacheTracer.NULL, "transactionExecution");
            CursorContext executionContextCursorContext = this.contextFactory.create((PageCursorTracer)executionContextCursorTracer);
            StorageReader executionContextStorageReader = storageEngine.newReader();
            MemoryTracker executionContextMemoryTracker = kernelTransaction.createExecutionContextMemoryTracker(heapEstimatorCacheConfig);
            LockManager.Client executionContextLockClient = lockManager.newClient();
            executionContextLockClient.initialize(leaseService.newClient(), transactionId, executionContextMemoryTracker, config);
            OverridableSecurityContext overridableSecurityContext = new OverridableSecurityContext(securityContext);
            KernelTokenRead.ForThreadExecutionContextScope executionContextTokenRead = new KernelTokenRead.ForThreadExecutionContextScope(executionContextStorageReader, tokenHolders, overridableSecurityContext, (AssertOpen)kernelTransaction);
            return this.createExecutionContext(storageEngine, executionContextCursorContext, overridableSecurityContext, executionContextCursorTracer, transactionCursorContext, executionContextTokenRead, indexingService.getMonitor(), executionContextMemoryTracker, securityAuthorizationHandler, executionContextStorageReader, schemaState, indexingService, indexStatisticsStore, dependencies, executionContextLockClient, tracers.getLockTracer(), elementIdMapper, kernelTransaction, clockContextSupplier, List.of(executionContextStorageReader, executionContextLockClient), procedureView, multiVersioned, logProvider, config);
        };
    }

    public void bindToUserTransaction(InternalTransaction internalTransaction) {
        this.internalTransaction = internalTransaction;
    }

    public InternalTransaction internalTransaction() {
        return this.internalTransaction;
    }

    public long startTime() {
        return this.startTimeMillis;
    }

    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    public TransactionTimeout timeout() {
        return this.timeout;
    }

    public Optional<TerminationMark> getTerminationMark() {
        return Optional.ofNullable(this.terminationMark);
    }

    private boolean canCommit() {
        return this.commit && this.terminationMark == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markForTermination(long expectedTransactionSequenceNumber, Status reason) {
        this.terminationReleaseLock.lock();
        try {
            boolean bl = expectedTransactionSequenceNumber == this.transactionSequenceNumber && this.markForTerminationIfPossible(reason);
            return bl;
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    public void markForTermination(Status reason) {
        this.terminationReleaseLock.lock();
        try {
            this.markForTerminationIfPossible(reason);
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    public boolean isSchemaTransaction() {
        return TransactionWriteState.SCHEMA == this.writeState;
    }

    public boolean isDataTransaction() {
        return TransactionWriteState.DATA == this.writeState;
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public CursorContext concurrentCursorContextLookup() {
        return CURSOR_CONTEXT_HANDLE.getAcquire(this);
    }

    public ExecutionContext createExecutionContext(HeapEstimatorCacheConfig heapEstimatorCacheConfig) {
        if (this.hasTxStateWithChanges()) {
            throw new IllegalStateException("Execution context cannot be used for transactions with non-empty transaction state");
        }
        if (this.clocks.statementClock() == null) {
            throw new IllegalStateException("Execution context must be created when there is an active statement");
        }
        ExecutionContextClock statementClock = new ExecutionContextClock((Clock)this.clocks.systemClock(), this.clocks.transactionClock(), this.clocks.statementClock());
        return this.executionContextFactory.createNew(this.overridableSecurityContext.originalSecurityContext(), this.transactionSequenceNumber, this.cursorContext, () -> statementClock, this, this.procedureView, heapEstimatorCacheConfig);
    }

    public MemoryTracker createExecutionContextMemoryTracker(HeapEstimatorCacheConfig heapEstimatorCacheConfig) {
        Long grabSize = (Long)this.config.get(GraphDatabaseInternalSettings.initial_transaction_heap_grab_size_per_worker);
        Long maxGrabSize = (Long)this.config.get(GraphDatabaseInternalSettings.max_transaction_heap_grab_size_per_worker);
        return this.transactionMemoryPool.getExecutionContextPoolMemoryTracker(grabSize, maxGrabSize, heapEstimatorCacheConfig);
    }

    public QueryContext queryContext() {
        return this.queryContext;
    }

    public StoreCursors storeCursors() {
        return this.transactionalCursors;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    private boolean markForTerminationIfPossible(Status reason) {
        if (this.canBeTerminated()) {
            InnerTransactionHandlerImpl innerTransactionHandler = this.innerTransactionHandler;
            if (innerTransactionHandler != null) {
                innerTransactionHandler.terminateInnerTransactions(reason);
            }
            this.terminationMark = new TerminationMark(reason, this.clocks.systemClock().nanos());
            if (this.lockClient != null) {
                this.lockClient.stop();
            }
            this.transactionMonitor.transactionTerminated(this.hasTxState());
            InternalTransaction internalTransaction = this.internalTransaction;
            if (internalTransaction != null) {
                internalTransaction.terminate(reason);
            }
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    public boolean isCommitting() {
        return this.closing && this.commit;
    }

    public boolean isRollingback() {
        return this.closing && !this.commit;
    }

    public SecurityAuthorizationHandler securityAuthorizationHandler() {
        return this.securityAuthorizationHandler;
    }

    public SecurityContext securityContext() {
        if (!this.closing) {
            this.assertTransactionOpen();
        }
        return this.overridableSecurityContext.currentSecurityContext();
    }

    public AuthSubject subjectOrAnonymous() {
        OverridableSecurityContext ctx = this.overridableSecurityContext;
        if (ctx == null) {
            return AuthSubject.ANONYMOUS;
        }
        return ctx.currentSecurityContext().subject();
    }

    public void setMetaData(Map<String, Object> data) {
        this.assertOpen();
        this.userMetaData = data;
    }

    public Map<String, Object> getMetaData() {
        return this.userMetaData;
    }

    public void setStatusDetails(String statusDetails) {
        this.assertOpen();
        this.statusDetails = statusDetails;
    }

    public String statusDetails() {
        String details = this.statusDetails;
        return Objects.toString(details, "");
    }

    public KernelStatement acquireStatement() {
        this.assertOpen();
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public int aquireStatementCounter() {
        return this.currentStatement.aquireCounter();
    }

    public ResourceMonitor resourceMonitor() {
        assert (this.currentStatement.isAcquired());
        return this.currentStatement;
    }

    public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) {
        return this.operations.indexUniqueCreate(prototype);
    }

    public long pageHits() {
        return this.cursorContext.getCursorTracer().hits();
    }

    public long pageFaults() {
        return this.cursorContext.getCursorTracer().faults();
    }

    Optional<ExecutingQuery> executingQuery() {
        return this.currentStatement.executingQuery();
    }

    private void upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToDataWrites();
    }

    protected void upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToSchemaWrites();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        Iterator createdIndexIds = this.txState().constraintIndexesCreatedInTx();
        while (createdIndexIds.hasNext()) {
            IndexDescriptor createdIndex = (IndexDescriptor)createdIndexIds.next();
            this.constraintIndexCreator.dropUniquenessConstraintIndex(createdIndex);
        }
    }

    public TransactionState txState() {
        if (this.txState == null) {
            this.leaseClient.ensureValid();
            this.readOnlyDatabaseChecker.check();
            this.transactionMonitor.upgradeToWriteTransaction();
            this.txStateWriter.initialize(this.leaseClient, this.cursorContext, this.currentStatement::lockTracer, this.startTimeMillis, this.lastTransactionIdWhenStarted, this::transactionApplicationMode);
            this.txState = new TxState(this.collectionsFactory, this.memoryTracker, this.transactionStateBehaviour, this.enrichmentStrategy, this.txStateWriter, this.txStateMemoryConsumer, this.transactionEvent);
        }
        return this.txState;
    }

    private boolean hasTxState() {
        return this.txState != null;
    }

    public boolean hasTxStateWithChanges() {
        return this.hasTxState() && this.txState.hasChanges();
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges();
    }

    private void markAsClosed() {
        this.assertTransactionOpen();
        this.closed = true;
        this.closeCurrentStatementIfAny();
    }

    private void closeCurrentStatementIfAny() {
        this.currentStatement.forceClose();
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new NotInTransactionException("This transaction has already been closed.");
        }
    }

    public void needsHighIdTracking() {
        this.needsHighIdTracking = true;
    }

    public void assertOpen() {
        TerminationMark terminationMark = this.terminationMark;
        if (terminationMark != null) {
            throw TransactionTerminatedHelper.transactionTerminated((Status)terminationMark.getReason());
        }
        this.assertTransactionOpen();
    }

    public long commit(KernelTransaction.Monitor monitor) throws TransactionFailureException {
        this.commit = true;
        this.monitor = monitor;
        return this.closeTransaction();
    }

    public void rollback() throws TransactionFailureException {
        if (!this.isOpen()) {
            return;
        }
        this.closeTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long closeTransaction() throws TransactionFailureException {
        this.assertTransactionOpen();
        this.assertTransactionNotClosing();
        this.assertNoInnerTransactions();
        this.closing = true;
        Throwable exception = null;
        long txId = -1L;
        try {
            if (this.canCommit()) {
                txId = this.commitTransaction();
            } else {
                this.rollbackTransaction();
                this.failOnNonExplicitRollbackIfNeeded();
            }
        }
        catch (Error | RuntimeException | TransactionFailureException e) {
            exception = e;
        }
        catch (KernelException e) {
            exception = TransactionFailureException.wrapError((Throwable)e);
        }
        finally {
            try {
                this.closed();
            }
            catch (Error | RuntimeException e) {
                exception = Exceptions.chain((Throwable)exception, (Throwable)e);
                this.failedCleanup = true;
            }
            finally {
                try {
                    this.reset();
                }
                catch (Error | RuntimeException e) {
                    exception = Exceptions.chain((Throwable)exception, (Throwable)e);
                    this.failedCleanup = true;
                }
            }
        }
        if (exception == null) {
            return txId;
        }
        if (this.leaseClient.leaseId() != -1) {
            try {
                this.leaseClient.ensureValid();
            }
            catch (Error | RuntimeException e) {
                exception = Exceptions.chain((Throwable)exception, (Throwable)e);
            }
        }
        Exceptions.throwIfInstanceOf((Throwable)exception, TransactionFailureException.class);
        Exceptions.throwIfUnchecked((Throwable)exception);
        throw TransactionFailureException.unknownError((Throwable)exception);
    }

    private void closed() {
        this.closed = true;
        this.closing = false;
        this.transactionEvent.setCommit(this.commit);
        this.transactionEvent.setRollback(!this.commit);
        this.transactionEvent.setTransactionWriteState(this.writeState.name());
        this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
        this.transactionEvent.close();
    }

    public void close() throws TransactionFailureException {
        try {
            if (this.isOpen()) {
                this.closeTransaction();
            }
        }
        finally {
            if (this.failedCleanup) {
                this.pool.dispose((Object)this);
            } else {
                this.pool.release((Object)this);
            }
        }
    }

    public boolean isClosing() {
        return this.closing;
    }

    private void failOnNonExplicitRollbackIfNeeded() throws TransactionFailureException {
        if (this.commit) {
            if (this.isTerminated()) {
                throw TransactionTerminatedHelper.transactionTerminated((Status)this.terminationMark.getReason());
            }
            throw TransactionFailureException.internalError((Status)Status.Transaction.TransactionMarkedAsFailed, (String)this.getClass().getSimpleName(), (String)"Transaction rolled back even if marked as successful", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long commitTransaction() throws KernelException {
        Throwable exception = null;
        boolean success = false;
        long txId = 0L;
        try (TransactionWriteEvent transactionWriteEvent = this.transactionEvent.beginCommitEvent();){
            this.transactionEventListeners.beforeCommit(this.txState, true);
            if (this.hasChanges()) {
                this.schemaTransactionVersionReset();
                this.lockClient.prepareForCommit();
                long timeCommitted = this.clocks.systemClock().millis();
                txId = this.committer.commit(transactionWriteEvent, this.leaseClient, this.cursorContext, this.memoryTracker, this.monitor, this.lockTracer(), timeCommitted, this.startTimeMillis, this.lastTransactionIdWhenStarted, true, this.transactionApplicationMode());
                this.commitTime = timeCommitted;
            }
            success = true;
        }
        catch (ConstraintValidationException | CreateConstraintFailureException e) {
            exception = ConstraintViolationTransactionFailureException.create((String)e.getUserMessage((TokenNameLookup)this.tokenRead()), (KernelException)e);
        }
        catch (Throwable e) {
            exception = e;
        }
        finally {
            try {
                if (!success) {
                    this.commit = false;
                    this.rollbackTransaction();
                } else {
                    this.transactionId = txId;
                    this.afterCommit();
                }
                this.transactionMonitor.addHeapTransactionSize(this.transactionMemoryPool.usedHeap());
                this.transactionMonitor.addNativeTransactionSize(this.transactionMemoryPool.usedNative());
            }
            catch (Error | RuntimeException e) {
                exception = Exceptions.chain((Throwable)exception, (Throwable)e);
            }
        }
        if (exception == null) {
            return txId;
        }
        Exceptions.throwIfInstanceOf((Throwable)exception, TransactionFailureException.class);
        Exceptions.throwIfUnchecked((Throwable)exception);
        throw TransactionFailureException.unknownError((Throwable)exception);
    }

    private TransactionApplicationMode transactionApplicationMode() {
        return this.needsHighIdTracking ? TransactionApplicationMode.EXTERNAL : TransactionApplicationMode.INTERNAL;
    }

    public List<StorageCommand> extractCommands(MemoryTracker commandsTracker) throws KernelException {
        CommandDecorator commandDecorator = this.commandDecorator(commandsTracker);
        List commands = this.storageEngine.createCommands((ReadableTransactionState)this.txState, this.storageReader, this.commandCreationContext, this.lockTracer(), (TxStateVisitor.Decorator)commandDecorator, this.cursorContext, this.transactionalCursors, commandsTracker);
        return commandDecorator.transform(commands);
    }

    private CommandDecorator commandDecorator(final MemoryTracker commandsTracker) {
        final EnrichmentMode mode = this.txState.enrichmentMode();
        if (this.namedDatabaseId.isSystemDatabase() || mode == EnrichmentMode.OFF || !this.txState.hasDataChanges()) {
            return tx -> this.enforceConstraints((TxStateVisitor)tx, commandsTracker);
        }
        return new CommandDecorator(){
            private TxEnrichmentVisitor enrichmentVisitor;

            public TxStateVisitor apply(TxStateVisitor tx) {
                this.enrichmentVisitor = new TxEnrichmentVisitor(KernelTransactionImplementation.this.enforceConstraints(tx, commandsTracker), mode == EnrichmentMode.DIFF ? CaptureMode.DIFF : CaptureMode.FULL, KernelTransactionImplementation.this.serverIdentity.serverId().shortName(), KernelTransactionImplementation.this.kernelVersionProvider, (arg_0, arg_1) -> ((StorageEngine)KernelTransactionImplementation.this.storageEngine).createEnrichmentCommand(arg_0, arg_1), (ReadableTransactionState)KernelTransactionImplementation.this.txState, KernelTransactionImplementation.this.userMetaData, KernelTransactionImplementation.this.lastTransactionIdWhenStarted, KernelTransactionImplementation.this.storageReader, KernelTransactionImplementation.this.cursorContext, KernelTransactionImplementation.this.transactionalCursors, commandsTracker);
                return this.enrichmentVisitor;
            }

            @Override
            public List<StorageCommand> transform(List<StorageCommand> storageCommands) {
                return this.enrichmentVisitor == null ? storageCommands : this.enrich(storageCommands);
            }

            private List<StorageCommand> enrich(List<StorageCommand> commands) {
                EnrichmentCommand enrichment = this.enrichmentVisitor.command(KernelTransactionImplementation.this.overridableSecurityContext.currentSecurityContext());
                if (enrichment != null) {
                    commands.add((StorageCommand)enrichment);
                }
                return commands;
            }
        };
    }

    public void schemaTransactionVersionReset() {
        if (this.isSchemaTransaction()) {
            this.cursorContext.getVersionContext().initRead();
            this.transactionEvent.refreshVisibilityBoundary();
        }
    }

    private void rollbackTransaction() throws KernelException {
        block18: {
            try {
                if (this.availabilityGuard.isShutdown()) {
                    throw DatabaseShutdownException.databaseUnavailable((String)this.namedDatabaseId.name());
                }
                if (!this.hasTxStateWithChanges()) break block18;
                try (TransactionRollbackEvent rollbackEvent = this.transactionEvent.beginRollback();){
                    this.committer.rollback(rollbackEvent);
                    if (!this.txState().hasConstraintIndexesCreatedInTx()) {
                        return;
                    }
                    try {
                        this.dropCreatedConstraintIndexes();
                    }
                    catch (IllegalStateException | SecurityException e) {
                        throw TransactionFailureException.cannotRollbackCannotDropCreatedConstraintIndex((Throwable)e);
                    }
                }
            }
            catch (Error | RuntimeException | KernelException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw UnspecifiedKernelException.transactionRollbackFailed((Throwable)throwable);
            }
            finally {
                this.afterRollback();
            }
        }
    }

    public Read dataRead() {
        return this.kernelRead;
    }

    public Write dataWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.upgradeToDataWrites();
        return this.operations;
    }

    public TokenWrite tokenWrite() {
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public Token token() {
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public TokenRead tokenRead() {
        return this.operations.token();
    }

    public SchemaRead schemaRead() {
        return this.schemaRead;
    }

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.upgradeToSchemaWrites();
        return new RestrictedSchemaWrite(this.operations, this.securityContext(), this.securityAuthorizationHandler);
    }

    public Upgrade upgrade() {
        this.accessCapability.assertCanWrite();
        return this.operations;
    }

    public Locks locks() {
        return this.entityLocks;
    }

    public LockManager.Client lockClient() {
        this.assertOpen();
        return this.lockClient;
    }

    public LeaseClient leaseClient() {
        return this.leaseClient;
    }

    public CursorFactory cursors() {
        return this.operations.cursors();
    }

    public Procedures procedures() {
        return this.procedures;
    }

    public ExecutionStatistics executionStatistics() {
        return this;
    }

    public StorageEngineCostCharacteristics storageEngineCostCharacteristics() {
        return this.storageEngine.costCharacteristics();
    }

    public LockTracer lockTracer() {
        return this.currentStatement.lockTracer();
    }

    private void afterCommit() {
        try {
            this.markAsClosed();
            this.transactionEventListeners.afterCommit();
            this.monitor.afterCommit((ExecutionStatistics)this);
        }
        finally {
            this.transactionMonitor.transactionFinished(true, this.hasTxState());
            this.transactionExecutionMonitor.commit(this);
        }
    }

    private void afterRollback() {
        try {
            this.markAsClosed();
            this.transactionEventListeners.afterRollback();
        }
        finally {
            this.transactionMonitor.transactionFinished(false, this.hasTxState());
            this.transactionExecutionMonitor.rollback(this, this.transactionEventListeners.failure());
        }
    }

    void releaseStatementResources() {
        this.kernelRead.release();
    }

    protected void reset() {
        this.terminationReleaseLock.lock();
        Throwable error = null;
        try {
            try {
                this.lockClient.close();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain(error, (Throwable)e);
            }
            try {
                this.releaseStorageEngineResources();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            this.timeout = TransactionTimeout.NO_TIMEOUT;
            this.startTimeMillis = Long.MAX_VALUE;
            this.startTimeNanos = Long.MAX_VALUE;
            this.transactionLocalRetries = 0L;
            this.serialExecutionGuard.release();
            this.transactionEventListeners.reset();
            this.terminationMark = null;
            this.type = null;
            this.overridableSecurityContext = null;
            this.transactionEvent = null;
            this.txState = null;
            try {
                this.collectionsFactory.release();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            this.userMetaData = Collections.emptyMap();
            this.statusDetails = "";
            this.clientInfo = null;
            this.internalTransaction = null;
            this.transactionSequenceNumber = 0L;
            try {
                this.statistics.reset();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            try {
                this.releaseStatementResources();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            try {
                this.procedures.reset();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            this.procedureView = null;
            try {
                this.operations.release();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            try {
                this.commandCreationContext.close();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            try {
                this.transactionalCursors.close();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            try {
                this.cursorContext.close();
                CURSOR_CONTEXT_HANDLE.setRelease(this, CursorContext.NULL_CONTEXT);
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            this.initializationTrace = TransactionInitializationTrace.NONE;
            try {
                this.committer.reset();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            try {
                this.transactionMemoryPool.reset();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            try {
                this.innerTransactionHandler.close();
            }
            catch (Error | RuntimeException e) {
                error = Exceptions.chain((Throwable)error, (Throwable)e);
            }
            this.innerTransactionHandler = null;
            this.defaultQueryLanguageScope.reset();
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
        if (error != null) {
            Exceptions.throwIfUnchecked((Throwable)error);
            throw new ResourceCloseFailureException("Failed to close resources", error);
        }
    }

    public void retryQuery() {
        this.transactionMonitor.transactionRetry();
        ++this.transactionLocalRetries;
        this.releaseStorageEngineResources();
        if (this.txState != null) {
            this.txState.reset();
        }
    }

    public void reportVisibilityBoundaryRefresh() {
        this.transactionEvent.refreshVisibilityBoundary();
    }

    public long transactionQueryRetries() {
        return this.transactionLocalRetries;
    }

    private void releaseStorageEngineResources() {
        if (this.availabilityGuard.isShutdown()) {
            throw DatabaseShutdownException.databaseUnavailable((String)this.namedDatabaseId.name());
        }
        if (this.txState != null) {
            this.storageEngine.release((ReadableTransactionState)this.txState, this.cursorContext, this.commandCreationContext, !this.commit);
        }
    }

    private boolean canBeTerminated() {
        return !this.closed && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.terminationMark != null;
    }

    public KernelTransaction.Type transactionType() {
        return this.type;
    }

    public long getTransactionId() {
        long txId = this.transactionId;
        if (txId == -1L) {
            throw new IllegalStateException("Transaction id is not assigned yet. It will be assigned during transaction commit.");
        }
        return txId;
    }

    public long getCommitTime() {
        long time = this.commitTime;
        if (time == -1L) {
            throw new IllegalStateException("Transaction commit time is not assigned yet. It will be assigned during transaction commit.");
        }
        return time;
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        if (!this.closing) {
            this.assertTransactionOpen();
        }
        return this.overridableSecurityContext.overrideWith(context)::close;
    }

    public String toString() {
        return String.format("KernelTransaction[lease:%d]", this.leaseClient.leaseId());
    }

    public void dispose() {
        this.storageReader.close();
        this.transactionMemoryPool.close();
        this.removeConfigChangeListeners(this.config);
    }

    public Collection<ActiveLock> activeLocks() {
        LockManager.Client locks = this.lockClient;
        return locks == null ? Collections.emptyList() : locks.activeLocks();
    }

    public long getTransactionSequenceNumber() {
        return this.transactionSequenceNumber;
    }

    TransactionInitializationTrace getInitializationTrace() {
        return this.initializationTrace;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    protected TxStateVisitor enforceConstraints(TxStateVisitor txStateVisitor, MemoryTracker memoryTracker) {
        return this.constraintSemantics.decorateTxStateVisitor(this.storageReader, this.kernelRead, this.operations.cursors(), (ReadableTransactionState)this.txState, txStateVisitor, CURSOR_CONTEXT_HANDLE.get(this), memoryTracker);
    }

    public ClientConnectionInfo clientInfo() {
        return this.clientInfo;
    }

    public StorageReader newStorageReader() {
        return this.storageEngine.newReader();
    }

    public void addIndexDoDropToTxState(IndexDescriptor index) {
        this.txState().indexDoDrop(index);
    }

    public String getDatabaseName() {
        return this.namedDatabaseId.name();
    }

    public UUID getDatabaseId() {
        return this.namedDatabaseId.databaseId().uuid();
    }

    public InnerTransactionHandler getInnerTransactionHandler() {
        return this.innerTransactionHandler();
    }

    private InnerTransactionHandlerImpl innerTransactionHandler() {
        InnerTransactionHandlerImpl handle = this.innerTransactionHandler;
        if (handle != null) {
            return this.innerTransactionHandler;
        }
        throw new IllegalStateException("Called getInnerTransactionHandler on inactive transaction");
    }

    private void assertNoInnerTransactions() throws TransactionFailureException {
        if (this.innerTransactionHandler().hasInnerTransaction()) {
            throw TransactionFailureException.innerTransactionsStillOpen();
        }
    }

    private SerialExecutionGuard createSerialGuard(boolean multiVersioned) {
        return multiVersioned ? new TransactionSerialExecutionGuard(this.databaseSerialGuard, this) : SerialExecutionGuard.EMPTY_GUARD;
    }

    private TxStateMemoryConsumer createMemoryConsumer(boolean multiVersioned, LocalConfig config) {
        return multiVersioned ? new MultiVersionTxStateMemoryConsumer((Config)config) : TxStateMemoryConsumer.EMPTY_CONSUMER;
    }

    private ChunkedTransactionSink createChunkWriter(boolean multiVersioned) {
        return multiVersioned ? new ChunkSink(this.committer, this.transactionEventListeners, this.clocks, (Config)this.config, this.logProvider, this.exceptionHandlerService) : ChunkedTransactionSink.EMPTY;
    }

    private TransactionCommitter createCommitter(TransactionCommitmentFactory commitmentFactory, boolean multiVersioned, TopologyGraphDbmsModel.HostedOnMode mode) {
        return multiVersioned ? new ChunkCommitter(this, commitmentFactory, this.kernelVersionProvider, this.transactionalCursors, this.transactionIdGenerator, this.commitProcess, this.databaseHealth, this.clocks, this.rollbackProcess, this.transactionValidator, this.validationLockDumper, this.serialExecutionGuard, this.logProvider, mode) : new DefaultCommitter(this, commitmentFactory, this.kernelVersionProvider, this.transactionalCursors, this.transactionIdGenerator, this.commitProcess);
    }

    public boolean isCommitted() {
        return this.commit;
    }

    public TransactionClockContext clocks() {
        return this.clocks;
    }

    public NodeCursor ambientNodeCursor() {
        return this.operations.nodeCursor();
    }

    public RelationshipScanCursor ambientRelationshipCursor() {
        return this.operations.relationshipCursor();
    }

    public PropertyCursor ambientPropertyCursor() {
        return this.operations.propertyCursor();
    }

    public DefaultQueryLanguageScope defaultQueryLanguageScope() {
        return this.defaultQueryLanguageScope;
    }

    public ExceptionHandlerService exceptionHandlerService() {
        return this.exceptionHandlerService;
    }

    public void ensureValid() throws LeaseException {
        this.leaseClient.ensureValid();
    }

    private void registerConfigChangeListeners(LocalConfig config) {
        config.addListener(GraphDatabaseSettings.transaction_tracing_level, (before, after) -> {
            this.traceProvider = TraceProviderFactory.getTraceProvider((Config)config);
        });
        config.addListener(GraphDatabaseSettings.transaction_sampling_percentage, (before, after) -> {
            this.traceProvider = TraceProviderFactory.getTraceProvider((Config)config);
        });
        config.addListener(GraphDatabaseSettings.memory_transaction_max_size, (before, after) -> {
            this.transactionHeapBytesLimit = after;
        });
    }

    private void removeConfigChangeListeners(LocalConfig config) {
        config.removeAllLocalListeners();
    }

    public static class Statistics {
        private volatile long cpuTimeNanosWhenQueryStarted;
        private volatile long heapAllocatedBytesWhenQueryStarted;
        private volatile long waitingTimeNanos;
        private volatile long transactionThreadId;
        private final KernelTransactionImplementation transaction;
        private final AtomicReference<CpuClock> cpuClockRef;
        private CpuClock cpuClock;
        private final HeapAllocation heapAllocation;

        public Statistics(KernelTransactionImplementation transaction, AtomicReference<CpuClock> cpuClockRef, boolean heapAllocationTracking) {
            this.transaction = transaction;
            this.cpuClockRef = cpuClockRef;
            this.heapAllocation = heapAllocationTracking ? HeapAllocation.HEAP_ALLOCATION : HeapAllocation.NOT_AVAILABLE;
        }

        protected void init(long threadId) {
            this.cpuClock = this.cpuClockRef.get();
            this.transactionThreadId = threadId;
            this.cpuTimeNanosWhenQueryStarted = this.cpuClock.cpuTimeNanos(this.transactionThreadId);
            this.heapAllocatedBytesWhenQueryStarted = this.heapAllocation.allocatedBytes(this.transactionThreadId);
        }

        long heapAllocatedBytes() {
            long allocatedBytes = this.heapAllocation.allocatedBytes(this.transactionThreadId);
            return allocatedBytes < 0L ? -1L : allocatedBytes - this.heapAllocatedBytesWhenQueryStarted;
        }

        long estimatedHeapMemory() {
            return this.transaction.transactionMemoryPool.usedHeap();
        }

        long usedNativeMemory() {
            return this.transaction.transactionMemoryPool.usedNative();
        }

        public long cpuTimeMillis() {
            long cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.transactionThreadId);
            return cpuTimeNanos < 0L ? -1L : TimeUnit.NANOSECONDS.toMillis(cpuTimeNanos - this.cpuTimeNanosWhenQueryStarted);
        }

        void addWaitingTime(long waitTimeNanos) {
            this.waitingTimeNanos += waitTimeNanos;
        }

        long getWaitingTimeNanos(long nowNanos) {
            Optional<ExecutingQuery> query = this.transaction.executingQuery();
            long waitingTime = this.waitingTimeNanos;
            if (query.isPresent()) {
                long latestQueryWaitingNanos = query.get().totalWaitingTimeNanos(nowNanos);
                waitingTime += latestQueryWaitingNanos;
            }
            return waitingTime;
        }

        void reset() {
            this.cpuTimeNanosWhenQueryStarted = 0L;
            this.heapAllocatedBytesWhenQueryStarted = 0L;
            this.waitingTimeNanos = 0L;
            this.transactionThreadId = -1L;
        }
    }

    @FunctionalInterface
    private static interface ExecutionContextFactory {
        public ExecutionContext createNew(SecurityContext var1, long var2, CursorContext var4, Supplier<ClockContext> var5, KernelTransaction var6, ProcedureView var7, HeapEstimatorCacheConfig var8);
    }

    private static enum TransactionWriteState {
        NONE,
        DATA{

            @Override
            TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
                throw InvalidTransactionTypeKernelException.invalidTransactionType((String)"Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
                throw InvalidTransactionTypeKernelException.invalidTransactionType((String)"Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }

    private record ExecutionContextClock(Clock systemClock, Clock transactionClock, Clock statementClock) implements ClockContext
    {
    }

    private static interface CommandDecorator
    extends TxStateVisitor.Decorator {
        default public List<StorageCommand> transform(List<StorageCommand> storageCommands) {
            return storageCommands;
        }
    }
}

