/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.ReadableChannelPageCursor;
import org.neo4j.memory.MemoryTracker;

public class IndexUpdateStorage<KEY extends NativeIndexKey<KEY>>
implements Closeable {
    static final byte STOP_TYPE = -1;
    private static final int TYPE_SIZE = 1;
    private static final int VERSION_SIZE = 8;
    private static final byte[] NO_ENTRIES = new byte[]{-1};
    private final Path file;
    private final FileSystemAbstraction fs;
    private final int blockSize;
    private final MemoryTracker memoryTracker;
    private final ByteBufferFactory.Allocator byteBufferFactory;
    private final IndexLayout<KEY> layout;
    private volatile boolean allocated;
    private ScopedBuffer scopedBuffer;
    private ByteBuffer buffer;
    private ByteArrayPageCursor pageCursor;
    private StoreChannel storeChannel;
    private final AtomicLong count = new AtomicLong();

    IndexUpdateStorage(FileSystemAbstraction fs, Path file, ByteBufferFactory.Allocator byteBufferFactory, int blockSize, IndexLayout<KEY> layout, MemoryTracker memoryTracker) {
        this.fs = fs;
        this.file = file;
        this.byteBufferFactory = byteBufferFactory;
        this.blockSize = blockSize;
        this.memoryTracker = memoryTracker;
        this.layout = layout;
    }

    void add(boolean addition, KEY key, long version) throws IOException {
        this.allocateResources();
        this.ensureCapacity(this.entrySize(key));
        this.pageCursor.putByte((byte)(addition ? 1 : 0));
        this.pageCursor.putLong(version);
        BlockEntry.write((PageCursor)this.pageCursor, this.layout, key);
        this.count.incrementAndGet();
    }

    IndexUpdateCursor<KEY> reader() throws IOException {
        if (!this.allocated) {
            return new IndexUpdateCursor(ByteArrayPageCursor.wrap((byte[])NO_ENTRIES), this.layout);
        }
        ReadAheadChannel channel = new ReadAheadChannel(this.fs.read(this.file), this.byteBufferFactory.allocate(this.blockSize, this.memoryTracker));
        return new IndexUpdateCursor(new ReadableChannelPageCursor((ReadableChannel)channel), this.layout);
    }

    long count() {
        return this.count.get();
    }

    void doneAdding() throws IOException {
        if (!this.allocated) {
            return;
        }
        this.ensureCapacity(1);
        this.pageCursor.putByte((byte)-1);
        this.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.allocated) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.pageCursor, this.storeChannel, this.scopedBuffer, this::deleteFile, () -> {
                this.allocated = false;
            }});
        } else if (this.fs.fileExists(this.file)) {
            this.fs.deleteFile(this.file);
        }
    }

    private int entrySize(KEY key) {
        return 9 + BlockEntry.keySize(this.layout, key);
    }

    private void ensureCapacity(int entrySize) throws IOException {
        assert (entrySize <= this.buffer.limit()) : "Expected entry to fit in buffer (entry=" + entrySize + " bytes, buffer=" + this.buffer.limit() + " bytes)";
        if (entrySize > this.buffer.remaining()) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        this.buffer.flip();
        this.storeChannel.writeAll(this.buffer);
        this.buffer.clear();
    }

    private void allocateResources() throws IOException {
        if (!this.allocated) {
            this.scopedBuffer = this.byteBufferFactory.allocate(this.blockSize, this.memoryTracker);
            this.buffer = this.scopedBuffer.getBuffer();
            this.pageCursor = new ByteArrayPageCursor(this.buffer);
            this.storeChannel = this.fs.write(this.file);
            this.allocated = true;
        }
    }

    private void deleteFile() {
        try {
            this.fs.deleteFile(this.file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

