/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.time.Duration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.LoggingVmPauseMonitor;
import org.neo4j.logging.InternalLog;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.VmPauseMonitor;
import org.neo4j.scheduler.JobScheduler;

public class VmPauseMonitorComponent
extends LifecycleAdapter {
    private final Config config;
    private final JobScheduler jobScheduler;
    private final VmPauseMonitor.Monitor monitor;
    private final LoggingVmPauseMonitor loggingVmPauseMonitor;
    private final Monitors globalMonitors;
    private volatile VmPauseMonitor vmPauseMonitor;

    public VmPauseMonitorComponent(Config config, InternalLog log, JobScheduler jobScheduler, Monitors globalMonitors) {
        this.config = config;
        this.jobScheduler = jobScheduler;
        this.globalMonitors = globalMonitors;
        this.monitor = (VmPauseMonitor.Monitor)globalMonitors.newMonitor(VmPauseMonitor.Monitor.class, new String[0]);
        this.loggingVmPauseMonitor = new LoggingVmPauseMonitor(log);
    }

    public void start() {
        this.globalMonitors.addMonitorListener((Object)this.loggingVmPauseMonitor, new String[0]);
        this.vmPauseMonitor = new VmPauseMonitor((Duration)this.config.get(GraphDatabaseInternalSettings.vm_pause_monitor_measurement_duration), (Duration)this.config.get(GraphDatabaseInternalSettings.vm_pause_monitor_stall_alert_threshold), this.monitor, this.jobScheduler);
        this.vmPauseMonitor.start();
    }

    public void stop() {
        this.vmPauseMonitor.stop();
        this.vmPauseMonitor = null;
        this.globalMonitors.removeMonitorListener((Object)this.loggingVmPauseMonitor);
    }
}

