/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingTask;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingTask;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.InternalLogProvider;

public class OnlineIndexSamplingTaskFactory
implements IndexSamplingJobFactory {
    private final IndexStatisticsStore indexStatisticsStore;
    private final InternalLogProvider logProvider;
    private final TokenNameLookup nameLookup;
    private final CursorContextFactory contextFactory;

    public OnlineIndexSamplingTaskFactory(IndexStatisticsStore indexStatisticsStore, TokenNameLookup nameLookup, InternalLogProvider logProvider, CursorContextFactory contextFactory) {
        this.indexStatisticsStore = indexStatisticsStore;
        this.logProvider = logProvider;
        this.nameLookup = nameLookup;
        this.contextFactory = contextFactory;
    }

    @Override
    public IndexSamplingTask create(long indexId, IndexProxy indexProxy) {
        IndexDescriptor descriptor = indexProxy.getDescriptor();
        String indexName = descriptor.getName();
        String indexUserDescription = descriptor.userDescription(this.nameLookup);
        return new OnlineIndexSamplingTask(indexId, indexProxy, this.indexStatisticsStore, indexUserDescription, indexName, this.logProvider, this.contextFactory);
    }
}

