/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;

public class MaximumTransactionLimitExceededException
extends TransactionFailureException
implements Status.HasStatus {
    private static final String MAXIMUM_TRANSACTIONS_LIMIT_MESSAGE = "Unable to start new transaction since limit of concurrently executed transactions is reached. See setting " + GraphDatabaseSettings.max_concurrent_transactions.name();

    private MaximumTransactionLimitExceededException(ErrorGqlStatusObject gqlStatusObject) {
        super(gqlStatusObject, MAXIMUM_TRANSACTIONS_LIMIT_MESSAGE, (Status)Status.Transaction.MaximumTransactionLimitReached);
    }

    public static MaximumTransactionLimitExceededException maximumNumberOfTransactionsExceeded() {
        ErrorGqlStatusObject gqlStatusObject = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N74).withParam(GqlParams.StringParam.cfgSetting, GraphDatabaseSettings.max_concurrent_transactions.name()).build();
        return new MaximumTransactionLimitExceededException(gqlStatusObject);
    }
}

