/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.availability;

import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.util.VisibleForTesting;

public class CompositeDatabaseAvailabilityGuard
extends LifecycleAdapter
implements AvailabilityGuard {
    private final Clock clock;
    private final Config config;
    private final CopyOnWriteArraySet<DatabaseAvailabilityGuard> guards = new CopyOnWriteArraySet();
    private volatile boolean started = true;

    public CompositeDatabaseAvailabilityGuard(Clock clock, Config config) {
        this.clock = clock;
        this.config = config;
    }

    void addDatabaseAvailabilityGuard(DatabaseAvailabilityGuard guard) {
        this.guards.add(guard);
    }

    void removeDatabaseAvailabilityGuard(DatabaseAvailabilityGuard guard) {
        this.guards.remove(guard);
    }

    @Override
    public void require(AvailabilityRequirement requirement) {
        this.guards.forEach(guard -> guard.require(requirement));
    }

    @Override
    public void fulfill(AvailabilityRequirement requirement) {
        this.guards.forEach(guard -> guard.fulfill(requirement));
    }

    public void stop() {
        this.started = false;
        this.config.set(GraphDatabaseSettings.check_point_iops_limit, (Object)-1);
    }

    @Override
    public boolean isAvailable() {
        return this.guards.stream().allMatch(DatabaseAvailabilityGuard::isAvailable) && this.started;
    }

    @Override
    public boolean isShutdown() {
        return !this.started;
    }

    @Override
    public boolean isAvailable(long millis) {
        long totalWait = 0L;
        for (DatabaseAvailabilityGuard guard : this.guards) {
            long startMillis = this.clock.millis();
            if (!guard.isAvailable(Math.max(0L, millis - totalWait))) {
                return false;
            }
            if ((totalWait += this.clock.millis() - startMillis) <= millis) continue;
            return false;
        }
        return this.started;
    }

    @Override
    public void await(long millis) throws UnavailableException {
        long totalWait = 0L;
        for (DatabaseAvailabilityGuard guard : this.guards) {
            long startMillis = this.clock.millis();
            guard.await(Math.max(0L, millis - totalWait));
            if ((totalWait += this.clock.millis() - startMillis) <= millis) continue;
            throw UnavailableException.databaseUnavailable(guard.databaseName(), this.getUnavailableMessage());
        }
        if (!this.started) {
            throw UnavailableException.databaseUnavailable("", this.getUnavailableMessage());
        }
    }

    @Override
    public void addListener(AvailabilityListener listener) {
        throw new UnsupportedOperationException("Composite guard does not support this operation.");
    }

    @Override
    public void removeListener(AvailabilityListener listener) {
        throw new UnsupportedOperationException("Composite guard does not support this operation.");
    }

    @Override
    public String describe() {
        return this.guards.stream().map(DatabaseAvailabilityGuard::describe).collect(Collectors.joining(", "));
    }

    @VisibleForTesting
    public Set<DatabaseAvailabilityGuard> getGuards() {
        return Collections.unmodifiableSet(this.guards);
    }

    private String getUnavailableMessage() {
        return "Database is not available: " + this.describe();
    }
}

