/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Locale;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class IncompatibleGraphTypeDependenceException
extends SchemaKernelException {
    private IncompatibleGraphTypeDependenceException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, ConstraintDescriptor preExistingConstraint, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintCreationFailed, IncompatibleGraphTypeDependenceException.constructUserMessage(constraint, preExistingConstraint, tokenNameLookup));
    }

    public static IncompatibleGraphTypeDependenceException incompatibleGraphTypeDependence(ConstraintDescriptor constraint, ConstraintDescriptor preExistingConstraint, TokenNameLookup tokenNameLookup) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB2).withParam(GqlParams.StringParam.graphTypeDependence1, constraint.graphTypeDependence().name().toLowerCase(Locale.ROOT)).withParam(GqlParams.StringParam.constrDescrOrName1, constraint.userDescription(tokenNameLookup)).withParam(GqlParams.StringParam.graphTypeDependence2, preExistingConstraint.graphTypeDependence().name().toLowerCase(Locale.ROOT)).withParam(GqlParams.StringParam.constrDescrOrName2, preExistingConstraint.userDescription(tokenNameLookup)).build();
        return new IncompatibleGraphTypeDependenceException(gql, constraint, preExistingConstraint, tokenNameLookup);
    }

    private static String constructUserMessage(ConstraintDescriptor constraint, ConstraintDescriptor preExistingConstraint, TokenNameLookup tokenNameLookup) {
        return String.format("Graph type %s constraint %s is incompatible with graph type %s constraint %s because they have different graph type dependence.", constraint.graphTypeDependence().name().toLowerCase(Locale.ROOT), constraint.userDescription(tokenNameLookup), preExistingConstraint.graphTypeDependence().name().toLowerCase(Locale.ROOT), preExistingConstraint.userDescription(tokenNameLookup));
    }
}

