/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryContextTracker;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryPredicateException;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.RollbackTransactionInfo;
import org.neo4j.kernel.recovery.TransactionIdTracker;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.time.Stopwatch;

public class TransactionLogsRecovery
extends LifecycleAdapter {
    private static final String REVERSE_RECOVERY_TAG = "restoreDatabase";
    private static final String RECOVERY_TAG = "recoverDatabase";
    private final LogFiles logFiles;
    private final KernelVersionProvider versionProvider;
    private final LogFormatVersionProvider logFormatVersionProvider;
    private final RecoveryService recoveryService;
    private final RecoveryMonitor monitor;
    private final CorruptedLogsTruncator logsTruncator;
    private final Lifecycle schemaLife;
    private final ProgressMonitorFactory progressMonitorFactory;
    private final boolean failOnCorruptedLogFiles;
    private final RecoveryStartupChecker recoveryStartupChecker;
    private final boolean rollbackIncompleteTransactions;
    private final CursorContextFactory contextFactory;
    private final RecoveryPredicate recoveryPredicate;
    private final Clock clock;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final RecoveryMode mode;
    private ProgressListener progressListener;

    public TransactionLogsRecovery(LogFiles logFiles, KernelVersionProvider versionProvider, LogFormatVersionProvider logFormatVersionProvider, RecoveryService recoveryService, CorruptedLogsTruncator logsTruncator, Lifecycle schemaLife, RecoveryMonitor monitor, ProgressMonitorFactory progressMonitorFactory, boolean failOnCorruptedLogFiles, RecoveryStartupChecker recoveryStartupChecker, RecoveryPredicate recoveryPredicate, boolean rollbackIncompleteTransactions, CursorContextFactory contextFactory, Clock clock, BinarySupportedKernelVersions binarySupportedKernelVersions, RecoveryMode mode) {
        this.logFiles = logFiles;
        this.versionProvider = versionProvider;
        this.logFormatVersionProvider = logFormatVersionProvider;
        this.recoveryService = recoveryService;
        this.monitor = monitor;
        this.logsTruncator = logsTruncator;
        this.schemaLife = schemaLife;
        this.progressMonitorFactory = progressMonitorFactory;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.recoveryStartupChecker = recoveryStartupChecker;
        this.rollbackIncompleteTransactions = rollbackIncompleteTransactions;
        this.contextFactory = contextFactory;
        this.recoveryPredicate = recoveryPredicate;
        this.clock = clock;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
        this.mode = mode;
        this.progressListener = null;
    }

    public void init() throws Exception {
        RecoveryStartInformation recoveryStartInformation = this.recoveryService.getRecoveryStartInformation();
        if (!recoveryStartInformation.isRecoveryRequired()) {
            this.schemaLife.init();
            return;
        }
        Stopwatch recoveryStartTime = Stopwatch.start();
        this.monitor.recoveryRequired(recoveryStartInformation);
        if (recoveryStartInformation.missingLogs()) {
            this.recoveryService.missingLogs();
            this.logFiles.getLogFile().initializeMissingLogFile();
        } else {
            this.performRecovery(recoveryStartInformation);
        }
        this.monitor.transactionLogRecoveryCompleted(recoveryStartTime.elapsed(TimeUnit.MILLISECONDS), this.mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRecovery(RecoveryStartInformation recoveryStartInformation) throws DatabaseStartAbortedException, RecoveryPredicateException, IOException {
        try {
            LogPosition recoveryStartPosition = recoveryStartInformation.transactionLogPosition();
            RecoveryContextTracker recoveryContextTracker = new RecoveryContextTracker(recoveryStartPosition, recoveryStartInformation.checkpointInfo());
            TransactionIdTracker transactionIdTracker = new TransactionIdTracker();
            this.reverseAndForwardRecovery(recoveryStartInformation, transactionIdTracker, recoveryStartPosition, recoveryContextTracker);
            RecoveryRollbackAppendIndexProvider appendIndexProvider = new RecoveryRollbackAppendIndexProvider(recoveryContextTracker.getLastBatchInfo());
            if (this.rollbackIncompleteTransactions) {
                this.logsTruncator.truncate(recoveryContextTracker.getRecoveryToPosition(), recoveryStartInformation.checkpointInfo());
                RollbackTransactionInfo rollbackTransactionInfo = this.rollbackTransactions(recoveryContextTracker.getRecoveryToPosition(), transactionIdTracker, appendIndexProvider, this.monitor);
                if (rollbackTransactionInfo != null) {
                    recoveryContextTracker.rollbackBatch(rollbackTransactionInfo, rollbackTransactionInfo.position());
                }
            }
            this.recoveryService.transactionsRecovered(recoveryContextTracker.getLastHighestTransactionBatchInfo(), appendIndexProvider, recoveryContextTracker.getLastTransactionPosition(), recoveryContextTracker.getRecoveryToPosition(), recoveryStartInformation.getCheckpointPosition());
        }
        finally {
            this.closeProgress();
        }
    }

    private void reverseAndForwardRecovery(RecoveryStartInformation recoveryStartInformation, TransactionIdTracker transactionIdTracker, LogPosition recoveryStartPosition, RecoveryContextTracker recoveryContextTracker) throws ClosedByInterruptException, DatabaseStartAbortedException, RecoveryPredicateException {
        try {
            if (this.mode == RecoveryMode.FULL) {
                this.reverseRecovery(recoveryStartInformation, transactionIdTracker);
            } else {
                this.skipReverseRecovery(recoveryStartInformation);
            }
            this.forwardRecovery(recoveryStartInformation, transactionIdTracker, recoveryStartPosition, recoveryContextTracker);
        }
        catch (Error | ClosedByInterruptException | DatabaseStartAbortedException | RecoveryPredicateException e) {
            throw e;
        }
        catch (Throwable t) {
            this.handleUnexpectedRecoveryError(recoveryStartPosition, recoveryContextTracker, t);
        }
    }

    private void skipReverseRecovery(RecoveryStartInformation recoveryStartInformation) throws Exception {
        this.initProgressReporter(recoveryStartInformation, recoveryStartInformation.transactionLogPosition());
        this.schemaLife.init();
    }

    private void handleUnexpectedRecoveryError(LogPosition recoveryStartPosition, RecoveryContextTracker recoveryContextTracker, Throwable t) {
        if (this.failOnCorruptedLogFiles) {
            Recovery.throwUnableToCleanRecover(t);
        }
        if (recoveryContextTracker.hasRecoveredBatches()) {
            this.monitor.failToRecoverTransactionsAfterCommit(t, recoveryContextTracker.getLastHighestTransactionBatchInfo(), recoveryContextTracker.getRecoveryToPosition());
        } else {
            this.monitor.failToRecoverTransactionsAfterPosition(t, recoveryStartPosition);
        }
    }

    private void forwardRecovery(RecoveryStartInformation recoveryStartInformation, TransactionIdTracker transactionIdTracker, LogPosition recoveryStartPosition, RecoveryContextTracker recoveryContextTracker) throws Exception {
        try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatches(recoveryStartPosition);
             RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.RECOVERY, this.contextFactory, RECOVERY_TAG);){
            while (transactionsToRecover.next()) {
                CommittedCommandBatchRepresentation nextCommandBatch = (CommittedCommandBatchRepresentation)transactionsToRecover.get();
                if (!this.recoveryPredicate.test(nextCommandBatch)) {
                    this.completeAsPartialRecovery(recoveryStartInformation, recoveryContextTracker);
                    return;
                }
                this.recoveryStartupChecker.checkIfCanceled();
                if (this.processCommandBatch(transactionIdTracker, nextCommandBatch, recoveryVisitor)) {
                    recoveryContextTracker.completeRecovery(recoveryContextTracker.getLastTransactionPosition());
                    return;
                }
                recoveryContextTracker.commitedBatch(nextCommandBatch, transactionsToRecover.position());
                this.reportProgress();
            }
            recoveryContextTracker.completeRecovery(transactionsToRecover.position());
        }
    }

    private boolean processCommandBatch(TransactionIdTracker idTracker, CommittedCommandBatchRepresentation commandBatch, RecoveryApplier visitor) throws Exception {
        switch (idTracker.transactionStatus(commandBatch.txId())) {
            case RECOVERABLE: {
                visitor.visit(commandBatch);
                this.monitor.batchRecovered(commandBatch);
                break;
            }
            case ROLLED_BACK: {
                this.monitor.batchApplySkipped(commandBatch);
                break;
            }
            case INCOMPLETE: {
                this.monitor.batchApplySkipped(commandBatch);
                return !this.rollbackIncompleteTransactions;
            }
        }
        return false;
    }

    private void completeAsPartialRecovery(RecoveryStartInformation recoveryStartInformation, RecoveryContextTracker recoveryContextTracker) throws RecoveryPredicateException {
        this.monitor.partialRecovery(this.recoveryPredicate, recoveryContextTracker.getLastHighestTransactionBatchInfo());
        this.verifyPartialRecovery(recoveryStartInformation, recoveryContextTracker);
        recoveryContextTracker.completeRecovery(recoveryContextTracker.getLastTransactionPosition());
    }

    private void verifyPartialRecovery(RecoveryStartInformation recoveryStartInformation, RecoveryContextTracker recoveryContextTracker) throws RecoveryPredicateException {
        if (recoveryContextTracker.hasRecoveredBatches()) {
            return;
        }
        long beforeCheckpointAppendIndex = recoveryStartInformation.firstAppendIndexAfterLastCheckPoint() - 1L;
        if (beforeCheckpointAppendIndex < 1L) {
            throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint is not valid. Append index before checkpoint: %d, criteria %s.", beforeCheckpointAppendIndex, this.recoveryPredicate.describe()));
        }
        this.verifyCommandBatchSatisfiesPartialRecoveryPredicate(recoveryContextTracker, beforeCheckpointAppendIndex);
    }

    private void verifyCommandBatchSatisfiesPartialRecoveryPredicate(RecoveryContextTracker recoveryContextTracker, long appendIndex) throws RecoveryPredicateException {
        try (CommandBatchCursor commandBatches = this.recoveryService.getCommandBatches(appendIndex);){
            if (!commandBatches.next()) {
                throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint not found. Recovery criteria: %s.", this.recoveryPredicate.describe()));
            }
            CommittedCommandBatchRepresentation candidate = (CommittedCommandBatchRepresentation)commandBatches.get();
            if (!this.recoveryPredicate.test(candidate)) {
                throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. Transaction after and before checkpoint does not satisfy provided recovery criteria. Observed transaction id: %d, recovery criteria: %s.", candidate.txId(), this.recoveryPredicate.describe()));
            }
            recoveryContextTracker.commitedBatch(candidate, commandBatches.position());
        }
        catch (RecoveryPredicateException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and fail to read transaction before checkpoint. Recovery criteria: %s.", this.recoveryPredicate.describe()), e);
        }
    }

    private RollbackTransactionInfo rollbackTransactions(LogPosition writePosition, TransactionIdTracker transactionTracker, AppendIndexProvider appendIndexProvider, RecoveryMonitor monitor) throws IOException {
        long[] notCompletedTransactions = transactionTracker.notCompletedTransactions();
        if (notCompletedTransactions.length == 0) {
            return null;
        }
        KernelVersion kernelVersion = this.versionProvider.kernelVersion();
        LogFile logFile = this.logFiles.getLogFile();
        try (ChannelWithPartialLogRotationAbility channelAllocator = new ChannelWithPartialLogRotationAbility(logFile, appendIndexProvider, this.versionProvider, this.logFormatVersionProvider, logFile.rotationSize(), writePosition);){
            PhysicalFlushableLogPositionAwareChannel writerChannel = channelAllocator.getWriterChannel();
            LogEntryWriter<PhysicalFlushableLogPositionAwareChannel> entryWriter = new LogEntryWriter<PhysicalFlushableLogPositionAwareChannel>(writerChannel, this.binarySupportedKernelVersions);
            long time = this.clock.millis();
            CommittedCommandBatchRepresentation.BatchInformation lastBatchInfo = null;
            for (int i = 0; i < notCompletedTransactions.length; ++i) {
                long notCompletedTransaction = notCompletedTransactions[i];
                long appendIndex = appendIndexProvider.nextAppendIndex();
                int checksum = entryWriter.writeRollbackEntry(kernelVersion, notCompletedTransaction, appendIndex, time);
                if (i == notCompletedTransactions.length - 1) {
                    lastBatchInfo = new CommittedCommandBatchRepresentation.BatchInformation(notCompletedTransaction, kernelVersion, checksum, time, -1L, appendIndex);
                }
                monitor.rollbackTransaction(notCompletedTransaction, appendIndex);
            }
            RollbackTransactionInfo rollbackTransactionInfo = new RollbackTransactionInfo(lastBatchInfo, writerChannel.getCurrentLogPosition());
            return rollbackTransactionInfo;
        }
    }

    private void reverseRecovery(RecoveryStartInformation recoveryStartInformation, TransactionIdTracker transactionIdTracker) throws Exception {
        long lowestRecoveredAppendIndex = this.reverseCompleteBatches(recoveryStartInformation, transactionIdTracker);
        this.schemaLife.init();
        this.reverseIncompleteBatches(transactionIdTracker.notCompletedTransactionAppendIndexes());
        this.monitor.reverseStoreRecoveryCompleted(lowestRecoveredAppendIndex);
    }

    private void reverseIncompleteBatches(long[] incompleteAppendIndexes) throws Exception {
        try (RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.MVCC_INCOMPLETE_REVERSE_RECOVERY, this.contextFactory, REVERSE_RECOVERY_TAG);){
            long[] lArray = incompleteAppendIndexes;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                long appendIndex;
                long nextIndexToReverse = appendIndex = lArray[i];
                while (nextIndexToReverse != 0L) {
                    nextIndexToReverse = this.reverseChunk(nextIndexToReverse, recoveryVisitor);
                }
            }
        }
    }

    private long reverseChunk(long appendIndex, RecoveryApplier recoveryVisitor) throws Exception {
        try (CommandBatchCursor batchToReverse = this.recoveryService.getCommandBatches(appendIndex);){
            if (batchToReverse.next()) {
                this.recoveryStartupChecker.checkIfCanceled();
                CommittedCommandBatchRepresentation batch = (CommittedCommandBatchRepresentation)batchToReverse.get();
                recoveryVisitor.visit(batch);
                this.reportProgress();
                assert (batch.commandBatch().isFirst() == (batch.previousBatchAppendIndex() == 0L)) : "the first batch must not have previous batch append index but points to " + batch.previousBatchAppendIndex();
                long l = batch.previousBatchAppendIndex();
                return l;
            }
        }
        throw new Error(String.format("Error reversing incomplete transactions Expected to find the batch with append index %d", appendIndex));
    }

    private long reverseCompleteBatches(RecoveryStartInformation recoveryStartInformation, TransactionIdTracker transactionIdTracker) throws Exception {
        CommittedCommandBatchRepresentation lastReversedCommandBatch = null;
        LogPosition oldestNotVisibleTransactionLogPosition = recoveryStartInformation.oldestNotVisibleTransactionLogPosition();
        LogPosition checkpointedLogPosition = recoveryStartInformation.transactionLogPosition();
        long lowestRecoveredAppendIndex = recoveryStartInformation.firstAppendIndexAfterLastCheckPoint();
        try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatchesInReverseOrder(oldestNotVisibleTransactionLogPosition);
             RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.REVERSE_RECOVERY, this.contextFactory, REVERSE_RECOVERY_TAG);){
            while (transactionsToRecover.next()) {
                this.recoveryStartupChecker.checkIfCanceled();
                CommittedCommandBatchRepresentation commandBatch = (CommittedCommandBatchRepresentation)transactionsToRecover.get();
                if (lastReversedCommandBatch == null) {
                    lastReversedCommandBatch = commandBatch;
                    this.initProgressReporter(recoveryStartInformation, lastReversedCommandBatch, this.mode);
                }
                transactionIdTracker.trackBatch(commandBatch);
                if (transactionsToRecover.position().isAfterOrSame(checkpointedLogPosition)) {
                    recoveryVisitor.visit(commandBatch);
                }
                lowestRecoveredAppendIndex = commandBatch.appendIndex();
                this.reportProgress();
            }
        }
        return lowestRecoveredAppendIndex;
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, LogPosition recoveryStartPosition) throws IOException {
        try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatchesInReverseOrder(recoveryStartPosition);){
            if (transactionsToRecover.next()) {
                CommittedCommandBatchRepresentation commandBatch = (CommittedCommandBatchRepresentation)transactionsToRecover.get();
                this.initProgressReporter(recoveryStartInformation, commandBatch, this.mode);
            }
        }
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, CommittedCommandBatchRepresentation lastReversedBatch, RecoveryMode mode) {
        long numberOfBatchesToRecover = TransactionLogsRecovery.estimateNumberOfBatchesToRecover(recoveryStartInformation, lastReversedBatch);
        this.progressListener = this.progressMonitorFactory.singlePart("TransactionLogsRecovery", mode == RecoveryMode.FULL ? numberOfBatchesToRecover * 2L : numberOfBatchesToRecover);
    }

    private void reportProgress() {
        this.progressListener.add(1L);
    }

    private void closeProgress() {
        if (this.progressListener != null) {
            this.progressListener.close();
        }
    }

    private static long estimateNumberOfBatchesToRecover(RecoveryStartInformation recoveryStartInformation, CommittedCommandBatchRepresentation lastReversedCommandBatch) {
        return lastReversedCommandBatch.appendIndex() - recoveryStartInformation.firstAppendIndexAfterLastCheckPoint() + 1L;
    }

    public void start() throws Exception {
        this.schemaLife.start();
    }

    public void stop() throws Exception {
        this.schemaLife.stop();
    }

    public void shutdown() throws Exception {
        this.schemaLife.shutdown();
    }

    private static class RecoveryRollbackAppendIndexProvider
    implements AppendIndexProvider {
        private final MutableLong rollbackIndex;

        public RecoveryRollbackAppendIndexProvider(CommittedCommandBatchRepresentation.BatchInformation lastBatchInfo) {
            this.rollbackIndex = lastBatchInfo == null ? new MutableLong(1L) : new MutableLong(lastBatchInfo.appendIndex());
        }

        public long nextAppendIndex() {
            return this.rollbackIndex.incrementAndGet();
        }

        public long getLastAppendIndex() {
            return this.rollbackIndex.longValue();
        }
    }

    private static class ChannelWithPartialLogRotationAbility
    implements LogRotation,
    Closeable {
        private final PhysicalFlushableLogPositionAwareChannel writer;
        private PhysicalLogVersionedStoreChannel channel;
        private final LogFile logFile;
        private final AppendIndexProvider appendIndexProvider;
        private final KernelVersionProvider versionProvider;
        private final LogFormatVersionProvider logFormatVersionProvider;
        private final long rotateAtSize;

        public ChannelWithPartialLogRotationAbility(LogFile logFile, AppendIndexProvider appendIndexProvider, KernelVersionProvider versionProvider, LogFormatVersionProvider logFormatVersionProvider, long rotateAtSize, LogPosition writePosition) throws IOException {
            this.logFile = logFile;
            this.appendIndexProvider = appendIndexProvider;
            this.versionProvider = versionProvider;
            this.logFormatVersionProvider = logFormatVersionProvider;
            this.rotateAtSize = rotateAtSize;
            this.channel = logFile.createLogChannelForExistingVersion(writePosition.getLogVersion());
            this.channel.position(writePosition.getByteOffset());
            this.writer = new PhysicalFlushableLogPositionAwareChannel((LogVersionedStoreChannel)this.channel, logFile.extractHeader(writePosition.getLogVersion()), new PhysicalFlushableLogPositionAwareChannel.VersionedPhysicalFlushableLogChannelProvider(LogRotation.NO_ROTATION, DatabaseTracer.NULL, (ScopedBuffer)logFile.createScopedBuffer()));
        }

        public PhysicalFlushableLogPositionAwareChannel getWriterChannel() {
            return this.writer;
        }

        public boolean rotateLogIfNeeded(LogRotateEvents logRotateEvents) {
            throw new UnsupportedOperationException();
        }

        public boolean locklessBatchedRotateLogIfNeeded(LogRotateEvents logRotateEvents, long lastAppendIndex, KernelVersion kernelVersion, int checksum, LogFormat logFormat) {
            throw new UnsupportedOperationException();
        }

        public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents) {
            throw new UnsupportedOperationException();
        }

        public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, boolean force) {
            throw new UnsupportedOperationException();
        }

        public void rotateLogFile(LogRotateEvents logRotateEvents) throws IOException {
            long newLogVersion = this.channel.getLogVersion() + 1L;
            this.writer.prepareForFlush().flush();
            this.channel.truncate(this.channel.position());
            PhysicalLogVersionedStoreChannel newLog = this.logFile.createLogChannelForVersion(newLogVersion, () -> ((AppendIndexProvider)this.appendIndexProvider).getLastAppendIndex(), this.versionProvider, this.writer.currentChecksum().orElse(-559063315), this.logFormatVersionProvider);
            this.channel.close();
            this.channel = newLog;
            this.writer.setChannel((LogVersionedStoreChannel)this.channel, this.logFile.extractHeader(this.channel.getLogVersion()));
        }

        public void locklessRotateLogFile(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, long lastAppendIndex, int previousChecksum) {
            throw new UnsupportedOperationException();
        }

        public void locklessRotateLogFile(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, long lastAppendIndex, int previousChecksum, LogFormat logFormat) {
            throw new UnsupportedOperationException();
        }

        public long rotationSize() {
            return this.rotateAtSize;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

