/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.logging.InternalLog;

public class DurationLogger
implements AutoCloseable {
    private final InternalLog log;
    private final String tag;
    private final long start;
    private String outcome = "Not finished";

    public DurationLogger(InternalLog log, String tag) {
        this.log = log;
        this.tag = tag;
        this.start = System.currentTimeMillis();
        log.debug("Started: %s", new Object[]{tag});
    }

    public void markAsFinished() {
        this.outcome = null;
    }

    public void markAsAborted(String cause) {
        this.outcome = "Aborted (cause: " + cause + ")";
    }

    @Override
    public void close() {
        long end = System.currentTimeMillis();
        long duration = end - this.start;
        if (this.outcome == null) {
            this.log.debug("Finished: %s in %d ms", new Object[]{this.tag, duration});
        } else {
            this.log.warn("%s: %s in %d ms", new Object[]{this.outcome, this.tag, duration});
        }
    }
}

