/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryTimespanThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdBasedPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.util.VisibleForTesting;

public class LogPruneStrategyFactory {
    static final LogPruneStrategy NO_PRUNING = new LogPruneStrategy(){

        @Override
        public LogPruneStrategy.VersionRange findLogVersionsToDelete(long upToLogVersion) {
            return LogPruneStrategy.EMPTY_RANGE;
        }

        public String toString() {
            return "keep_all";
        }
    };

    LogPruneStrategy strategyFromConfigValue(FileSystemAbstraction fileSystem, LogFiles logFiles, InternalLogProvider logProvider, Clock clock, String configValue) {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse(configValue);
        if (value == ThresholdConfigParser.ThresholdConfigValue.NO_PRUNING) {
            return NO_PRUNING;
        }
        Threshold thresholdToUse = LogPruneStrategyFactory.getThresholdByType(fileSystem, logProvider, clock, value, configValue);
        return new ThresholdBasedPruneStrategy(logFiles.getLogFile(), thresholdToUse);
    }

    @VisibleForTesting
    static Threshold getThresholdByType(FileSystemAbstraction fileSystem, InternalLogProvider logProvider, Clock clock, ThresholdConfigParser.ThresholdConfigValue configuredThreshold, String originalConfigValue) {
        long thresholdValue = configuredThreshold.value();
        return switch (configuredThreshold.type()) {
            case "files" -> new FileCountThreshold(thresholdValue, logProvider);
            case "size" -> new FileSizeThreshold(fileSystem, thresholdValue, logProvider);
            case "txs", "entries" -> new EntryCountThreshold(logProvider, thresholdValue);
            case "hours" -> LogPruneStrategyFactory.createTimeBasedThreshold(fileSystem, logProvider, clock, configuredThreshold, TimeUnit.HOURS);
            case "days" -> LogPruneStrategyFactory.createTimeBasedThreshold(fileSystem, logProvider, clock, configuredThreshold, TimeUnit.DAYS);
            default -> throw new IllegalArgumentException("Invalid log pruning configuration value '" + originalConfigValue + "'. Invalid type '" + configuredThreshold.type() + "', valid are files, size, txs, entries, hours, days.");
        };
    }

    private static EntryTimespanThreshold createTimeBasedThreshold(FileSystemAbstraction fileSystem, InternalLogProvider logProvider, Clock clock, ThresholdConfigParser.ThresholdConfigValue configuredThreshold, TimeUnit timeUnit) {
        if (configuredThreshold.hasAdditionalRestriction()) {
            return new EntryTimespanThreshold(logProvider, clock, timeUnit, configuredThreshold.value(), new FileSizeThreshold(fileSystem, configuredThreshold.additionalRestriction(), logProvider));
        }
        return new EntryTimespanThreshold(logProvider, clock, timeUnit, configuredThreshold.value());
    }
}

