/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.DefaultCursorFactory;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.InternalRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DefaultPooledCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;
    private final StoreCursors storeCursors;
    private final StorageEngineIndexingBehaviour indexingBehaviour;
    private final boolean applyAccessModeToTxState;
    private final DefaultCursorFactory cursorFactory;
    private DefaultNodeCursor nodeCursor;
    private DefaultNodeCursor fullAccessNodeCursor;
    private DefaultRelationshipScanCursor relationshipScanCursor;
    private DefaultRelationshipScanCursor fullAccessRelationshipScanCursor;
    private DefaultRelationshipTraversalCursor relationshipTraversalCursor;
    private DefaultRelationshipTraversalCursor fullAccessRelationshipTraversalCursor;
    private DefaultPropertyCursor propertyCursor;
    private PropertyCursor fullAccessPropertyCursor;
    private DefaultNodeValueIndexCursor nodeValueIndexCursor;
    private DefaultNodeLabelIndexCursor nodeLabelIndexCursor;
    private DefaultRelationshipValueIndexCursor relationshipValueIndexCursor;
    private DefaultNodeLabelIndexCursor fullAccessNodeLabelIndexCursor;
    private InternalRelationshipTypeIndexCursor relationshipTypeIndexCursor;
    private InternalRelationshipTypeIndexCursor fullAccessRelationshipTypeIndexCursor;

    public DefaultPooledCursors(StorageReader storageReader, StoreCursors storeCursors, Config config, StorageEngineIndexingBehaviour indexingBehaviour, boolean applyAccessModeToTxState) {
        this(storageReader, storeCursors, config, indexingBehaviour, applyAccessModeToTxState, DefaultCursorFactory.DEFAULT);
    }

    protected DefaultPooledCursors(StorageReader storageReader, StoreCursors storeCursors, Config config, StorageEngineIndexingBehaviour indexingBehaviour, boolean applyAccessModeToTxState, DefaultCursorFactory cursorFactory) {
        super(new ArrayList<DefaultCursors.CloseableStacktrace>(), config);
        this.storageReader = storageReader;
        this.storeCursors = storeCursors;
        this.indexingBehaviour = indexingBehaviour;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
        this.cursorFactory = cursorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNodeCursor allocateNodeCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.nodeCursor == null) {
            return this.trace(this.newNodeCursor(cursorContext, memoryTracker));
        }
        try {
            DefaultNodeCursor defaultNodeCursor = DefaultPooledCursors.acquire(this.nodeCursor);
            return defaultNodeCursor;
        }
        finally {
            this.nodeCursor = null;
        }
    }

    private DefaultNodeCursor newNodeCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return this.cursorFactory.nodeCursor(this::accept, this.storageReader.allocateNodeCursor(cursorContext, this.storeCursors, memoryTracker), this.newInternalCursors(cursorContext, memoryTracker), this.applyAccessModeToTxState);
    }

    private void accept(DefaultNodeCursor cursor) {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
        }
        cursor.removeTracer();
        this.nodeCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNodeCursor allocateFullAccessNodeCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessNodeCursor == null) {
            return this.trace(this.cursorFactory.fullAccessNodeCursor(this::acceptFullAccess, this.storageReader.allocateNodeCursor(cursorContext, this.storeCursors, memoryTracker)));
        }
        try {
            DefaultNodeCursor defaultNodeCursor = DefaultPooledCursors.acquire(this.fullAccessNodeCursor);
            return defaultNodeCursor;
        }
        finally {
            this.fullAccessNodeCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeCursor cursor) {
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessNodeCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipScanCursor == null) {
            StorageRelationshipScanCursor storeCursor = this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors, memoryTracker);
            InternalCursorFactory internalCursors = this.newInternalCursors(cursorContext, memoryTracker);
            return this.trace(this.cursorFactory.relationshipScanCursor(this::accept, storeCursor, internalCursors, this.applyAccessModeToTxState));
        }
        try {
            RelationshipScanCursor relationshipScanCursor = DefaultPooledCursors.acquire(this.relationshipScanCursor);
            return relationshipScanCursor;
        }
        finally {
            this.relationshipScanCursor = null;
        }
    }

    private void accept(DefaultRelationshipScanCursor cursor) {
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
        }
        cursor.removeTracer();
        this.relationshipScanCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRelationshipScanCursor allocateFullAccessRelationshipScanCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessRelationshipScanCursor == null) {
            return this.trace(this.cursorFactory.fullAccessRelationshipScanCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors, memoryTracker)));
        }
        try {
            DefaultRelationshipScanCursor defaultRelationshipScanCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipScanCursor);
            return defaultRelationshipScanCursor;
        }
        finally {
            this.fullAccessRelationshipScanCursor = null;
        }
    }

    private static <C extends TraceableCursor> C acquire(C cursor) {
        cursor.acquire();
        return cursor;
    }

    private void acceptFullAccess(DefaultRelationshipScanCursor cursor) {
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipScanCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipTraversalCursor == null) {
            return this.trace(this.cursorFactory.relationshipTraversalCursor(this::accept, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, this.storeCursors, memoryTracker), this.newInternalCursors(cursorContext, memoryTracker), this.applyAccessModeToTxState));
        }
        try {
            DefaultRelationshipTraversalCursor defaultRelationshipTraversalCursor = DefaultPooledCursors.acquire(this.relationshipTraversalCursor);
            return defaultRelationshipTraversalCursor;
        }
        finally {
            this.relationshipTraversalCursor = null;
        }
    }

    private void accept(DefaultRelationshipTraversalCursor cursor) {
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
        }
        cursor.removeTracer();
        this.relationshipTraversalCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessRelationshipTraversalCursor == null) {
            return this.trace(this.cursorFactory.fullAccessRelationshipTraversalCursor(this::acceptFullAccess, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, this.storeCursors, memoryTracker)));
        }
        try {
            RelationshipTraversalCursor relationshipTraversalCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipTraversalCursor);
            return relationshipTraversalCursor;
        }
        finally {
            this.fullAccessRelationshipTraversalCursor = null;
        }
    }

    private void acceptFullAccess(DefaultRelationshipTraversalCursor cursor) {
        if (this.fullAccessRelationshipTraversalCursor != null) {
            this.fullAccessRelationshipTraversalCursor.release();
        }
        cursor.removeTracer();
        this.fullAccessRelationshipTraversalCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyCursor allocatePropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.propertyCursor == null) {
            return this.trace(this.cursorFactory.propertyCursor(this::accept, this.storageReader.allocatePropertyCursor(cursorContext, this.storeCursors, memoryTracker), this.newInternalCursors(cursorContext, memoryTracker), this.applyAccessModeToTxState));
        }
        try {
            PropertyCursor propertyCursor = DefaultPooledCursors.acquire(this.propertyCursor);
            return propertyCursor;
        }
        finally {
            this.propertyCursor = null;
        }
    }

    private void accept(DefaultPropertyCursor cursor) {
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
        }
        cursor.removeTracer();
        this.propertyCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyCursor allocateFullAccessPropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessPropertyCursor == null) {
            return this.trace(this.cursorFactory.fullAccessPropertyCursor(this::acceptFullAccess, this.storageReader.allocatePropertyCursor(cursorContext, this.storeCursors, memoryTracker)));
        }
        try {
            PropertyCursor propertyCursor = (PropertyCursor)DefaultPooledCursors.acquire((TraceableCursor)this.fullAccessPropertyCursor);
            return propertyCursor;
        }
        finally {
            this.fullAccessPropertyCursor = null;
        }
    }

    private void acceptFullAccess(PropertyCursor cursor) {
        if (this.fullAccessPropertyCursor != null) {
            ((TraceableCursor)this.fullAccessPropertyCursor).release();
        }
        cursor.removeTracer();
        this.fullAccessPropertyCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeValueIndexCursor allocateNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.nodeValueIndexCursor == null) {
            return this.trace(this.cursorFactory.nodeValueIndexCursor(this::accept, this.newInternalCursors(cursorContext, memoryTracker), this.applyAccessModeToTxState));
        }
        try {
            NodeValueIndexCursor nodeValueIndexCursor = DefaultPooledCursors.acquire(this.nodeValueIndexCursor);
            return nodeValueIndexCursor;
        }
        finally {
            this.nodeValueIndexCursor = null;
        }
    }

    private void accept(DefaultNodeValueIndexCursor cursor) {
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.nodeValueIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNodeLabelIndexCursor allocateNodeLabelIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.nodeLabelIndexCursor == null) {
            return this.trace(this.cursorFactory.nodeLabelIndexCursor(this::accept, this.newInternalCursors(cursorContext, memoryTracker), this.applyAccessModeToTxState));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = DefaultPooledCursors.acquire(this.nodeLabelIndexCursor);
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.nodeLabelIndexCursor = null;
        }
    }

    private void accept(DefaultNodeLabelIndexCursor cursor) {
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
        }
        cursor.removeTracer();
        this.nodeLabelIndexCursor = cursor;
    }

    public DefaultNodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(CursorContext cursorContext) {
        if (this.fullAccessNodeLabelIndexCursor == null) {
            return this.trace(this.cursorFactory.fullAccessNodeLabelIndexCursor(this::acceptFullAccess));
        }
        try {
            DefaultNodeLabelIndexCursor defaultNodeLabelIndexCursor = DefaultPooledCursors.acquire(this.fullAccessNodeLabelIndexCursor);
            return defaultNodeLabelIndexCursor;
        }
        finally {
            this.fullAccessNodeLabelIndexCursor = null;
        }
    }

    private void acceptFullAccess(DefaultNodeLabelIndexCursor cursor) {
        if (this.fullAccessNodeLabelIndexCursor != null) {
            this.fullAccessNodeLabelIndexCursor.release();
        }
        this.fullAccessNodeLabelIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipValueIndexCursor allocateRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipValueIndexCursor == null) {
            InternalCursorFactory internalCursors = this.newInternalCursors(cursorContext, memoryTracker);
            StorageRelationshipScanCursor storeCursor = this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors, memoryTracker);
            DefaultRelationshipScanCursor relationshipScanCursor = this.cursorFactory.relationshipScanCursor(c -> {}, storeCursor, internalCursors, this.applyAccessModeToTxState);
            return this.trace(this.cursorFactory.relationshipValueIndexCursor(this::accept, relationshipScanCursor, internalCursors, this.applyAccessModeToTxState));
        }
        try {
            RelationshipValueIndexCursor relationshipValueIndexCursor = DefaultPooledCursors.acquire(this.relationshipValueIndexCursor);
            return relationshipValueIndexCursor;
        }
        finally {
            this.relationshipValueIndexCursor = null;
        }
    }

    public void accept(DefaultRelationshipValueIndexCursor cursor) {
        if (this.relationshipValueIndexCursor != null) {
            this.relationshipValueIndexCursor.release();
        }
        cursor.removeTracer();
        this.relationshipValueIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.relationshipTypeIndexCursor == null) {
            InternalCursorFactory internalCursors = this.newInternalCursors(cursorContext, memoryTracker);
            if (this.indexingBehaviour.useNodeIdsInRelationshipTokenIndex()) {
                DefaultRelationshipTraversalCursor relationshipTraversalCursor = this.cursorFactory.relationshipTraversalCursor(c -> {}, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, this.storeCursors, memoryTracker), internalCursors, this.applyAccessModeToTxState);
                return this.trace(this.cursorFactory.nodeBasedRelationshipTypeIndexCursor(this::accept, internalCursors.allocateNodeCursor(), relationshipTraversalCursor));
            }
            DefaultRelationshipScanCursor relationshipScanCursor = this.cursorFactory.relationshipScanCursor(c -> {}, this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors, memoryTracker), internalCursors, this.applyAccessModeToTxState);
            return this.trace(this.cursorFactory.relationshipBasedRelationshipTypeIndexCursor(this::accept, relationshipScanCursor, this.applyAccessModeToTxState));
        }
        try {
            RelationshipTypeIndexCursor relationshipTypeIndexCursor = DefaultPooledCursors.acquire(this.relationshipTypeIndexCursor);
            return relationshipTypeIndexCursor;
        }
        finally {
            this.relationshipTypeIndexCursor = null;
        }
    }

    private void accept(InternalRelationshipTypeIndexCursor cursor) {
        if (this.relationshipTypeIndexCursor != null) {
            this.relationshipTypeIndexCursor.release();
        }
        cursor.removeTracer();
        this.relationshipTypeIndexCursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipTypeIndexCursor allocateFullAccessRelationshipTypeIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (this.fullAccessRelationshipTypeIndexCursor == null) {
            if (this.indexingBehaviour.useNodeIdsInRelationshipTokenIndex()) {
                DefaultNodeCursor nodeCursor = this.cursorFactory.fullAccessNodeCursor(c -> {}, this.storageReader.allocateNodeCursor(cursorContext, this.storeCursors, memoryTracker));
                DefaultRelationshipTraversalCursor relationshipTraversalCursor = this.cursorFactory.fullAccessRelationshipTraversalCursor(c -> {}, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, this.storeCursors, memoryTracker));
                return this.trace(this.cursorFactory.fullAccessNodeBasedRelationshipTypeIndexCursor(this::acceptFullAccess, nodeCursor, relationshipTraversalCursor));
            }
            DefaultRelationshipScanCursor relationshipScanCursor = this.cursorFactory.fullAccessRelationshipScanCursor(c -> {}, this.storageReader.allocateRelationshipScanCursor(cursorContext, this.storeCursors, memoryTracker));
            return this.trace(this.cursorFactory.fullAccessRelationshipBasedRelationshipTypeIndexCursor(this::acceptFullAccess, relationshipScanCursor));
        }
        try {
            RelationshipTypeIndexCursor relationshipTypeIndexCursor = DefaultPooledCursors.acquire(this.fullAccessRelationshipTypeIndexCursor);
            return relationshipTypeIndexCursor;
        }
        finally {
            this.fullAccessRelationshipTypeIndexCursor = null;
        }
    }

    private void acceptFullAccess(InternalRelationshipTypeIndexCursor cursor) {
        if (this.fullAccessRelationshipTypeIndexCursor != null) {
            this.fullAccessRelationshipTypeIndexCursor.release();
        }
        this.fullAccessRelationshipTypeIndexCursor = cursor;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.release();
        }
        if (this.fullAccessNodeCursor != null) {
            this.fullAccessNodeCursor.release();
        }
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.release();
        }
        if (this.fullAccessRelationshipScanCursor != null) {
            this.fullAccessRelationshipScanCursor.release();
        }
        if (this.relationshipTraversalCursor != null) {
            this.relationshipTraversalCursor.release();
        }
        if (this.fullAccessRelationshipTraversalCursor != null) {
            this.fullAccessRelationshipTraversalCursor.release();
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.release();
        }
        if (this.fullAccessPropertyCursor != null) {
            ((TraceableCursor)this.fullAccessPropertyCursor).release();
        }
        if (this.nodeValueIndexCursor != null) {
            this.nodeValueIndexCursor.release();
        }
        if (this.nodeLabelIndexCursor != null) {
            this.nodeLabelIndexCursor.release();
        }
        if (this.fullAccessNodeLabelIndexCursor != null) {
            this.fullAccessNodeLabelIndexCursor.release();
        }
        if (this.relationshipValueIndexCursor != null) {
            this.relationshipValueIndexCursor.release();
        }
        if (this.relationshipTypeIndexCursor != null) {
            this.relationshipTypeIndexCursor.release();
        }
        if (this.fullAccessRelationshipTypeIndexCursor != null) {
            this.fullAccessRelationshipTypeIndexCursor.release();
        }
        this.nodeCursor = null;
        this.fullAccessNodeCursor = null;
        this.relationshipScanCursor = null;
        this.fullAccessRelationshipScanCursor = null;
        this.relationshipTraversalCursor = null;
        this.fullAccessRelationshipTraversalCursor = null;
        this.propertyCursor = null;
        this.fullAccessPropertyCursor = null;
        this.nodeValueIndexCursor = null;
        this.nodeLabelIndexCursor = null;
        this.fullAccessNodeLabelIndexCursor = null;
        this.relationshipValueIndexCursor = null;
        this.relationshipTypeIndexCursor = null;
        this.fullAccessRelationshipTypeIndexCursor = null;
    }

    private InternalCursorFactory newInternalCursors(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return this.cursorFactory.internalCursors(this.storageReader, this.storeCursors, cursorContext, memoryTracker, this.applyAccessModeToTxState);
    }
}

