/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public class WorkSyncedIndexPopulator
extends IndexPopulator.Delegating {
    private final WorkSync<IndexUpdateApply, IndexUpdateWork> workSync = new WorkSync((Object)new IndexUpdateApply());

    public WorkSyncedIndexPopulator(IndexPopulator delegate) {
        super(delegate);
    }

    public void add(Collection<? extends IndexEntryUpdate> updates, CursorContext cursorContext) throws IndexEntryConflictException {
        if (updates.isEmpty()) {
            return;
        }
        try {
            this.workSync.apply((Work)new IndexUpdateWork(updates, cursorContext));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw new UncheckedIOException((IOException)cause);
            }
            if (cause instanceof IndexEntryConflictException) {
                throw (IndexEntryConflictException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private class IndexUpdateApply {
        private IndexUpdateApply() {
        }

        void process(Collection<? extends IndexEntryUpdate> indexEntryUpdates, CursorContext cursorContext) throws Exception {
            WorkSyncedIndexPopulator.super.add(indexEntryUpdates, cursorContext);
        }
    }

    private static class IndexUpdateWork
    implements Work<IndexUpdateApply, IndexUpdateWork> {
        private final List<OneWork> works = new ArrayList<OneWork>(1);

        IndexUpdateWork(Collection<? extends IndexEntryUpdate> updates, CursorContext cursorContext) {
            this.works.add(new OneWork(updates, cursorContext));
        }

        public IndexUpdateWork combine(IndexUpdateWork work) {
            this.works.addAll(work.works);
            return this;
        }

        public void apply(IndexUpdateApply indexUpdateApply) throws Exception {
            for (OneWork work : this.works) {
                indexUpdateApply.process(work.updates, work.cursorContext);
            }
        }

        record OneWork(Collection<? extends IndexEntryUpdate> updates, CursorContext cursorContext) {
        }
    }
}

