/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.TransactionTerminatedHelper;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.internal.helpers.collection.AbstractResourceIterable;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.connectioninfo.RoutingInfo;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextNode;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureKernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextRelationship;
import org.neo4j.kernel.impl.coreapi.DataLookup;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.coreapi.internal.CursorIterator;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.ElementIdMapper;

public class ExecutionContextProcedureTransaction
extends DataLookup
implements InternalTransaction {
    private final ExecutionContext executionContext;
    private final ExecutionContextProcedureKernelTransaction ktx;
    private final RoutingInfo routingInfo;

    public ExecutionContextProcedureTransaction(ExecutionContextProcedureKernelTransaction ktx, RoutingInfo routingInfo) {
        this.executionContext = ktx.executionContext();
        this.ktx = ktx;
        this.routingInfo = routingInfo;
    }

    public Node createNode() {
        throw new UnsupportedOperationException("Write operations are unsupported during parallel execution");
    }

    public Node createNode(Label ... labels) {
        throw new UnsupportedOperationException("Write operations are unsupported during parallel execution");
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        throw new UnsupportedOperationException("Traversal operations are unsupported during parallel execution");
    }

    public TraversalDescription traversalDescription() {
        throw new UnsupportedOperationException("Traversal operations are unsupported during parallel execution");
    }

    public Result execute(String query) throws QueryExecutionException {
        throw new UnsupportedOperationException("Execution of other queries is unsupported during parallel execution");
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        throw new UnsupportedOperationException("Execution of other queries is unsupported during parallel execution");
    }

    public ResourceIterable<Node> getAllNodes() {
        AbstractResourceIterable<Node> result = new AbstractResourceIterable<Node>(){

            protected ResourceIterator<Node> newIterator() {
                NodeCursor cursor = ExecutionContextProcedureTransaction.this.cursors().allocateNodeCursor(ExecutionContextProcedureTransaction.this.cursorContext(), ExecutionContextProcedureTransaction.this.memoryTracker());
                ExecutionContextProcedureTransaction.this.dataRead().allNodesScan(cursor);
                return new CursorIterator<NodeCursor, Node>(cursor, NodeCursor::nodeReference, c -> ExecutionContextProcedureTransaction.this.newNodeEntity(c.nodeReference()));
            }

            protected void onClosed() {
                ExecutionContextProcedureTransaction.this.executionContext.unregisterCloseableResource((AutoCloseable)((Object)this));
            }
        };
        this.executionContext.registerCloseableResource((AutoCloseable)result);
        return result;
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        AbstractResourceIterable<Relationship> result = new AbstractResourceIterable<Relationship>(){

            protected ResourceIterator<Relationship> newIterator() {
                RelationshipScanCursor cursor = ExecutionContextProcedureTransaction.this.cursors().allocateRelationshipScanCursor(ExecutionContextProcedureTransaction.this.cursorContext(), ExecutionContextProcedureTransaction.this.memoryTracker());
                ExecutionContextProcedureTransaction.this.dataRead().allRelationshipsScan(cursor);
                return new CursorIterator<RelationshipScanCursor, Relationship>(cursor, RelationshipCursor::relationshipReference, c -> ExecutionContextProcedureTransaction.this.newRelationshipEntity(c.relationshipReference()));
            }

            protected void onClosed() {
                ExecutionContextProcedureTransaction.this.executionContext.unregisterCloseableResource((AutoCloseable)((Object)this));
            }
        };
        this.executionContext.registerCloseableResource((AutoCloseable)result);
        return result;
    }

    public Lock acquireWriteLock(Entity entity) {
        throw new UnsupportedOperationException("Acquiring locks is unsupported during parallel execution.");
    }

    public Lock acquireReadLock(Entity entity) {
        throw new UnsupportedOperationException("Acquiring locks is unsupported during parallel execution.");
    }

    public Schema schema() {
        return new SchemaImpl(this.kernelTransaction());
    }

    public void terminate() {
        throw new UnsupportedOperationException("Terminating ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public void commit() {
        throw new UnsupportedOperationException("Committing ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public void rollback() {
        throw new UnsupportedOperationException("Rolling back ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public void close() {
        throw new UnsupportedOperationException("Closing ongoing transaction inside of a procedure or a function is unsupported.");
    }

    @Override
    protected TokenRead tokenRead() {
        return this.executionContext.tokenRead();
    }

    @Override
    protected SchemaRead schemaRead() {
        return this.executionContext.schemaRead();
    }

    @Override
    protected Read dataRead() {
        return this.executionContext.dataRead();
    }

    @Override
    protected ResourceMonitor resourceMonitor() {
        return this.executionContext;
    }

    @Override
    public Node newNodeEntity(long nodeId) {
        return new ExecutionContextNode(nodeId, this.executionContext);
    }

    public RelationshipType getRelationshipTypeById(int type) {
        try {
            return RelationshipType.withName((String)this.executionContext.tokenRead().relationshipTypeName(type));
        }
        catch (KernelException e) {
            throw new IllegalStateException("Kernel API returned non-existent relationship type: " + type, e);
        }
    }

    @Override
    public Relationship newRelationshipEntity(long relationshipId) {
        return new ExecutionContextRelationship(relationshipId, this.executionContext);
    }

    public Relationship newRelationshipEntity(String elementId) {
        return new ExecutionContextRelationship(this.elementIdMapper().relationshipId(elementId), this.executionContext);
    }

    @Override
    public Relationship newRelationshipEntity(long id, long startNodeId, int typeId, long endNodeId) {
        return this.newRelationshipEntity(id);
    }

    public Relationship newRelationshipEntity(RelationshipCursor cursor) {
        return this.newRelationshipEntity(cursor.relationshipReference());
    }

    @Override
    protected CursorFactory cursors() {
        return this.executionContext.cursors();
    }

    @Override
    protected CursorContext cursorContext() {
        return this.executionContext.cursorContext();
    }

    @Override
    protected MemoryTracker memoryTracker() {
        return this.executionContext.memoryTracker();
    }

    @Override
    protected QueryContext queryContext() {
        return this.executionContext.queryContext();
    }

    public SecurityContext securityContext() {
        return this.executionContext.securityContext();
    }

    public void setTransaction(KernelTransaction transaction) {
        throw ExecutionContextProcedureKernelTransaction.failure("setTransaction");
    }

    public KernelTransaction kernelTransaction() {
        this.checkInTransaction();
        return this.ktx;
    }

    public KernelTransaction.Type transactionType() {
        return this.ktx.transactionType();
    }

    public ClientConnectionInfo clientInfo() {
        return this.ktx.clientInfo();
    }

    public RoutingInfo routingInfo() {
        return this.routingInfo;
    }

    public List<String> bookmarks() {
        InternalTransaction internalTransaction = this.ktx.internalTransaction();
        if (internalTransaction != null) {
            return internalTransaction.bookmarks();
        }
        return Collections.emptyList();
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        return this.ktx.overrideWith(context);
    }

    public Optional<Status> terminationReason() {
        return this.ktx.getReasonIfTerminated();
    }

    public void setMetaData(Map<String, Object> txMeta) {
        this.ktx.setMetaData(txMeta);
    }

    public void checkInTransaction() {
        if (this.ktx.isTerminated()) {
            Status terminationReason = (Status)this.ktx.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
            throw TransactionTerminatedHelper.transactionTerminated((Status)terminationReason);
        }
    }

    public boolean isOpen() {
        return this.ktx.isOpen();
    }

    public void terminate(Status reason) {
        this.terminate();
    }

    public UUID getDatabaseId() {
        return this.ktx.getDatabaseId();
    }

    public String getDatabaseName() {
        return this.ktx.getDatabaseName();
    }

    public Entity validateSameDB(Entity entity) {
        return TransactionImpl.validateSameDB(this, entity);
    }

    @Override
    public ElementIdMapper elementIdMapper() {
        return this.executionContext.elementIdMapper();
    }

    public void commit(KernelTransaction.Monitor monitor) {
        this.commit();
    }

    @Override
    protected void performCheckBeforeOperation() {
        this.executionContext.performCheckBeforeOperation();
    }

    public void registerCloseableResource(AutoCloseable closeableResource) {
        this.executionContext.registerCloseableResource(closeableResource);
    }

    public void unregisterCloseableResource(AutoCloseable closeableResource) {
        this.executionContext.unregisterCloseableResource(closeableResource);
    }
}

