/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Locale;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;

public final class RelationshipEndpointLabelMissingLabelException
extends ConstraintValidationException {
    private final long relationshipReference;
    private final RelationshipEndpointLabelConstraintDescriptor descriptor;
    private final long nodeReference;

    private RelationshipEndpointLabelMissingLabelException(ErrorGqlStatusObject gqlStatusObject, RelationshipEndpointLabelConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long relationshipReference, long nodeReference, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (ConstraintDescriptor)descriptor, phase, "Relationship(" + relationshipReference + ")", tokenNameLookup);
        this.relationshipReference = relationshipReference;
        this.descriptor = descriptor;
        this.nodeReference = nodeReference;
    }

    public static RelationshipEndpointLabelMissingLabelException endpointLabelPresenceVerificationFailed(RelationshipEndpointLabelConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long relationshipReference, long nodeReference, TokenNameLookup tokenNameLookup) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB4).withParam(GqlParams.NumberParam.entityId1, (Number)relationshipReference).withParam(GqlParams.StringParam.relType, tokenNameLookup.relationshipTypeGetName(descriptor.schema().getRelTypeId())).withParam(GqlParams.StringParam.endpointType, descriptor.endpointType().name().toLowerCase(Locale.ROOT)).withParam(GqlParams.NumberParam.entityId2, (Number)nodeReference).withParam(GqlParams.StringParam.label, tokenNameLookup.labelGetName(descriptor.endpointLabelId())).build();
        return new RelationshipEndpointLabelMissingLabelException(gql, descriptor, phase, relationshipReference, nodeReference, tokenNameLookup);
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Relationship(%s) with type %s requires it's %s Node(%s) to have label %s", this.relationshipReference, tokenNameLookup.relationshipTypeGetName(this.descriptor.schema().getRelTypeId()), this.descriptor.endpointType().name().toLowerCase(Locale.ROOT), this.nodeReference, tokenNameLookup.labelGetName(this.descriptor.endpointLabelId()));
    }
}

