/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Resource;

public class StoreCopyCheckPointMutex {
    private final ReadWriteLock lock;
    private int storeCopyCount;
    private volatile Throwable storeCopyActionError;

    public StoreCopyCheckPointMutex() {
        this(new ReentrantReadWriteLock(true));
    }

    public StoreCopyCheckPointMutex(ReadWriteLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource storeCopy(ThrowingAction<IOException> beforeFirstConcurrentStoreCopy) throws IOException {
        boolean storeCopier;
        Lock writeLock = this.lock.writeLock();
        Lock readLock = this.lock.readLock();
        StoreCopyCheckPointMutex storeCopyCheckPointMutex = this;
        synchronized (storeCopyCheckPointMutex) {
            boolean bl = storeCopier = this.incrementCount() == 0;
            if (storeCopier) {
                writeLock.lock();
                readLock.lock();
            } else {
                this.followerLock(readLock);
            }
        }
        boolean success = false;
        try {
            if (storeCopier) {
                try {
                    beforeFirstConcurrentStoreCopy.apply();
                }
                catch (IOException e) {
                    this.storeCopyActionError = e;
                    throw e;
                }
                catch (Throwable e) {
                    this.storeCopyActionError = e;
                    throw new IOException(e);
                }
                finally {
                    writeLock.unlock();
                }
            } else if (this.storeCopyActionError != null) {
                throw new IOException("Co-operative action before store-copy failed", this.storeCopyActionError);
            }
            success = true;
        }
        finally {
            if (!success) {
                readLock.unlock();
                this.decrementCount();
            }
        }
        return () -> {
            this.decrementCount();
            readLock.unlock();
        };
    }

    private void followerLock(Lock readLock) {
        readLock.lock();
    }

    private synchronized void decrementCount() {
        --this.storeCopyCount;
        if (this.storeCopyCount == 0) {
            this.storeCopyActionError = null;
        }
    }

    private synchronized int incrementCount() {
        return this.storeCopyCount++;
    }

    public Resource tryCheckPoint() {
        Lock writeLock = this.lock.writeLock();
        return writeLock.tryLock() ? writeLock::unlock : null;
    }

    public Resource tryCheckPoint(BooleanSupplier timeoutPredicate) {
        Lock writeLock = this.lock.writeLock();
        long waitTimeMillis = 0L;
        try {
            while (!writeLock.tryLock(waitTimeMillis, TimeUnit.MILLISECONDS)) {
                if (timeoutPredicate.getAsBoolean()) {
                    return null;
                }
                waitTimeMillis = 100L;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        return writeLock::unlock;
    }

    public Resource checkPoint() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        return writeLock::unlock;
    }
}

