/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.schema.text.TextIndexProvider;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexProvider;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexProvider;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class StaticIndexProviderMap
extends LifecycleAdapter
implements IndexProviderMap {
    private final Map<IndexProviderDescriptor, IndexProvider> indexProvidersByDescriptor = new HashMap<IndexProviderDescriptor, IndexProvider>();
    private final Map<String, IndexProvider> indexProvidersByName = new HashMap<String, IndexProvider>();
    private final Map<IndexType, List<IndexProvider>> indexProvidersByType = new HashMap<IndexType, List<IndexProvider>>();
    private final IndexProvider tokenIndexProvider;
    private final IndexProvider rangeIndexProvider;
    private final IndexProvider pointIndexProvider;
    private final IndexProvider textIndexProvider;
    private final IndexProvider trigramIndexProvider;
    private final IndexProvider fulltextIndexProvider;
    private final IndexProvider vectorV1IndexProvider;
    private final IndexProvider vectorV2IndexProvider;
    private final DependencyResolver dependencies;

    public StaticIndexProviderMap(TokenIndexProvider tokenIndexProvider, RangeIndexProvider rangeIndexProvider, PointIndexProvider pointIndexProvider, TextIndexProvider textIndexProvider, TrigramIndexProvider trigramIndexProvider, FulltextIndexProvider fulltextIndexProvider, VectorIndexProvider vectorV1IndexProvider, VectorIndexProvider vectorV2IndexProvider, DependencyResolver dependencies) {
        this.tokenIndexProvider = tokenIndexProvider;
        this.rangeIndexProvider = rangeIndexProvider;
        this.pointIndexProvider = pointIndexProvider;
        this.textIndexProvider = textIndexProvider;
        this.trigramIndexProvider = trigramIndexProvider;
        this.fulltextIndexProvider = fulltextIndexProvider;
        this.vectorV1IndexProvider = vectorV1IndexProvider;
        this.vectorV2IndexProvider = vectorV2IndexProvider;
        this.dependencies = dependencies;
    }

    public void init() throws Exception {
        this.add(this.tokenIndexProvider, this.rangeIndexProvider, this.pointIndexProvider, this.textIndexProvider, this.trigramIndexProvider, this.fulltextIndexProvider, this.vectorV1IndexProvider, this.vectorV2IndexProvider);
        this.dependencies.resolveTypeDependencies(IndexProvider.class).forEach(this::add);
    }

    public IndexProvider getTokenIndexProvider() {
        return this.tokenIndexProvider;
    }

    public IndexProvider getDefaultProvider() {
        return this.rangeIndexProvider;
    }

    public IndexProvider getPointIndexProvider() {
        return this.pointIndexProvider;
    }

    public IndexProvider getTextIndexProvider() {
        return this.trigramIndexProvider;
    }

    public IndexProvider getFulltextProvider() {
        return this.fulltextIndexProvider;
    }

    public IndexProvider getVectorIndexProvider() {
        return this.vectorV2IndexProvider != null ? this.vectorV2IndexProvider : this.vectorV1IndexProvider;
    }

    public IndexProvider lookup(IndexProviderDescriptor providerDescriptor) {
        IndexProvider provider = this.indexProvidersByDescriptor.get(providerDescriptor);
        this.assertProviderFound(provider, providerDescriptor.name());
        return provider;
    }

    public IndexProvider lookup(String providerDescriptorName) {
        IndexProvider provider = this.indexProvidersByName.get(providerDescriptorName);
        this.assertProviderFound(provider, providerDescriptorName);
        return provider;
    }

    public List<IndexProvider> lookup(IndexType indexType) {
        List<IndexProvider> indexProviders = this.indexProvidersByType.get(indexType);
        this.assertProviderFoundByType(indexProviders, indexType);
        return indexProviders;
    }

    public void accept(Consumer<IndexProvider> visitor) {
        this.indexProvidersByDescriptor.values().forEach(visitor);
    }

    private void assertProviderFound(IndexProvider provider, String providerDescriptorName) {
        if (provider == null) {
            throw new IndexProviderNotFoundException("Tried to get index provider with name " + providerDescriptorName + " whereas available providers in this session being " + String.valueOf(this.indexProvidersByName.keySet()) + ", and default being " + this.rangeIndexProvider.getProviderDescriptor().name());
        }
    }

    private void assertProviderFoundByType(List<IndexProvider> indexProviders, IndexType indexType) {
        if (indexProviders == null) {
            List<String> providerNamesByType = this.indexProvidersByType.entrySet().stream().map(entry -> {
                IndexType type = (IndexType)entry.getKey();
                List providers = (List)entry.getValue();
                return String.valueOf(type) + "=" + String.valueOf(providers.stream().map(provider -> provider.getProviderDescriptor().name()).toList());
            }).toList();
            throw new IndexProviderNotFoundException("Tried to get index providers for index type " + String.valueOf(indexType) + " but could not find any. Available index providers per type are " + String.valueOf(providerNamesByType));
        }
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        IndexProviderDescriptor providerDescriptor = index.getIndexProvider();
        IndexProvider provider = this.lookup(providerDescriptor);
        return provider.completeConfiguration(index, indexingBehaviour);
    }

    private void add(IndexProvider provider) {
        if (provider == null) {
            return;
        }
        IndexProviderDescriptor providerDescriptor = Objects.requireNonNull(provider.getProviderDescriptor());
        IndexProvider existing = this.indexProvidersByDescriptor.putIfAbsent(providerDescriptor, provider);
        if (existing != null) {
            throw new IllegalArgumentException("Tried to load multiple schema index providers with the same provider descriptor " + String.valueOf(providerDescriptor) + ". First loaded " + String.valueOf(existing) + " then " + String.valueOf(provider));
        }
        this.indexProvidersByName.putIfAbsent(providerDescriptor.name(), provider);
        this.indexProvidersByType.computeIfAbsent(provider.getIndexType(), it -> new ArrayList()).add(provider);
    }

    private void add(IndexProvider ... providers) {
        for (IndexProvider provider : providers) {
            this.add(provider);
        }
    }
}

