/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.api.exceptions.Status;

public class EquivalentSchemaRuleAlreadyExistsException
extends SchemaKernelException {
    private static final String EQUIVALENT_INDEX = "An equivalent index already exists, '%s'.";
    private static final String EQUIVALENT_CONSTRAINT = "An equivalent constraint already exists, '%s'.";

    private EquivalentSchemaRuleAlreadyExistsException(String message, ErrorGqlStatusObject gqlStatusObject) {
        super(gqlStatusObject, (Status)Status.Schema.EquivalentSchemaRuleAlreadyExists, message);
    }

    public static EquivalentSchemaRuleAlreadyExistsException cannotCreateConstraint(SchemaRule schemaRule, TokenNameLookup tokenNameLookup) {
        String name = schemaRule.getName();
        String userDescription = schemaRule.userDescription(tokenNameLookup);
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N65).withParam(GqlParams.StringParam.constrDescrOrName, name).build();
        String message = String.format(EQUIVALENT_CONSTRAINT, userDescription);
        return new EquivalentSchemaRuleAlreadyExistsException(message, gql);
    }

    public static EquivalentSchemaRuleAlreadyExistsException cannotCreateIndex(SchemaRule schemaRule, TokenNameLookup tokenNameLookup) {
        String name = schemaRule.getName();
        String userDescription = schemaRule.userDescription(tokenNameLookup);
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N70).withParam(GqlParams.StringParam.idxDescrOrName, name).build();
        String message = String.format(EQUIVALENT_INDEX, userDescription);
        return new EquivalentSchemaRuleAlreadyExistsException(message, gql);
    }
}

