/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.Status;

public class DropConstraintFailureException
extends SchemaKernelException {
    private final SchemaDescriptorSupplier constraint;
    private final String nameOrSchema;

    private DropConstraintFailureException(ErrorGqlStatusObject gqlStatusObject, SchemaDescriptorSupplier constraint, Throwable cause) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintDropFailed, cause, "Unable to drop constraint: " + cause.getMessage(), new Object[0]);
        this.constraint = constraint;
        this.nameOrSchema = null;
    }

    private DropConstraintFailureException(ErrorGqlStatusObject gqlStatusObject, String nameOrSchema, Throwable cause) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintDropFailed, cause, "Unable to drop constraint `" + nameOrSchema + "`: " + cause.getMessage(), new Object[0]);
        this.nameOrSchema = nameOrSchema;
        this.constraint = null;
    }

    public static DropConstraintFailureException constraintDropFailed(String constraintName, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N12).withParam(GqlParams.StringParam.constrDescrOrName, constraintName).build();
        return new DropConstraintFailureException(gql, constraintName, cause);
    }

    public static DropConstraintFailureException constraintDropFailed(ConstraintDescriptor constraint, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N12).withParam(GqlParams.StringParam.constrDescrOrName, constraint.getName()).build();
        return new DropConstraintFailureException(gql, (SchemaDescriptorSupplier)constraint, cause);
    }

    public static DropConstraintFailureException constraintDropFailedForDependentConstraint(ConstraintDescriptor constraint) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N12).withParam(GqlParams.StringParam.constrDescrOrName, constraint.getName()).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N68).build()).build();
        return new DropConstraintFailureException(gql, (SchemaDescriptorSupplier)constraint, (Throwable)new IllegalStateException("Cannot drop dependent constraint"));
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        String message;
        if (this.constraint != null) {
            message = "Unable to drop constraint on " + this.constraint.userDescription(tokenNameLookup) + ": ";
        } else if (this.nameOrSchema != null) {
            message = "Unable to drop constraint `" + this.nameOrSchema + "`: ";
        } else {
            return this.getMessage();
        }
        Throwable cause = this.getCause();
        if (cause instanceof KernelException) {
            KernelException exception = (KernelException)cause;
            message = message + exception.getUserMessage(tokenNameLookup);
        } else {
            message = message + cause.getMessage();
        }
        return message;
    }
}

