/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.tracer;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.tracer.CountingLogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.log.AppendTransactionEvent;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogFileCreateEvent;
import org.neo4j.kernel.impl.transaction.log.LogFileFlushEvent;
import org.neo4j.kernel.impl.transaction.log.LogForceEvent;
import org.neo4j.kernel.impl.transaction.log.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.log.rotation.CountingLogRotateEvent;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.RollbackBatchEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionRollbackEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;

public class DefaultDatabaseTracer
implements DatabaseTracer {
    private final LongAdder appendedBytes = new LongAdder();
    private final LongAdder numberOfFlushes = new LongAdder();
    private final LongAdder batchesAppended = new LongAdder();
    private final LongAdder batchesRolledBack = new LongAdder();
    private final LongAdder batchTransactionsRolledBack = new LongAdder();
    private final AtomicLong appliedBatchSize = new AtomicLong();
    private final CountingLogRotateEvent countingLogRotateEvent = new CountingLogRotateEvent();
    private final LogFileCreateEvent logFileCreateEvent = new DefaultLogFileCreateEvent();
    private final LogFileFlushEvent logFileFlushEvent = this.numberOfFlushes::increment;
    private final LogAppendEvent logAppendEvent = new DefaultLogAppendEvent();
    private final TransactionWriteEvent transactionWriteEvent = new DefaultTransactionWriteEvent();
    private final TransactionRollbackEvent transactionRollbackEvent = new DefaultTransactionRollbackEvent();
    private final TransactionEvent transactionEvent = new DefaultTransactionEvent();
    private final CountingLogCheckPointEvent logCheckPointEvent;

    public DefaultDatabaseTracer(PageCacheTracer pageCacheTracer) {
        this.logCheckPointEvent = new CountingLogCheckPointEvent(pageCacheTracer, this.appendedBytes, this.countingLogRotateEvent);
    }

    @Override
    public TransactionEvent beginTransaction(CursorContext cursorContext, long transactionSequenceNumber) {
        return this.transactionEvent;
    }

    @Override
    public TransactionWriteEvent beginAsyncCommit() {
        return this.transactionWriteEvent;
    }

    @Override
    public TransactionRollbackEvent beginAsyncRollback() {
        return this.transactionRollbackEvent;
    }

    public long appendedBytes() {
        return this.appendedBytes.longValue();
    }

    public long numberOfLogRotations() {
        return this.countingLogRotateEvent.numberOfLogRotations();
    }

    public long logRotationAccumulatedTotalTimeMillis() {
        return this.countingLogRotateEvent.logRotationAccumulatedTotalTimeMillis();
    }

    public long lastLogRotationTimeMillis() {
        return this.countingLogRotateEvent.lastLogRotationTimeMillis();
    }

    public long numberOfFlushes() {
        return this.numberOfFlushes.longValue();
    }

    public long lastTransactionLogAppendBatch() {
        return this.appliedBatchSize.longValue();
    }

    public long batchesAppended() {
        return this.batchesAppended.longValue();
    }

    public long rolledbackBatches() {
        return this.batchesRolledBack.longValue();
    }

    public long rolledbackBatchedTransactions() {
        return this.batchTransactionsRolledBack.longValue();
    }

    @Override
    public long numberOfCheckPoints() {
        return this.logCheckPointEvent.numberOfCheckPoints();
    }

    @Override
    public long checkPointAccumulatedTotalTimeMillis() {
        return this.logCheckPointEvent.checkPointAccumulatedTotalTimeMillis();
    }

    @Override
    public long lastCheckpointTimeMillis() {
        return this.logCheckPointEvent.lastCheckpointTimeMillis();
    }

    @Override
    public long lastCheckpointPagesFlushed() {
        return this.logCheckPointEvent.getPagesFlushed();
    }

    @Override
    public long lastCheckpointIOs() {
        return this.logCheckPointEvent.getIOsPerformed();
    }

    @Override
    public long lastCheckpointIOLimit() {
        return this.logCheckPointEvent.getConfiguredIOLimit();
    }

    @Override
    public long lastCheckpointIOLimitedTimes() {
        return this.logCheckPointEvent.getTimesPaused();
    }

    @Override
    public long lastCheckpointIOLimitedMillis() {
        return this.logCheckPointEvent.getMillisPaused();
    }

    @Override
    public long flushedBytes() {
        return this.logCheckPointEvent.flushedBytes();
    }

    @Override
    public LogCheckPointEvent beginCheckPoint() {
        return this.logCheckPointEvent;
    }

    public LogFileCreateEvent createLogFile() {
        return this.logFileCreateEvent;
    }

    public void openLogFile(Path filePath) {
    }

    public void closeLogFile(Path filePath) {
    }

    public LogAppendEvent logAppend() {
        return this.logAppendEvent;
    }

    public LogFileFlushEvent flushFile() {
        return this.logFileFlushEvent;
    }

    private class DefaultLogFileCreateEvent
    implements LogFileCreateEvent {
        private DefaultLogFileCreateEvent() {
        }

        public void fileCreated(long headerSize) {
            DefaultDatabaseTracer.this.appendedBytes.add(headerSize);
        }

        public void close() {
        }
    }

    private class DefaultLogAppendEvent
    implements LogAppendEvent {
        private DefaultLogAppendEvent() {
        }

        public void appendedBytes(long bytes) {
            DefaultDatabaseTracer.this.appendedBytes.add(bytes);
        }

        public void close() {
        }

        public void setLogRotated(boolean logRotated) {
        }

        public LogRotateEvent beginLogRotate() {
            return DefaultDatabaseTracer.this.countingLogRotateEvent;
        }

        public AppendTransactionEvent beginAppendTransaction(int appendItems) {
            DefaultDatabaseTracer.this.appliedBatchSize.set(appendItems);
            return AppendTransactionEvent.NULL;
        }

        public LogForceWaitEvent beginLogForceWait() {
            return LogForceWaitEvent.NULL;
        }

        public LogForceEvent beginLogForce() {
            return LogForceEvent.NULL;
        }
    }

    private class DefaultTransactionWriteEvent
    implements TransactionWriteEvent {
        private DefaultTransactionWriteEvent() {
        }

        @Override
        public void close() {
        }

        @Override
        public LogAppendEvent beginLogAppend() {
            return DefaultDatabaseTracer.this.logAppendEvent;
        }

        @Override
        public StoreApplyEvent beginStoreApply() {
            return StoreApplyEvent.NULL;
        }

        @Override
        public void chunkAppended(int chunkNumber, long transactionSequenceNumber, long transactionId) {
            DefaultDatabaseTracer.this.batchesAppended.increment();
        }
    }

    private class DefaultTransactionRollbackEvent
    implements TransactionRollbackEvent {
        private DefaultTransactionRollbackEvent() {
        }

        @Override
        public RollbackBatchEvent beginRollbackDataEvent() {
            return new RollbackBatchEvent(){

                @Override
                public void close() {
                    DefaultDatabaseTracer.this.batchTransactionsRolledBack.increment();
                }

                @Override
                public void batchedRolledBack(long rolledBackBatches, long transactionId) {
                    DefaultDatabaseTracer.this.batchesRolledBack.add(rolledBackBatches);
                }
            };
        }

        @Override
        public TransactionWriteEvent beginRollbackWriteEvent() {
            return DefaultDatabaseTracer.this.transactionWriteEvent;
        }

        @Override
        public void close() {
        }
    }

    public class DefaultTransactionEvent
    implements TransactionEvent {
        @Override
        public void setCommit(boolean commit) {
        }

        @Override
        public void setRollback(boolean rollback) {
        }

        @Override
        public TransactionWriteEvent beginCommitEvent() {
            return DefaultDatabaseTracer.this.transactionWriteEvent;
        }

        @Override
        public TransactionWriteEvent beginChunkWriteEvent() {
            return DefaultDatabaseTracer.this.transactionWriteEvent;
        }

        @Override
        public TransactionRollbackEvent beginRollback() {
            return DefaultDatabaseTracer.this.transactionRollbackEvent;
        }

        @Override
        public void close() {
        }

        @Override
        public void setTransactionWriteState(String transactionWriteState) {
        }

        @Override
        public void setReadOnly(boolean wasReadOnly) {
        }

        @Override
        public void refreshVisibilityBoundary() {
        }
    }
}

