/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DatabaseObjectRepositoryModelProvider;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class ModelBasedDatabaseIdRepository
implements DatabaseIdRepository {
    private static final Optional<NamedDatabaseId> NAMED_SYSTEM_DATABASE_ID = Optional.of(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
    private final DatabaseObjectRepositoryModelProvider modelProvider;

    public ModelBasedDatabaseIdRepository(DatabaseObjectRepositoryModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName normalizedDatabaseName) {
        if ("system".equals(normalizedDatabaseName.name())) {
            return NAMED_SYSTEM_DATABASE_ID;
        }
        return this.modelProvider.withModel(model -> model.getDatabaseIdByAlias(normalizedDatabaseName.name()));
    }

    public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
        if (DatabaseId.SYSTEM_DATABASE_ID.equals((Object)databaseId)) {
            return NAMED_SYSTEM_DATABASE_ID;
        }
        return this.modelProvider.withModel(model -> model.getDatabaseIdByUUID(databaseId.uuid()));
    }
}

