/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;

public class PhysicalTransactionCursor<T extends ReadableLogChannel>
implements TransactionCursor {
    private final T channel;
    private final LogEntryCursor logEntryCursor;
    private final LogPositionMarker lastGoodPositionMarker = new LogPositionMarker();
    private CommittedTransactionRepresentation current;

    public PhysicalTransactionCursor(T channel, LogEntryReader<T> entryReader) throws IOException {
        this.channel = channel;
        channel.getCurrentPosition(this.lastGoodPositionMarker);
        this.logEntryCursor = new LogEntryCursor(entryReader, (ReadableLogChannel)channel);
    }

    @Override
    public CommittedTransactionRepresentation get() {
        return this.current;
    }

    @Override
    public boolean next() throws IOException {
        LogEntry entry;
        while (true) {
            if (!this.logEntryCursor.next()) {
                return false;
            }
            entry = this.logEntryCursor.get();
            if (!(entry instanceof CheckPoint)) break;
            this.channel.getCurrentPosition(this.lastGoodPositionMarker);
        }
        assert (entry instanceof LogEntryStart) : "Expected Start entry, read " + entry + " instead";
        LogEntryStart startEntry = (LogEntryStart)entry.as();
        ArrayList<Command> entries = new ArrayList<Command>();
        while (true) {
            if (!this.logEntryCursor.next()) {
                return false;
            }
            entry = this.logEntryCursor.get();
            if (entry instanceof LogEntryCommit) break;
            LogEntryCommand command = (LogEntryCommand)entry.as();
            entries.add(command.getXaCommand());
        }
        LogEntryCommit commitEntry = (LogEntryCommit)entry.as();
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(entries);
        transaction.setHeader(startEntry.getAdditionalHeader(), startEntry.getMasterId(), startEntry.getLocalId(), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted(), commitEntry.getTimeWritten(), -1);
        this.current = new CommittedTransactionRepresentation(startEntry, transaction, commitEntry);
        this.channel.getCurrentPosition(this.lastGoodPositionMarker);
        return true;
    }

    @Override
    public void close() throws IOException {
        this.logEntryCursor.close();
    }

    @Override
    public LogPosition position() {
        return this.lastGoodPositionMarker.newPosition();
    }
}

