/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.cursor.GenericCursor;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicBlockSize;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.logging.LogProvider;

public abstract class AbstractDynamicStore
extends CommonAbstractStore
implements RecordStore<DynamicRecord>,
DynamicBlockSize,
DynamicRecordAllocator {
    private static final byte[] NO_DATA = new byte[0];
    public static final int BLOCK_HEADER_SIZE = 8;
    private final int blockSizeFromConfiguration;
    private int blockSize;

    public AbstractDynamicStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, int blockSizeFromConfiguration) {
        super(fileName, conf, idType, idGeneratorFactory, pageCache, logProvider);
        this.blockSizeFromConfiguration = blockSizeFromConfiguration;
    }

    public static int getRecordSize(int dataSize) {
        return dataSize + 8;
    }

    @Override
    protected void initialiseNewStoreFile(PagedFile file) throws IOException {
        int blockSize = this.blockSizeFromConfiguration;
        if (blockSize < 1 || blockSize > 65535) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "], limit is 65535");
        }
        blockSize += 8;
        try (PageCursor pageCursor = file.io(0L, 2);){
            if (pageCursor.next()) {
                do {
                    pageCursor.putInt(blockSize);
                } while (pageCursor.shouldRetry());
            }
        }
        File idFileName = new File(this.storageFileName.getPath() + ".id");
        this.idGeneratorFactory.create(idFileName, 0L, true);
        IdGenerator idGenerator = this.idGeneratorFactory.open(idFileName, this.idType, 0L);
        idGenerator.nextId();
        idGenerator.close();
    }

    public static void allocateRecordsFromBytes(Collection<DynamicRecord> recordList, byte[] src, Iterator<DynamicRecord> recordsToUseFirst, DynamicRecordAllocator dynamicRecordAllocator) {
        assert (src != null) : "Null src argument";
        DynamicRecord nextRecord = dynamicRecordAllocator.nextUsedRecordOrNew(recordsToUseFirst);
        int srcOffset = 0;
        int dataSize = dynamicRecordAllocator.dataSize();
        do {
            byte[] data;
            DynamicRecord record = nextRecord;
            record.setStartRecord(srcOffset == 0);
            if (src.length - srcOffset > dataSize) {
                data = new byte[dataSize];
                System.arraycopy(src, srcOffset, data, 0, dataSize);
                record.setData(data);
                nextRecord = dynamicRecordAllocator.nextUsedRecordOrNew(recordsToUseFirst);
                record.setNextBlock(nextRecord.getId());
                srcOffset += dataSize;
            } else {
                data = new byte[src.length - srcOffset];
                System.arraycopy(src, srcOffset, data, 0, data.length);
                record.setData(data);
                nextRecord = null;
                record.setNextBlock(Record.NO_NEXT_BLOCK.intValue());
            }
            recordList.add(record);
            assert (!record.isLight());
            assert (record.getData() != null);
        } while (nextRecord != null);
    }

    public static ByteBuffer concatData(Collection<DynamicRecord> records, byte[] target) {
        int totalLength = 0;
        for (DynamicRecord record : records) {
            totalLength += record.getLength();
        }
        if (target.length < totalLength) {
            target = new byte[totalLength];
        }
        ByteBuffer buffer = ByteBuffer.wrap(target, 0, totalLength);
        for (DynamicRecord record : records) {
            buffer.put(record.getData());
        }
        buffer.position(0);
        return buffer;
    }

    public static Pair<byte[], byte[]> readFullByteArrayFromHeavyRecords(Iterable<DynamicRecord> records, PropertyType propertyType) {
        int offset;
        byte[] header = null;
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        int totalSize = 0;
        int i = 0;
        for (DynamicRecord record : records) {
            offset = 0;
            if (i++ == 0) {
                header = propertyType.readDynamicRecordHeader(record.getData());
                offset = header.length;
            }
            byteList.add(record.getData());
            totalSize += record.getData().length - offset;
        }
        byte[] bArray = new byte[totalSize];
        assert (header != null) : "header should be non-null since records should not be empty: " + Iterables.toString(records, ", ");
        int sourceOffset = header.length;
        offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, sourceOffset, bArray, offset, currentArray.length - sourceOffset);
            offset += currentArray.length - sourceOffset;
            sourceOffset = 0;
        }
        return Pair.of(header, bArray);
    }

    @Override
    public DynamicRecord nextUsedRecordOrNew(Iterator<DynamicRecord> recordsToUseFirst) {
        DynamicRecord record;
        if (recordsToUseFirst.hasNext()) {
            record = recordsToUseFirst.next();
            if (!record.inUse()) {
                record.setCreated();
            }
        } else {
            record = new DynamicRecord(this.nextId());
            record.setCreated();
        }
        record.setInUse(true);
        return record;
    }

    @Override
    public int dataSize() {
        return this.getBlockSize() - 8;
    }

    @Override
    public int getRecordSize() {
        return this.getBlockSize();
    }

    @Override
    public int getRecordHeaderSize() {
        return 8;
    }

    @Override
    public int getNumberOfReservedLowIds() {
        return 1;
    }

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
        this.blockSize = this.getHeaderRecord();
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void updateRecord(DynamicRecord record) {
        long blockId = record.getId();
        long pageId = this.pageIdForRecord(blockId);
        try (PageCursor cursor = this.storeFile.io(pageId, 2);){
            if (cursor.next()) {
                do {
                    this.writeRecord(cursor, record);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void writeRecord(PageCursor cursor, DynamicRecord record) {
        long recordId = record.getId();
        int offset = this.offsetForId(recordId);
        cursor.setOffset(offset);
        if (record.inUse()) {
            long nextBlock = record.getNextBlock();
            int highByteInFirstInteger = nextBlock == (long)Record.NO_NEXT_BLOCK.intValue() ? 0 : (int)((nextBlock & 0xF00000000L) >> 8);
            highByteInFirstInteger |= Record.IN_USE.byteValue() << 28;
            highByteInFirstInteger |= (record.isStartRecord() ? 0 : 1) << 31;
            int firstInteger = record.getLength();
            assert (firstInteger < 0xFFFFFF);
            cursor.putInt(firstInteger |= highByteInFirstInteger);
            cursor.putInt((int)nextBlock);
            if (!record.isLight()) {
                cursor.putBytes(record.getData());
            }
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
            this.freeId(recordId);
        }
    }

    @Override
    public void forceUpdateRecord(DynamicRecord record) {
        this.updateRecord(record);
    }

    public void allocateRecordsFromBytes(Collection<DynamicRecord> target, byte[] src) {
        AbstractDynamicStore.allocateRecordsFromBytes(target, src, IteratorUtil.emptyIterator(), this);
    }

    public Collection<DynamicRecord> getLightRecords(long startBlockId) {
        return this.getRecords(startBlockId, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<DynamicRecord> getRecords(long startBlockId, boolean readBothHeaderAndData) {
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        long blockId = startBlockId;
        int noNextBlock = Record.NO_NEXT_BLOCK.intValue();
        try (PageCursor cursor = this.storeFile.io(0L, 1);){
            while (blockId != (long)noNextBlock && cursor.next(this.pageIdForRecord(blockId))) {
                HeaderReadResult headerReadResult;
                DynamicRecord record = new DynamicRecord(blockId);
                do {
                    cursor.setOffset(this.offsetForId(blockId));
                    headerReadResult = this.readRecordHeader(cursor, record, false);
                    if (headerReadResult != HeaderReadResult.DATA || !readBothHeaderAndData) continue;
                    this.readRecordData(cursor, record);
                } while (cursor.shouldRetry());
                this.checkForInUse(headerReadResult, record);
                this.checkForIllegalSize(headerReadResult, record);
                recordList.add(record);
                blockId = record.getNextBlock();
            }
            LinkedList<DynamicRecord> linkedList = recordList;
            return linkedList;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public DynamicRecordCursor newDynamicRecordCursor() {
        return new DynamicRecordCursor();
    }

    DynamicRecordCursor getRecordsCursor(long startBlockId) {
        return this.getRecordsCursor(startBlockId, this.newDynamicRecordCursor());
    }

    public DynamicRecordCursor getRecordsCursor(long startBlockId, DynamicRecordCursor dynamicRecordCursor) {
        try {
            PageCursor cursor = this.storeFile.io(0L, 1);
            dynamicRecordCursor.init(startBlockId, cursor);
            return dynamicRecordCursor;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void checkForInUse(HeaderReadResult headerReadResult, DynamicRecord record) {
        if (headerReadResult == HeaderReadResult.NOT_IN_USE) {
            throw new InvalidRecordException("DynamicRecord not in use, blockId[" + record.getId() + "]");
        }
    }

    private void checkForIllegalSize(HeaderReadResult headerReadResult, DynamicRecord record) {
        if (headerReadResult == HeaderReadResult.ILLEGAL_SIZE) {
            int dataSize = this.getBlockSize() - 8;
            throw new InvalidRecordException("Next block set[" + record.getNextBlock() + "] current block illegal size[" + record.getLength() + "/" + dataSize + "]");
        }
    }

    private HeaderReadResult readRecordHeader(PageCursor cursor, DynamicRecord record, boolean force) {
        boolean inUse;
        long firstInteger = cursor.getUnsignedInt();
        boolean isStartRecord = (firstInteger & Integer.MIN_VALUE) == 0L;
        long maskedInteger = firstInteger & Integer.MAX_VALUE;
        int highNibbleInMaskedInteger = (int)(maskedInteger >> 28);
        boolean bl = inUse = highNibbleInMaskedInteger == Record.IN_USE.intValue();
        if (!inUse && !force) {
            return HeaderReadResult.NOT_IN_USE;
        }
        int dataSize = this.getBlockSize() - 8;
        int nrOfBytes = (int)(firstInteger & 0xFFFFFFL);
        long nextBlock = cursor.getUnsignedInt();
        long nextModifier = (firstInteger & 0xF000000L) << 8;
        long longNextBlock = CommonAbstractStore.longFromIntAndMod(nextBlock, nextModifier);
        boolean hasDataToRead = true;
        record.setInUse(inUse);
        record.setStartRecord(isStartRecord);
        record.setLength(nrOfBytes);
        record.setNextBlock(longNextBlock);
        if (longNextBlock != (long)Record.NO_NEXT_BLOCK.intValue() && nrOfBytes < dataSize || nrOfBytes > dataSize) {
            hasDataToRead = false;
            if (!force) {
                return HeaderReadResult.ILLEGAL_SIZE;
            }
        }
        return hasDataToRead ? HeaderReadResult.DATA : HeaderReadResult.NO_DATA;
    }

    private void readRecordData(PageCursor cursor, DynamicRecord record) {
        int len = record.getLength();
        byte[] data = record.getData();
        if (data == null || data.length != len) {
            data = new byte[len];
        }
        cursor.getBytes(data);
        record.setData(data);
    }

    public void ensureHeavy(DynamicRecord record) {
        if (!record.isLight()) {
            return;
        }
        if (record.getLength() == 0) {
            record.setData(NO_DATA);
            return;
        }
        long pageId = this.pageIdForRecord(record.getId());
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            if (cursor.next()) {
                int offset = this.offsetForId(record.getId());
                do {
                    cursor.setOffset(offset + 8);
                    this.readRecordData(cursor, record);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DynamicRecord getRecord(long id) {
        DynamicRecord record = new DynamicRecord(id);
        long pageId = this.pageIdForRecord(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            HeaderReadResult headerReadResult = HeaderReadResult.NOT_IN_USE;
            if (cursor.next()) {
                int offset = this.offsetForId(record.getId());
                do {
                    cursor.setOffset(offset);
                    headerReadResult = this.readRecordHeader(cursor, record, false);
                    if (headerReadResult != HeaderReadResult.DATA) continue;
                    this.readRecordData(cursor, record);
                } while (cursor.shouldRetry());
            }
            this.checkForInUse(headerReadResult, record);
            this.checkForIllegalSize(headerReadResult, record);
            DynamicRecord dynamicRecord = record;
            return dynamicRecord;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DynamicRecord forceGetRecord(long id) {
        DynamicRecord record = new DynamicRecord(id);
        long pageId = this.pageIdForRecord(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            if (cursor.next()) {
                HeaderReadResult headerReadResult;
                int offset = this.offsetForId(record.getId());
                do {
                    cursor.setOffset(offset);
                    headerReadResult = this.readRecordHeader(cursor, record, true);
                    if (headerReadResult != HeaderReadResult.DATA) continue;
                    this.readRecordData(cursor, record);
                } while (cursor.shouldRetry());
                this.checkForIllegalSize(headerReadResult, record);
            }
            DynamicRecord dynamicRecord = record;
            return dynamicRecord;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public Collection<DynamicRecord> getRecords(long startBlockId) {
        return this.getRecords(startBlockId, true);
    }

    @Override
    protected boolean isInUse(byte inUseByte) {
        return (inUseByte & 0x10) >> 4 == Record.IN_USE.byteValue();
    }

    @Override
    public String toString() {
        return super.toString() + "[fileName:" + this.storageFileName.getName() + ", blockSize:" + (this.getRecordSize() - this.getRecordHeaderSize()) + "]";
    }

    public Pair<byte[], byte[]> readFullByteArray(Iterable<DynamicRecord> records, PropertyType propertyType) {
        for (DynamicRecord record : records) {
            this.ensureHeavy(record);
        }
        return AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, propertyType);
    }

    private static enum HeaderReadResult {
        DATA,
        NO_DATA,
        NOT_IN_USE,
        ILLEGAL_SIZE;

    }

    public class DynamicRecordCursor
    extends GenericCursor<DynamicRecord> {
        private PageCursor cursor;
        long blockId;
        int noNextBlock;
        private final DynamicRecord record;

        public DynamicRecordCursor() {
            this.record = new DynamicRecord(this.blockId);
        }

        public void init(long startBlockId, PageCursor cursor) {
            this.cursor = cursor;
            this.blockId = startBlockId;
            this.noNextBlock = Record.NO_NEXT_BLOCK.intValue();
        }

        public boolean next() {
            try {
                if (this.blockId != (long)this.noNextBlock && this.cursor.next(AbstractDynamicStore.this.pageIdForRecord(this.blockId))) {
                    HeaderReadResult headerReadResult;
                    this.record.setId(this.blockId);
                    do {
                        this.cursor.setOffset(AbstractDynamicStore.this.offsetForId(this.blockId));
                        headerReadResult = AbstractDynamicStore.this.readRecordHeader(this.cursor, this.record, true);
                        if (headerReadResult != HeaderReadResult.DATA) continue;
                        AbstractDynamicStore.this.readRecordData(this.cursor, this.record);
                    } while (this.cursor.shouldRetry());
                    AbstractDynamicStore.this.checkForIllegalSize(headerReadResult, this.record);
                    this.current = this.record;
                    this.blockId = this.record.getNextBlock();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        public void close() {
            this.cursor.close();
            this.cursor = null;
        }
    }
}

