/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;

public class KernelTransactionsSnapshot {
    private Tx relevantTransactions;
    private final long snapshotTime;

    public KernelTransactionsSnapshot(Set<KernelTransactionImplementation> allTransactions, long snapshotTime) {
        Tx head = null;
        for (KernelTransactionImplementation tx : allTransactions) {
            if (!tx.isOpen()) continue;
            Tx current = new Tx(tx, tx.getReuseCount());
            if (head != null) {
                current.next = head;
                head = current;
                continue;
            }
            head = current;
        }
        this.relevantTransactions = head;
        this.snapshotTime = snapshotTime;
    }

    public boolean allClosed() {
        while (this.relevantTransactions != null) {
            if (!this.relevantTransactions.haveClosed()) {
                return false;
            }
            this.relevantTransactions = this.relevantTransactions.next;
        }
        return true;
    }

    public long snapshotTime() {
        return this.snapshotTime;
    }

    private static class Tx {
        private final KernelTransactionImplementation transaction;
        private final int reuseCount;
        private Tx next;

        Tx(KernelTransactionImplementation tx, int reuseCount) {
            this.transaction = tx;
            this.reuseCount = reuseCount;
        }

        boolean haveClosed() {
            return this.transaction.getReuseCount() != this.reuseCount;
        }
    }
}

