/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import org.neo4j.kernel.impl.store.id.IdSequence;

public class BatchingIdSequence
implements IdSequence {
    private long nextId = 0L;

    public BatchingIdSequence() {
        this(0L);
    }

    public BatchingIdSequence(long startingId) {
        this.nextId = startingId;
    }

    @Override
    public long nextId() {
        long result = this.peek();
        ++this.nextId;
        return result;
    }

    public void reset() {
        this.nextId = 0L;
    }

    public void set(long nextId) {
        this.nextId = nextId;
    }

    public long peek() {
        if (this.nextId == 0xFFFFFFFFL) {
            ++this.nextId;
        }
        return this.nextId;
    }
}

