/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class OffHeapLongArray
extends OffHeapNumberArray
implements LongArray {
    private final long defaultValue;

    public OffHeapLongArray(long length, long defaultValue) {
        super(length, 3);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public long get(long index) {
        return UnsafeUtil.getLong((long)this.addressOf(index));
    }

    @Override
    public void set(long index, long value) {
        UnsafeUtil.putLong((long)this.addressOf(index), (long)value);
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory((long)this.address, (long)(this.length << this.shift), (byte)((byte)this.defaultValue));
        } else {
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.putLong((long)adr, (long)this.defaultValue);
                ++i;
                adr += (long)this.stride;
            }
        }
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        long fromAddress = this.addressOf(fromIndex);
        long toAddress = this.addressOf(toIndex);
        int i = 0;
        while (i < numberOfEntries) {
            long fromValue = UnsafeUtil.getLong((long)fromAddress);
            UnsafeUtil.putLong((long)fromAddress, (long)UnsafeUtil.getLong((long)toAddress));
            UnsafeUtil.putLong((long)toAddress, (long)fromValue);
            ++i;
            fromAddress += (long)this.stride;
            toAddress += (long)this.stride;
        }
    }

    @Override
    public LongArray fixate() {
        return this;
    }
}

