/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.helpers.SillyUtils;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexingService;

public class NeoStoreFileListing {
    private final File storeDir;
    private final LabelScanStore labelScanStore;
    private final IndexingService indexingService;
    private final LegacyIndexProviderLookup legacyIndexProviders;

    public NeoStoreFileListing(File storeDir, LabelScanStore labelScanStore, IndexingService indexingService, LegacyIndexProviderLookup legacyIndexProviders) {
        this.storeDir = storeDir;
        this.labelScanStore = labelScanStore;
        this.indexingService = indexingService;
        this.legacyIndexProviders = legacyIndexProviders;
    }

    public ResourceIterator<File> listStoreFiles(boolean includeLogs) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.gatherNeoStoreFiles(files, includeLogs);
        Resource labelScanStoreSnapshot = this.gatherLabelScanStoreFiles(files);
        Resource schemaIndexSnapshots = this.gatherSchemaIndexFiles(files);
        Resource legacyIndexSnapshots = this.gatherLegacyIndexFiles(files);
        return IteratorUtil.resourceIterator(files.iterator(), (Resource)new MultiResource(Arrays.asList(labelScanStoreSnapshot, schemaIndexSnapshots, legacyIndexSnapshots)));
    }

    private Resource gatherLegacyIndexFiles(Collection<File> files) throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexImplementation indexProvider : this.legacyIndexProviders.all()) {
            ResourceIterator<File> snapshot = indexProvider.listStoreFiles();
            snapshots.add(snapshot);
            IteratorUtil.addToCollection(snapshot, files);
        }
        return new MultiResource(snapshots);
    }

    private Resource gatherSchemaIndexFiles(Collection<File> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.indexingService.snapshotStoreFiles();
        IteratorUtil.addToCollection(snapshot, targetFiles);
        return snapshot;
    }

    private Resource gatherLabelScanStoreFiles(Collection<File> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.labelScanStore.snapshotStoreFiles();
        IteratorUtil.addToCollection(snapshot, targetFiles);
        return snapshot;
    }

    private void gatherNeoStoreFiles(Collection<File> targetFiles, boolean includeTransactionLogs) {
        File neostoreFile = null;
        for (File dbFile : SillyUtils.nonNull(this.storeDir.listFiles())) {
            String name = dbFile.getName();
            if (!dbFile.isFile()) continue;
            if (name.equals("neostore")) {
                neostoreFile = dbFile;
                continue;
            }
            if (this.neoStoreFile(name)) {
                targetFiles.add(dbFile);
                continue;
            }
            if (!includeTransactionLogs || !this.transactionLogFile(name)) continue;
            targetFiles.add(dbFile);
        }
        targetFiles.add(neostoreFile);
    }

    private boolean neoStoreFile(String name) {
        if (name.endsWith(".id")) {
            return false;
        }
        if (name.equals("index.db")) {
            return true;
        }
        return name.startsWith("neostore") && !name.startsWith("neostore.transaction");
    }

    private boolean transactionLogFile(String name) {
        return name.startsWith("neostore.transaction") && !name.endsWith(".active");
    }

    private static final class MultiResource
    implements Resource {
        private final Collection<? extends Resource> snapshots;

        private MultiResource(Collection<? extends Resource> resources) {
            this.snapshots = resources;
        }

        @Override
        public void close() {
            RuntimeException exception = null;
            for (Resource resource : this.snapshots) {
                try {
                    resource.close();
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

